/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.tags;

import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.registries.holdersets.CompositeHolderSet;
import net.minecraftforge.registries.holdersets.HolderSetType;
import net.minecraftforge.registries.holdersets.ICustomHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;

public class FilterHolderSet<T>
implements ICustomHolderSet<T> {
    private final HolderSet<T> whitelist;
    private final HolderSet<T> blacklist;
    @Nullable
    private Set<Holder<T>> set;
    @Nullable
    private List<Holder<T>> list;

    public FilterHolderSet(HolderSet<T> whitelist, HolderSet<T> blacklist) {
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.whitelist.addInvalidationListener(this::invalidate);
        this.blacklist.addInvalidationListener(this::invalidate);
    }

    public static <T> Builder<T> builder(Registry<T> registry) {
        return new Builder<T>(registry);
    }

    public static <T> Codec<? extends ICustomHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        return RecordCodecBuilder.create(instance -> instance.group((App)HolderSetCodec.m_206685_((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("whitelist").forGetter(f -> f.whitelist), (App)HolderSetCodec.m_206685_((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("blacklist").forGetter(f -> f.blacklist)).apply((Applicative)instance, FilterHolderSet::new));
    }

    public Stream<Holder<T>> m_203614_() {
        return this.whitelist.m_203614_().filter(holder -> !this.blacklist.m_203333_(holder));
    }

    public int m_203632_() {
        return this.getList().size();
    }

    public Either<TagKey<T>, List<Holder<T>>> m_203440_() {
        return Either.right(this.getList());
    }

    public Optional<Holder<T>> m_213653_(RandomSource rand) {
        List<Holder<T>> l = this.getList();
        int size = l.size();
        if (size > 0) {
            return Optional.of(l.get(rand.m_188503_(size)));
        }
        return Optional.empty();
    }

    public Holder<T> m_203662_(int index) {
        return this.getList().get(index);
    }

    public boolean m_203333_(Holder<T> holder) {
        return this.getSet().contains(holder);
    }

    public boolean m_207277_(Registry<T> registry) {
        return true;
    }

    public Iterator<Holder<T>> iterator() {
        return this.getList().iterator();
    }

    public HolderSetType type() {
        return SGRegistry.HolderSetTypes.FILTER.get();
    }

    private void invalidate() {
        this.set = null;
        this.list = null;
    }

    private List<Holder<T>> getList() {
        if (this.list == null) {
            this.list = List.copyOf(this.getSet());
        }
        return this.list;
    }

    private Set<Holder<T>> getSet() {
        if (this.set == null) {
            this.set = this.m_203614_().collect(Collectors.toSet());
        }
        return this.set;
    }

    public List<String> toFilterStrings(Registry<T> registry) {
        List<String> vals = this.valuesToStrings(registry, this.whitelist);
        this.valuesToStrings(registry, this.blacklist).stream().map(s -> "!" + s).forEach(vals::add);
        return vals;
    }

    private List<String> valuesToStrings(Registry<T> registry, HolderSet<T> holderSet) {
        ArrayList<String> values = new ArrayList<String>();
        if (holderSet instanceof HolderSet.Named) {
            HolderSet.Named named = (HolderSet.Named)holderSet;
            values.add("#" + named.m_205839_().f_203868_().toString());
        } else if (holderSet instanceof CompositeHolderSet) {
            CompositeHolderSet composite = (CompositeHolderSet)holderSet;
            composite.getComponents().forEach(hSet -> values.addAll(this.valuesToStrings(registry, (HolderSet<T>)hSet)));
        } else {
            holderSet.m_203614_().map(Holder::m_203543_).filter(Optional::isPresent).map(o -> ((ResourceKey)o.get()).m_135782_().toString()).forEach(values::add);
        }
        return values;
    }

    public String toString(Registry<T> registry) {
        return this.getClass().getSimpleName() + " = " + this.toFilterStrings(registry);
    }

    public static final class Builder<T> {
        private final Registry<T> registry;
        private final LinkedHashSet<ResourceKey<T>> wVals = new LinkedHashSet();
        private final LinkedHashSet<TagKey<T>> wTags = new LinkedHashSet();
        private final LinkedHashSet<HolderSet<T>> wHolderSets = new LinkedHashSet();
        private final LinkedHashSet<ResourceKey<T>> bVals = new LinkedHashSet();
        private final LinkedHashSet<TagKey<T>> bTags = new LinkedHashSet();
        private final LinkedHashSet<HolderSet<T>> bHolderSets = new LinkedHashSet();

        private Builder(Registry<T> registry) {
            this.registry = registry;
        }

        public final Builder<T> values(boolean whitelist, Collection<ResourceKey<T>> names) {
            if (whitelist) {
                this.wVals.addAll(names);
            } else {
                this.bVals.addAll(names);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> values(boolean whitelist, ResourceKey<T> ... keys) {
            return this.values(whitelist, List.of(keys));
        }

        @SafeVarargs
        public final Builder<T> values(boolean whitelist, Registrar<T> ... objects) {
            return this.values(whitelist, Arrays.stream(objects).map(Registrar::getKey).toList());
        }

        public final Builder<T> tags(boolean whitelist, Collection<TagKey<T>> tags) {
            if (whitelist) {
                this.wTags.addAll(tags);
            } else {
                this.bTags.addAll(tags);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> tags(boolean whitelist, TagKey<T> ... tags) {
            return this.tags(whitelist, List.of(tags));
        }

        public final Builder<T> holderSets(boolean whitelist, Collection<HolderSet<T>> holderSets) {
            if (whitelist) {
                this.wHolderSets.addAll(holderSets);
            } else {
                this.bHolderSets.addAll(holderSets);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<T> holderSets(boolean whitelist, HolderSet<T> ... holderSets) {
            return this.holderSets(whitelist, List.of(holderSets));
        }

        public FilterHolderSet<T> build() {
            return new FilterHolderSet<T>(this.compileList(this.registry, this.wVals, this.wTags, this.wHolderSets), this.compileList(this.registry, this.bVals, this.bTags, this.bHolderSets));
        }

        /*
         * Unable to fully structure code
         */
        private HolderSet<T> compileList(Registry<T> registry, Collection<ResourceKey<T>> keys, Collection<TagKey<T>> tags, Collection<HolderSet<T>> holderSets) {
            compiledSets = new ArrayList<Object>();
            if (!(registry instanceof MappedRegistry)) ** GOTO lbl-1000
            mapped = (MappedRegistry)registry;
            if (mapped.f_205845_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = frozen = false;
            }
            if (!keys.isEmpty()) {
                if (frozen) {
                    compiledSets.add(HolderSet.m_205800_(keys.stream().map((Function<ResourceKey, Optional>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, m_203636_(net.minecraft.resources.ResourceKey ), (Lnet/minecraft/resources/ResourceKey;)Ljava/util/Optional;)(registry)).filter((Predicate<Optional>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isPresent(), (Ljava/util/Optional;)Z)()).map((Function<Optional, Holder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(), (Ljava/util/Optional;)Lnet/minecraft/core/Holder;)()).toList()));
                } else {
                    compiledSets.add(HolderSet.m_205800_(keys.stream().map((Function<ResourceKey, Holder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, m_214121_(net.minecraft.resources.ResourceKey ), (Lnet/minecraft/resources/ResourceKey;)Lnet/minecraft/core/Holder;)(registry)).toList()));
                }
            }
            if (!tags.isEmpty()) {
                if (frozen) {
                    compiledSets.addAll(tags.stream().map((Function<TagKey, Optional>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, m_203431_(net.minecraft.tags.TagKey ), (Lnet/minecraft/tags/TagKey;)Ljava/util/Optional;)(registry)).filter((Predicate<Optional>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isPresent(), (Ljava/util/Optional;)Z)()).map((Function<Optional, HolderSet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compileList$0(java.util.Optional ), (Ljava/util/Optional;)Lnet/minecraft/core/HolderSet;)()).toList());
                } else {
                    compiledSets.addAll(tags.stream().map((Function<TagKey, HolderSet.Named>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, m_203561_(net.minecraft.tags.TagKey ), (Lnet/minecraft/tags/TagKey;)Lnet/minecraft/core/HolderSet$Named;)(registry)).map((Function<HolderSet.Named, HolderSet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compileList$1(net.minecraft.core.HolderSet$Named ), (Lnet/minecraft/core/HolderSet$Named;)Lnet/minecraft/core/HolderSet;)()).toList());
                }
            }
            if (!holderSets.isEmpty()) {
                compiledSets.addAll(holderSets);
            }
            if (compiledSets.isEmpty()) {
                return HolderSet.m_205809_((Holder[])new Holder[0]);
            }
            return new OrHolderSet(compiledSets);
        }

        private static /* synthetic */ HolderSet lambda$compileList$1(HolderSet.Named n) {
            return n;
        }

        private static /* synthetic */ HolderSet lambda$compileList$0(Optional n) {
            return (HolderSet)n.get();
        }
    }
}

