/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util.math;

import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class UtilGeometry {
    public static final Random RANDOM = new Random();
    public static boolean DEBUG_CATMULLROM = false;

    public static boolean isPointInsideCone(Vec3 point, Vec3 origin, Vec3 direction, double maxAngle, double maxDistance) {
        Vec3 diff = point.m_82546_(origin);
        double dist = diff.m_82553_();
        if (dist > maxDistance) {
            return false;
        }
        double dot = diff.m_82526_(direction);
        double mag = dist * direction.m_82553_();
        double angle = Math.acos(dot / mag);
        return !((angle = Math.toDegrees(angle)) > maxAngle);
    }

    public static double angleBetween(Vec3 dir, Vec3 base) {
        double dot = dir.m_82526_(base);
        double mag = Math.sqrt(dir.m_82556_() * base.m_82556_());
        return Math.acos(dot / mag);
    }

    public static double angleBetweenDegrees(Vec3 dir, Vec3 base) {
        return Math.toDegrees(UtilGeometry.angleBetween(dir, base));
    }

    public static double angleBetweenVecPlane(Vec3 dir, Vec3 planeNormal) {
        double a = UtilGeometry.angleBetween(dir, planeNormal);
        return 1.5707963267948966 - a;
    }

    public static double angleBetweenVecPlaneDegrees(Vec3 dir, Vec3 planeNormal) {
        return Math.toDegrees(UtilGeometry.angleBetweenVecPlane(dir, planeNormal));
    }

    public static Vec3 interceptPos(Vec3 mPos, Vec3 mVel, Vec3 tPos, Vec3 tVel) {
        double x = UtilGeometry.interceptComponent(mPos.f_82479_, tPos.f_82479_, mVel.f_82479_, tVel.f_82479_);
        double y = UtilGeometry.interceptComponent(mPos.f_82480_, tPos.f_82480_, mVel.f_82480_, tVel.f_82480_);
        double z = UtilGeometry.interceptComponent(mPos.f_82481_, tPos.f_82481_, mVel.f_82481_, tVel.f_82481_);
        return new Vec3(x, y, z);
    }

    private static double interceptComponent(double mPos, double tPos, double mVel, double tVel) {
        double dp = tPos - mPos;
        double dv = tVel - mVel;
        if (dp > 0.0 && dv < 0.0 || dp < 0.0 && dv > 0.0) {
            tPos += tVel * dp / -dv;
        }
        return tPos;
    }

    public static Vec3 vecCompByAxis(Vec3 u, Vec3 v) {
        if (UtilGeometry.isZero(v)) {
            return Vec3.f_82478_;
        }
        return v.m_82490_(u.m_82526_(v) / v.m_82556_());
    }

    public static Vec3 vecCompByNormAxis(Vec3 u, Vec3 n) {
        return n.m_82490_(u.m_82526_(n));
    }

    public static double vecCompMagSqrDirByAxis(Vec3 u, Vec3 v) {
        if (UtilGeometry.isZero(v)) {
            return 0.0;
        }
        double dot = u.m_82526_(v);
        double vl2 = v.m_82556_();
        Vec3 vec = v.m_82490_(dot / vl2);
        return vec.m_82556_() * Math.signum(dot);
    }

    public static double vecCompMagSqrDirByNormAxis(Vec3 u, Vec3 n) {
        double dot = u.m_82526_(n);
        Vec3 vec = n.m_82490_(dot);
        return vec.m_82556_() * Math.signum(dot);
    }

    public static double vecCompMagDirByAxis(Vec3 u, Vec3 v) {
        if (UtilGeometry.isZero(v)) {
            return 0.0;
        }
        double dot = u.m_82526_(v);
        double vl2 = v.m_82556_();
        Vec3 vec = v.m_82490_(dot / vl2);
        return vec.m_82553_() * Math.signum(dot);
    }

    public static double vecCompMagDirByNormAxis(Vec3 u, Vec3 n) {
        double dot = u.m_82526_(n);
        Vec3 vec = n.m_82490_(dot);
        return vec.m_82553_() * Math.signum(dot);
    }

    public static boolean isZero(Vec3 v) {
        return v.f_82479_ == 0.0 && v.f_82480_ == 0.0 && v.f_82481_ == 0.0;
    }

    public static boolean isZero(Vector3f v) {
        return v.m_122239_() == 0.0f && v.m_122260_() == 0.0f && v.m_122269_() == 0.0f;
    }

    public static Vec3 getClosestPointOnAABB(Vec3 pos, AABB aabb) {
        if (pos == null) {
            return aabb.m_82399_();
        }
        double rx = pos.f_82479_;
        double ry = pos.f_82480_;
        double rz = pos.f_82481_;
        if (rx >= aabb.f_82291_) {
            rx = aabb.f_82291_;
        } else if (rx <= aabb.f_82288_) {
            rx = aabb.f_82288_;
        }
        if (ry >= aabb.f_82292_) {
            ry = aabb.f_82292_;
        } else if (ry <= aabb.f_82289_) {
            ry = aabb.f_82289_;
        }
        if (rz >= aabb.f_82293_) {
            rz = aabb.f_82293_;
        } else if (rz <= aabb.f_82290_) {
            rz = aabb.f_82290_;
        }
        return new Vec3(rx, ry, rz);
    }

    public static boolean vec3NAN(Vec3 v) {
        return Double.isNaN(v.f_82479_) || Double.isNaN(v.f_82480_) || Double.isNaN(v.f_82481_);
    }

    public static int[] worldToScreenPosInt(Vec3 world_pos, Matrix4f view_mat, Matrix4f proj_mat, int width, int height) {
        float[] sp = UtilGeometry.worldToScreenPos(world_pos, view_mat, proj_mat, width, height);
        return new int[]{(int)sp[0], (int)sp[1]};
    }

    public static float[] worldToScreenPos(Vec3 world_pos, Matrix4f view_mat, Matrix4f proj_mat, int width, int height) {
        Vector4f clipSpace = new Vector4f((float)world_pos.f_82479_, (float)world_pos.f_82480_, (float)world_pos.f_82481_, 1.0f);
        clipSpace.m_123607_(view_mat);
        clipSpace.m_123607_(proj_mat);
        if (clipSpace.m_123617_() <= 0.0f) {
            return new float[]{-1.0f, -1.0f};
        }
        Vector3f ndcSpace = new Vector3f(clipSpace);
        ndcSpace.m_122261_(1.0f / clipSpace.m_123617_());
        float win_x = (ndcSpace.m_122239_() + 1.0f) / 2.0f * (float)width;
        float win_y = (ndcSpace.m_122260_() + 1.0f) / 2.0f * (float)height;
        return new float[]{win_x, (float)height - win_y};
    }

    public static Vector3f convertVector(Vec3 v) {
        return new Vector3f((float)v.f_82479_, (float)v.f_82480_, (float)v.f_82481_);
    }

    public static Vec3 convertVector(Vector3f v) {
        return new Vec3((double)v.m_122239_(), (double)v.m_122260_(), (double)v.m_122269_());
    }

    public static Vec3 getBBFeet(AABB bb) {
        return new Vec3(bb.m_82399_().f_82479_, bb.f_82289_, bb.m_82399_().f_82481_);
    }

    public static Vec3 toFloats(Vec3 v) {
        return new Vec3((double)((float)v.f_82479_), (double)((float)v.f_82480_), (double)((float)v.f_82481_));
    }

    public static Vec3 toVec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static Vec3 inaccurateTargetPos(Vec3 origin, Vec3 targetPos, float inaccuracy) {
        double dist = origin.m_82554_(targetPos);
        double i = dist * Math.tan((float)Math.PI / 180 * inaccuracy);
        return targetPos.m_82520_((RANDOM.nextDouble() - 0.5) * i, (RANDOM.nextDouble() - 0.5) * i, (RANDOM.nextDouble() - 0.5) * i);
    }

    public static boolean isEqual(Vec3 v1, Vec3 v2) {
        return v1.f_82479_ == v2.f_82479_ && v1.f_82480_ == v2.f_82480_ && v1.f_82481_ == v2.f_82481_;
    }

    public static boolean isEqual(Vec3 a, Vec3 b, double maxDiff) {
        return Math.abs(a.f_82479_ - b.f_82479_) <= maxDiff && Math.abs(a.f_82480_ - b.f_82480_) <= maxDiff && Math.abs(a.f_82481_ - b.f_82481_) <= maxDiff;
    }

    public static double[] roots(double a, double b, double c) {
        double[] roots = new double[4];
        double d = b * b - 4.0 * a * c;
        if (d > 0.0) {
            double sqrtD = Math.sqrt(d);
            roots[0] = (-b + sqrtD) / (2.0 * a);
            roots[1] = 0.0;
            roots[2] = (-b - sqrtD) / (2.0 * a);
            roots[3] = 0.0;
        } else if (d == 0.0) {
            double root;
            roots[0] = root = -b / (2.0 * a);
            roots[1] = 0.0;
            roots[2] = root;
            roots[3] = 0.0;
        } else {
            double real = -b / (2.0 * a);
            double imaginary = Math.sqrt(-d) / (2.0 * a);
            roots[0] = real;
            roots[1] = imaginary;
            roots[2] = real;
            roots[3] = -imaginary;
        }
        return roots;
    }

    @Nullable
    public static double[] rootsNoI(double a, double b, double c) {
        double d = b * b - 4.0 * a * c;
        if (d < 0.0) {
            return null;
        }
        double[] roots = new double[2];
        if (d == 0.0) {
            double root;
            roots[0] = root = -b / (2.0 * a);
            roots[1] = root;
        } else {
            double sqrtD = Math.sqrt(d);
            roots[0] = (-b + sqrtD) / (2.0 * a);
            roots[1] = (-b - sqrtD) / (2.0 * a);
        }
        return roots;
    }

    public static int numTrue(boolean[] bools) {
        int num = 0;
        for (int i = 0; i < bools.length; ++i) {
            if (!bools[i]) continue;
            ++num;
        }
        return num;
    }

    public static int getMaxYIndex(Vec3[] array) {
        if (array.length == 0) {
            return -1;
        }
        int maxIndex = 0;
        double max = array[0].f_82480_;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].f_82480_ > max)) continue;
            maxIndex = i;
            max = array[i].f_82480_;
        }
        return maxIndex;
    }

    public static int getMinYIndex(Vec3[] array) {
        if (array.length == 0) {
            return -1;
        }
        int minIndex = 0;
        double min = array[0].f_82480_;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].f_82480_ < min)) continue;
            minIndex = i;
            min = array[i].f_82480_;
        }
        return minIndex;
    }

    public static int getMaxXIndex(Vec3[] array) {
        if (array.length == 0) {
            return -1;
        }
        int maxIndex = 0;
        double max = array[0].f_82479_;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].f_82479_ > max)) continue;
            maxIndex = i;
            max = array[i].f_82479_;
        }
        return maxIndex;
    }

    public static int getMinXIndex(Vec3[] array) {
        if (array.length == 0) {
            return -1;
        }
        int minIndex = 0;
        double min = array[0].f_82479_;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].f_82479_ < min)) continue;
            minIndex = i;
            min = array[i].f_82479_;
        }
        return minIndex;
    }

    public static int getMaxZIndex(Vec3[] array) {
        if (array.length == 0) {
            return -1;
        }
        int maxIndex = 0;
        double max = array[0].f_82481_;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].f_82481_ > max)) continue;
            maxIndex = i;
            max = array[i].f_82481_;
        }
        return maxIndex;
    }

    public static int getMinZIndex(Vec3[] array) {
        if (array.length == 0) {
            return -1;
        }
        int minIndex = 0;
        double min = array[0].f_82481_;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i].f_82481_ < min)) continue;
            minIndex = i;
            min = array[i].f_82481_;
        }
        return minIndex;
    }

    public static int getMinIndex(double[] array) {
        if (array.length == 0) {
            return -1;
        }
        int minIndex = 0;
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            minIndex = i;
            min = array[i];
        }
        return minIndex;
    }

    public static float crossProduct(Vec2 v1, Vec2 v2) {
        return v1.f_82470_ * v2.f_82471_ - v1.f_82471_ * v2.f_82470_;
    }

    public static boolean isIn2DTriangle(Vec2 p, Vec2[] v) {
        if (v.length < 3) {
            return false;
        }
        float area = 0.5f * (-v[1].f_82471_ * v[2].f_82470_ + v[0].f_82471_ * (-v[1].f_82470_ + v[2].f_82470_) + v[0].f_82470_ * (v[1].f_82471_ - v[2].f_82471_) + v[1].f_82470_ * v[2].f_82471_);
        float a = 1.0f / (2.0f * area);
        float s0 = a * (v[0].f_82471_ * v[2].f_82470_ - v[0].f_82470_ * v[2].f_82471_ + (v[2].f_82471_ - v[0].f_82471_) * p.f_82470_ + (v[0].f_82470_ - v[2].f_82470_) * p.f_82471_);
        float t0 = a * (v[0].f_82470_ * v[1].f_82471_ - v[0].f_82471_ * v[1].f_82470_ + (v[0].f_82471_ - v[1].f_82471_) * p.f_82470_ + (v[1].f_82470_ - v[0].f_82470_) * p.f_82471_);
        return s0 >= 0.0f && t0 >= 0.0f && 1.0f - s0 - t0 >= 0.0f;
    }

    public static boolean isIn2DQuad(Vec2 p, Vec2[] v) {
        if (v.length < 4) {
            return false;
        }
        Vec2[] t1 = new Vec2[]{v[0], v[1], v[2]};
        Vec2[] t2 = new Vec2[]{v[0], v[2], v[3]};
        return UtilGeometry.isIn2DTriangle(p, t1) || UtilGeometry.isIn2DTriangle(p, t2);
    }

    public static int add(int n, int a, int max) {
        double r = (double)(n += a) / (double)max;
        return n -= (int)r * max;
    }

    @Nullable
    public static Vec2 intersect(Vec2 as, Vec2 ae, Vec2 bs, Vec2 be) {
        Vec2 ad = ae.m_165910_(as.m_165913_());
        Vec2 bd = be.m_165910_(bs.m_165913_());
        float det = UtilGeometry.crossProduct(bd, ad);
        if (det == 0.0f) {
            return null;
        }
        Vec2 D = bs.m_165910_(as.m_165913_());
        float u = (D.f_82471_ * bd.f_82470_ - D.f_82470_ * bd.f_82471_) / det;
        return as.m_165910_(ad.m_165903_(u));
    }

    public static float[] calcCatmullromTs(float a, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        float t0 = 0.0f;
        float t1 = UtilGeometry.calcT(x0, x1, y0, y1, t0, a);
        float t2 = UtilGeometry.calcT(x1, x2, y1, y2, t1, a);
        float t3 = UtilGeometry.calcT(x2, x3, y2, y3, t2, a);
        return new float[]{t0, t1, t2, t3};
    }

    public static float[] calcCatmullromTs(float a, Vec2 P0, Vec2 P1, Vec2 P2, Vec2 P3) {
        return UtilGeometry.calcCatmullromTs(a, P0.f_82470_, P0.f_82471_, P1.f_82470_, P1.f_82471_, P2.f_82470_, P2.f_82471_, P3.f_82470_, P3.f_82471_);
    }

    public static float findYInCatmullromArray(float x, Vec2[] cmr) {
        if (cmr.length == 0) {
            return 0.0f;
        }
        if (x <= cmr[0].f_82470_) {
            return cmr[0].f_82471_;
        }
        for (int i = 1; i < cmr.length; ++i) {
            Vec2 now = cmr[i];
            if (x == now.f_82470_) {
                return now.f_82471_;
            }
            if (x > now.f_82470_) continue;
            Vec2 prev = cmr[i - 1];
            float p = (x - prev.f_82470_) / (now.f_82470_ - prev.f_82470_);
            return Mth.m_14179_((float)p, (float)prev.f_82471_, (float)now.f_82471_);
        }
        return cmr[cmr.length - 1].f_82471_;
    }

    public static Vec2[] catmullromArray(int points, float a, Vec2 P0, Vec2 P1, Vec2 P2, Vec2 P3) {
        int i;
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        if (DEBUG_CATMULLROM) {
            System.out.println("CALC CMR array: ");
        }
        if (DEBUG_CATMULLROM) {
            System.out.println("points = " + points + UtilParse.prettyVec2(P0) + UtilParse.prettyVec2(P1) + UtilParse.prettyVec2(P2) + UtilParse.prettyVec2(P3));
        }
        float[] ts = UtilGeometry.calcCatmullromTs(a, P0, P1, P2, P3);
        if (DEBUG_CATMULLROM) {
            System.out.println("ts = " + Arrays.toString(ts));
        }
        float tStep = 1.0f / (float)points;
        Vec2[] array = new Vec2[points];
        for (i = 0; i < array.length; ++i) {
            array[i] = UtilGeometry.catmullrom(tStep * (float)i, P0, P1, P2, P3, ts);
        }
        if (DEBUG_CATMULLROM) {
            System.out.print("cmrs =");
            for (i = 0; i < array.length; ++i) {
                System.out.print(" " + UtilParse.prettyVec2(array[i]));
            }
            System.out.println();
        }
        return array;
    }

    public static Vec2[] catmullromArray(int points, float a, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        return UtilGeometry.catmullromArray(points, a, new Vec2(x0, y0), new Vec2(x1, y1), new Vec2(x2, y2), new Vec2(x3, y3));
    }

    public static Vec2 catmullrom(float t, float a, Vec2 P0, Vec2 P1, Vec2 P2, Vec2 P3) {
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        float[] ts = UtilGeometry.calcCatmullromTs(a, P0, P1, P2, P3);
        return UtilGeometry.catmullrom(t, P0, P1, P2, P3, ts);
    }

    private static Vec2 catmullrom(float t, Vec2 P0, Vec2 P1, Vec2 P2, Vec2 P3, float[] ts) {
        if (t == 0.0f) {
            return P1;
        }
        if (t == 1.0f) {
            return P2;
        }
        float t0 = ts[0];
        float t1 = ts[1];
        float t2 = ts[2];
        float t3 = ts[3];
        t = Mth.m_14179_((float)t, (float)t1, (float)t2);
        Vec2 A2 = P1.m_165903_(UtilGeometry.slope(t2, t, t2, t1)).m_165910_(P2.m_165903_(UtilGeometry.slope(t, t1, t2, t1)));
        if (t2 == t3) {
            Vec2 A1 = P0.m_165903_(UtilGeometry.slope(t1, t, t1, t0)).m_165910_(P1.m_165903_(UtilGeometry.slope(t, t0, t1, t0)));
            Vec2 B1 = A1.m_165903_(UtilGeometry.slope(t2, t, t2, t0)).m_165910_(A2.m_165903_(UtilGeometry.slope(t, t0, t2, t0)));
            return B1;
        }
        if (t0 == t1) {
            Vec2 A3 = P2.m_165903_(UtilGeometry.slope(t3, t, t3, t2)).m_165910_(P3.m_165903_(UtilGeometry.slope(t, t2, t3, t2)));
            Vec2 B2 = A2.m_165903_(UtilGeometry.slope(t3, t, t3, t1)).m_165910_(A3.m_165903_(UtilGeometry.slope(t, t1, t3, t1)));
            return B2;
        }
        Vec2 A1 = P0.m_165903_(UtilGeometry.slope(t1, t, t1, t0)).m_165910_(P1.m_165903_(UtilGeometry.slope(t, t0, t1, t0)));
        Vec2 A3 = P2.m_165903_(UtilGeometry.slope(t3, t, t3, t2)).m_165910_(P3.m_165903_(UtilGeometry.slope(t, t2, t3, t2)));
        Vec2 B1 = A1.m_165903_(UtilGeometry.slope(t2, t, t2, t0)).m_165910_(A2.m_165903_(UtilGeometry.slope(t, t0, t2, t0)));
        Vec2 B2 = A2.m_165903_(UtilGeometry.slope(t3, t, t3, t1)).m_165910_(A3.m_165903_(UtilGeometry.slope(t, t1, t3, t1)));
        return B1.m_165903_(UtilGeometry.slope(t2, t, t2, t1)).m_165910_(B2.m_165903_(UtilGeometry.slope(t, t1, t2, t1)));
    }

    private static float slope(float y1, float y0, float x1, float x0) {
        return (y1 - y0) / (x1 - x0);
    }

    private static float calcT(float x0, float x1, float y0, float y1, float t0, float a) {
        return (float)Math.pow(Mth.m_14116_((float)((float)(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0)))), a) + t0;
    }

    public static Vec3[] getSizeCenter(Vec3 ... positions) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (Vec3 pos : positions) {
            if (pos.m_7096_() < minX) {
                minX = pos.m_7096_();
            }
            if (pos.m_7098_() < minY) {
                minY = pos.m_7098_();
            }
            if (pos.m_7094_() < minZ) {
                minZ = pos.m_7094_();
            }
            if (pos.m_7096_() > maxX) {
                maxX = pos.m_7096_();
            }
            if (pos.m_7098_() > maxY) {
                maxY = pos.m_7098_();
            }
            if (!(pos.m_7094_() > maxZ)) continue;
            maxZ = pos.m_7094_();
        }
        Vec3 size = new Vec3(maxX - minX, maxY - minY, maxZ - minZ);
        Vec3 center = new Vec3(minX, minY, minZ).m_82549_(size.m_82490_(0.5));
        return new Vec3[]{size, center};
    }

    public static Vec3[] getSizeCenter(List<Vector3f> positions) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (Vector3f pos : positions) {
            if ((double)pos.m_122239_() < minX) {
                minX = pos.m_122239_();
            }
            if ((double)pos.m_122260_() < minY) {
                minY = pos.m_122260_();
            }
            if ((double)pos.m_122269_() < minZ) {
                minZ = pos.m_122269_();
            }
            if ((double)pos.m_122239_() > maxX) {
                maxX = pos.m_122239_();
            }
            if ((double)pos.m_122260_() > maxY) {
                maxY = pos.m_122260_();
            }
            if (!((double)pos.m_122269_() > maxZ)) continue;
            maxZ = pos.m_122269_();
        }
        Vec3 size = new Vec3(maxX - minX, maxY - minY, maxZ - minZ);
        Vec3 center = new Vec3(minX, minY, minZ).m_82549_(size.m_82490_(0.5));
        return new Vec3[]{size, center};
    }
}

