/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.intellij.lang.annotations.Language;

public class JsonToNBTUtil {
    protected static final Map<Class<?>, Function<Number, NumericTag>> numericConstructors = (Map)Util.m_137469_(new HashMap(), m -> {
        m.put(ByteTag.class, n -> ByteTag.m_128266_((byte)n.byteValue()));
        m.put(ShortTag.class, n -> ShortTag.m_129258_((short)n.shortValue()));
        m.put(IntTag.class, n -> IntTag.m_128679_((int)n.intValue()));
        m.put(LongTag.class, n -> LongTag.m_128882_((long)n.longValue()));
        m.put(FloatTag.class, n -> FloatTag.m_128566_((float)n.floatValue()));
        m.put(DoubleTag.class, n -> DoubleTag.m_128500_((double)n.doubleValue()));
    });
    private static final Map<Pattern, Function<String, Tag>> PATTERN_MAP = new LinkedHashMap<Pattern, Function<String, Tag>>();

    public static CompoundTag getTagFromJson(JsonElement element) {
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Tag must be an object");
        }
        return JsonToNBTUtil.readObject(element.getAsJsonObject());
    }

    public static CompoundTag getTagFromJson(String json) {
        return JsonToNBTUtil.getTagFromJson(json, false);
    }

    public static CompoundTag getTagFromJson(String json, boolean lenient) {
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        reader.setLenient(lenient);
        return JsonToNBTUtil.getTagFromJson(new JsonParser().parse(reader));
    }

    public static CompoundTag getTagFromJson(Reader json) {
        return JsonToNBTUtil.getTagFromJson(new JsonParser().parse(json));
    }

    public static CompoundTag getTagFromJson(JsonReader json) {
        return JsonToNBTUtil.getTagFromJson(new JsonParser().parse(json));
    }

    private static Tag readElement(JsonElement elem) {
        if (elem.isJsonNull()) {
            throw new JsonSyntaxException("Null value is not allowed in NBT JSON");
        }
        if (elem.isJsonObject()) {
            return JsonToNBTUtil.readObject(elem.getAsJsonObject());
        }
        if (elem.isJsonArray()) {
            return JsonToNBTUtil.readArray(elem.getAsJsonArray());
        }
        if (elem.isJsonPrimitive()) {
            return JsonToNBTUtil.readValue(elem.getAsJsonPrimitive());
        }
        throw new IllegalArgumentException("Unknown JSON type: " + String.valueOf(elem));
    }

    private static CompoundTag readObject(JsonObject obj) {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry child : obj.entrySet()) {
            nbt.m_128365_((String)child.getKey(), JsonToNBTUtil.readElement((JsonElement)child.getValue()));
        }
        return nbt;
    }

    private static Tag readArray(JsonArray array) {
        String type;
        JsonPrimitive prim;
        int n = array.size();
        if (n < 1) {
            return new ListTag();
        }
        JsonElement first = array.get(0);
        String differentTypes = "All elements in array must be of the same type";
        if (first.isJsonPrimitive() && (prim = first.getAsJsonPrimitive()).isString() && ("B".equals(type = prim.getAsString()) || "I".equals(type) || "L".equals(type))) {
            ArrayList<Number> list = new ArrayList<Number>();
            for (int i = 1; i < n; ++i) {
                try {
                    JsonPrimitive p = array.get(i).getAsJsonPrimitive();
                    if (p.isBoolean()) {
                        list.add(p.getAsBoolean() ? 1 : 0);
                        continue;
                    }
                    if (p.isNumber()) {
                        list.add(p.getAsNumber());
                        continue;
                    }
                    throw new JsonSyntaxException("All elements in array must be of the same type");
                }
                catch (IllegalStateException e) {
                    throw new JsonSyntaxException("All elements in array must be of the same type");
                }
            }
            return switch (type) {
                case "B" -> new ByteArrayTag(list.stream().map(Number::byteValue).collect(Collectors.toList()));
                case "I" -> new IntArrayTag(list.stream().map(Number::intValue).collect(Collectors.toList()));
                case "L" -> new LongArrayTag(list.stream().map(Number::longValue).collect(Collectors.toList()));
                default -> throw new IllegalStateException();
            };
        }
        ArrayList<Tag> ls = new ArrayList<Tag>();
        ListTag list = new ListTag();
        for (Object elem : array) {
            ls.add(JsonToNBTUtil.readElement((JsonElement)elem));
        }
        try {
            if (ls.isEmpty()) {
                return list;
            }
            if (ls.get(0) instanceof NumericTag) {
                Class<?> cls = null;
                for (Tag elem : ls) {
                    if (!(elem instanceof NumericTag)) {
                        throw new JsonSyntaxException("All elements in array must be of the same type");
                    }
                    cls = JsonToNBTUtil.combineNumericTypes(cls, elem.getClass());
                }
                Function<Number, NumericTag> con = numericConstructors.get(cls);
                for (Tag elem : ls) {
                    list.add((Object)((Tag)con.apply(((NumericTag)elem).m_8103_())));
                }
            } else {
                list.addAll(ls);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new JsonSyntaxException("All elements in array must be of the same type");
        }
        return list;
    }

    protected static Class<?> combineNumericTypes(Class<?> a, Class<?> b) {
        if (a == FloatTag.class || a == DoubleTag.class || b == FloatTag.class || b == DoubleTag.class) {
            if (a == LongTag.class || a == DoubleTag.class || b == LongTag.class || b == DoubleTag.class) {
                return DoubleTag.class;
            }
            return FloatTag.class;
        }
        if (a == LongTag.class || b == LongTag.class) {
            return LongTag.class;
        }
        if (a == IntTag.class || b == IntTag.class) {
            return IntTag.class;
        }
        if (a == ShortTag.class || b == ShortTag.class) {
            return ShortTag.class;
        }
        return ByteTag.class;
    }

    private static <T> void pat(@Language(value="RegExp") String pattern, Function<String, T> parser, Function<T, Tag> caster) {
        JsonToNBTUtil.pat(pattern, parser.andThen(caster));
    }

    private static void pat(@Language(value="RegExp") String pattern, Function<String, Tag> parser) {
        PATTERN_MAP.put(Pattern.compile(pattern, 2), parser);
    }

    private static Tag readValue(JsonPrimitive elem) {
        if (elem.isBoolean()) {
            return ByteTag.m_128273_((boolean)elem.getAsBoolean());
        }
        if (elem.isNumber()) {
            if (!elem.getAsString().contains(".")) {
                return IntTag.m_128679_((int)elem.getAsInt());
            }
            return DoubleTag.m_128500_((double)elem.getAsDouble());
        }
        if (elem.isString()) {
            String str = elem.getAsString();
            try {
                for (Pattern pattern : PATTERN_MAP.keySet()) {
                    Matcher m = pattern.matcher(str);
                    if (!m.matches()) continue;
                    return PATTERN_MAP.get(pattern).apply(m.group(1));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"' ? StringTag.m_129297_((String)str.substring(1, str.length() - 1)) : StringTag.m_129297_((String)str);
        }
        throw new IllegalStateException("Unknown JSON primitive: " + String.valueOf(elem));
    }

    static {
        JsonToNBTUtil.pat("([-+]?(?:\\d+[.]?|\\d*[.]\\d+)(?:e[-+]?\\d+)?)d", Double::parseDouble, DoubleTag::m_128500_);
        JsonToNBTUtil.pat("([-+]?(?:\\d+[.]?|\\d*[.]\\d+)(?:e[-+]?\\d+)?)f", Float::parseFloat, FloatTag::m_128566_);
        JsonToNBTUtil.pat("([-+]?(?:0|[1-9]\\d*))b", Byte::parseByte, ByteTag::m_128266_);
        JsonToNBTUtil.pat("([-+]?(?:0|[1-9]\\d*))l", Long::parseLong, LongTag::m_128882_);
        JsonToNBTUtil.pat("([-+]?(?:0|[1-9]\\d*))s", Short::parseShort, ShortTag::m_129258_);
        JsonToNBTUtil.pat("([-+]?(?:0|[1-9]\\d*))i", Integer::parseInt, IntTag::m_128679_);
        JsonToNBTUtil.pat("(false|true)", str -> "true".equalsIgnoreCase((String)str) ? ByteTag.f_128257_ : ByteTag.f_128256_);
    }
}

