/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.entity;

import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.PresetNotFoundException;
import com.onewhohears.onewholibs.data.jsonpreset.PresetStatsHolder;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public interface JsonPresetEntityHolder<P extends JsonPresetStats>
extends IEntityAdditionalSpawnData {
    public static final Logger LOGGER = LogUtils.getLogger();

    @NotNull
    public JsonPresetReloadListener<P> getPresets();

    @NotNull
    public String getDefaultStatsId();

    @NotNull
    public String getStatsId();

    @NotNull
    public PresetStatsHolder<P> getStatsHolder();

    @NotNull
    default public PresetStatsHolder<P> createStatsHolder(@NotNull String presetId) {
        return Objects.requireNonNull(this.getPresets().getHolder(presetId));
    }

    default public void updateStatsHolder(@NotNull String presetId) {
        PresetStatsHolder<P> holder = this.createStatsHolder(presetId);
        this.setStatsHolder(holder);
    }

    @NotNull
    default public P getStats() {
        return this.getStatsHolder().get();
    }

    default public void setPreset(@NotNull String preset) {
        if (!this.getPresets().has(preset)) {
            LOGGER.warn("Preset id {} does not exist. Using default id {}", (Object)preset, (Object)this.getDefaultStatsId());
            preset = this.getDefaultStatsId();
            if (!this.getPresets().has(preset)) {
                throw new PresetNotFoundException(preset, this.getPresets());
            }
        }
        if (this.isStatsHolderLoaded() && this.getStatsId().equals(preset)) {
            return;
        }
        this.setStatsId(preset);
        this.updateStatsHolder(preset);
    }

    public void setStatsId(@NotNull String var1);

    public void setStatsHolder(@NotNull PresetStatsHolder<P> var1);

    default public void m_7378_(@NotNull CompoundTag nbt) {
        String preset = nbt.m_128461_("preset");
        if (preset.isEmpty()) {
            preset = this.getDefaultStatsId();
        } else if (!this.getPresets().has(preset)) {
            LOGGER.warn("ERROR: preset {} doesn't exist!", (Object)preset);
            preset = this.getDefaultStatsId();
        }
        this.setStatsId(preset);
        this.updateStatsHolder(this.getStatsId());
    }

    default public void m_7380_(@NotNull CompoundTag nbt) {
        nbt.m_128359_("preset", this.getStatsId());
    }

    default public void readSpawnData(FriendlyByteBuf buffer) {
        this.setStatsId(buffer.m_130277_());
        this.updateStatsHolder(this.getStatsId());
    }

    default public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.getStatsId());
    }

    public boolean isStatsHolderLoaded();

    public boolean isClientSide();
}

