/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.common.network.toclient;

import com.mojang.logging.LogUtils;
import com.onewhohears.onewholibs.common.event.GetJsonPresetListenersEvent;
import com.onewhohears.onewholibs.common.event.RegisterPresetTypesEvent;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.sun.nio.sctp.IllegalReceiveException;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;

public class ToClientDataPackSync {
    static final Logger LOGGER = LogUtils.getLogger();

    public ToClientDataPackSync() {
    }

    public ToClientDataPackSync(FriendlyByteBuf buffer) {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterPresetTypesEvent());
        GetJsonPresetListenersEvent event = new GetJsonPresetListenersEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        List<JsonPresetReloadListener<?>> listeners = event.getListeners();
        int num = buffer.readInt();
        for (int i = 0; i < num; ++i) {
            String name = buffer.m_130277_();
            JsonPresetReloadListener<?> listener = this.getListenerByName(name, listeners);
            if (listener == null) {
                LOGGER.error("Received Json preset data for unknown super type {}. The super type must be registered on the client side as well. Contact developer.", (Object)name);
                throw new IllegalReceiveException("Received Json preset data for unknown super type " + name + ". The super type must be registered on the client side as well. Contact developer.");
            }
            listener.registerDefaultPresetTypes();
            listener.readBuffer(buffer);
        }
    }

    @Nullable
    private JsonPresetReloadListener<?> getListenerByName(String name, List<JsonPresetReloadListener<?>> listeners) {
        for (JsonPresetReloadListener<?> listener : listeners) {
            if (!listener.m_7812_().equals(name)) continue;
            return listener;
        }
        return null;
    }

    public void encode(FriendlyByteBuf buffer) {
        GetJsonPresetListenersEvent event = new GetJsonPresetListenersEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        List<JsonPresetReloadListener<?>> listeners = event.getListeners();
        buffer.writeInt(listeners.size());
        for (JsonPresetReloadListener<?> listener : listeners) {
            buffer.m_130070_(listener.m_7812_());
            listener.writeToBuffer(buffer);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        return true;
    }
}

