/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.bbanims;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KeyframeAnimation;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class BBAnim
implements KeyframeAnimation {
    private final Map<String, Vector3f> pivots;
    private final float length;
    private final List<BBBone> bones = new ArrayList<BBBone>();

    public BBAnim(JsonObject json, Map<String, Vector3f> pivots) {
        this.pivots = pivots;
        this.length = json.get("animation_length").getAsFloat();
        JsonObject bonesJson = json.get("bones").getAsJsonObject();
        Set boneJsons = bonesJson.entrySet();
        for (Map.Entry b : boneJsons) {
            JsonObject bone = ((JsonElement)b.getValue()).getAsJsonObject();
            this.bones.add(new BBBone((String)b.getKey(), bone));
        }
    }

    @Override
    public void applyAnimationAtSecond(Map<String, Matrix4f> transforms, float seconds) {
        this.bones.forEach(bone -> bone.applyAnimationAtSecond(transforms, seconds));
    }

    public Map<String, Vector3f> getPivots() {
        return this.pivots;
    }

    @Override
    public float getAnimationLength() {
        return this.length;
    }

    private static Vec2[][] calcCMRs(float alpha, Keyframe ... kfs) {
        float pointsPerSecond = 30.0f;
        int points = (int)((kfs[3].time - kfs[0].time) * pointsPerSecond);
        Vec2[][] cmrs = new Vec2[3][points];
        cmrs[0] = UtilGeometry.catmullromArray(points, alpha, kfs[0].time, kfs[0].post.m_122239_(), kfs[1].time, kfs[1].post.m_122239_(), kfs[2].time, kfs[2].post.m_122239_(), kfs[3].time, kfs[3].post.m_122239_());
        cmrs[1] = UtilGeometry.catmullromArray(points, alpha, kfs[0].time, kfs[0].post.m_122260_(), kfs[1].time, kfs[1].post.m_122260_(), kfs[2].time, kfs[2].post.m_122260_(), kfs[3].time, kfs[3].post.m_122260_());
        cmrs[2] = UtilGeometry.catmullromArray(points, alpha, kfs[0].time, kfs[0].post.m_122269_(), kfs[1].time, kfs[1].post.m_122269_(), kfs[2].time, kfs[2].post.m_122269_(), kfs[3].time, kfs[3].post.m_122269_());
        return cmrs;
    }

    public static Vector3f fromJsonArray(JsonArray json) {
        float x = json.get(0).getAsFloat();
        float y = json.get(1).getAsFloat();
        float z = json.get(2).getAsFloat();
        return new Vector3f(x, y, z);
    }

    public class BBBone {
        public final String name;
        public final float pivotX;
        public final float pivotY;
        public final float pivotZ;
        public final Transform rotation;
        public final Transform translation;
        public final Transform scale;

        public BBBone(String name, JsonObject json) {
            this.name = name;
            if (BBAnim.this.pivots.containsKey(name)) {
                Vector3f p = BBAnim.this.pivots.get(name);
                this.pivotX = p.m_122239_();
                this.pivotY = p.m_122260_();
                this.pivotZ = p.m_122269_();
            } else {
                this.pivotX = 0.0f;
                this.pivotY = 0.0f;
                this.pivotZ = 0.0f;
            }
            this.rotation = new Rotation(UtilParse.getJsonSafe(json, "rotation"));
            this.translation = new Translation(UtilParse.getJsonSafe(json, "position"));
            this.scale = new Scale(UtilParse.getJsonSafe(json, "scale"));
        }

        public void applyAnimationAtSecond(Map<String, Matrix4f> transforms, float seconds) {
            Matrix4f mat = new Matrix4f();
            mat.m_27624_();
            if (!this.rotation.isEmpty) {
                mat.m_27644_(this.rotation.getTransformAtSecond(seconds, this.pivotX, this.pivotY, this.pivotZ));
            }
            if (!this.translation.isEmpty) {
                mat.m_27644_(this.translation.getTransformAtSecond(seconds, this.pivotX, this.pivotY, this.pivotZ));
            }
            if (!this.scale.isEmpty) {
                mat.m_27644_(this.scale.getTransformAtSecond(seconds, this.pivotX, this.pivotY, this.pivotZ));
            }
            transforms.put(this.name, mat);
        }
    }

    public static class Keyframe {
        public final float time;
        public final float alpha;
        public final Vector3f pre;
        public final Vector3f post;
        public final LerpMode lerp_mode;
        private Vec2[][] cmrs;

        public Keyframe(float time, JsonArray json) {
            this.time = time;
            this.pre = this.post = BBAnim.fromJsonArray(json);
            this.lerp_mode = LerpMode.LINEAR;
            this.alpha = 0.5f;
        }

        public Keyframe(float time, JsonObject json) {
            this.time = time;
            this.post = json.has("post") ? BBAnim.fromJsonArray(json.getAsJsonArray("post")) : Vector3f.f_176763_;
            this.pre = json.has("pre") ? BBAnim.fromJsonArray(json.getAsJsonArray("pre")) : this.post;
            String mode = UtilParse.getStringSafe(json, "lerp_mode", "");
            this.lerp_mode = mode.equals("catmullrom") ? LerpMode.CATMULLROM : LerpMode.LINEAR;
            this.alpha = UtilParse.getFloatSafe(json, "alpha", 0.15f);
        }

        public Vector3f lerpWithEnd(Keyframe before, float animTime, Keyframe ... surrounding) {
            if (before.lerp_mode == LerpMode.CATMULLROM && surrounding.length == 2) {
                if (this.cmrs == null) {
                    this.cmrs = BBAnim.calcCMRs(before.alpha, surrounding[0], before, this, surrounding[1]);
                }
                return new Vector3f(UtilGeometry.findYInCatmullromArray(animTime, this.cmrs[0]), UtilGeometry.findYInCatmullromArray(animTime, this.cmrs[1]), UtilGeometry.findYInCatmullromArray(animTime, this.cmrs[2]));
            }
            float p = (animTime - before.time) / (this.time - before.time);
            return new Vector3f(Mth.m_14179_((float)p, (float)before.post.m_122239_(), (float)this.pre.m_122239_()), Mth.m_14179_((float)p, (float)before.post.m_122260_(), (float)this.pre.m_122260_()), Mth.m_14179_((float)p, (float)before.post.m_122269_(), (float)this.pre.m_122269_()));
        }

        public boolean equals(Object object) {
            if (object instanceof Keyframe) {
                Keyframe keyframe = (Keyframe)object;
                return this.is(keyframe);
            }
            return false;
        }

        public boolean is(Keyframe keyframe) {
            return this.time == keyframe.time;
        }
    }

    public static class Scale
    extends Transform {
        private final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);

        public Scale(JsonObject json) {
            super(json);
        }

        @Override
        public Matrix4f getTransformAtSecond(float seconds, float pivotX, float pivotY, float pivotZ) {
            Vector3f scale = this.interpolate(seconds);
            return Matrix4f.m_27632_((float)scale.m_122239_(), (float)scale.m_122260_(), (float)scale.m_122269_());
        }

        @Override
        public Vector3f getDefaultTransform() {
            return this.ONE;
        }
    }

    public static class Translation
    extends Transform {
        public Translation(JsonObject json) {
            super(json);
        }

        @Override
        public Matrix4f getTransformAtSecond(float seconds, float pivotX, float pivotY, float pivotZ) {
            Vector3f trans = this.interpolate(seconds);
            trans.m_122261_(0.0625f);
            return Matrix4f.m_27653_((float)trans.m_122239_(), (float)trans.m_122260_(), (float)trans.m_122269_());
        }

        @Override
        public Vector3f getDefaultTransform() {
            return Vector3f.f_176763_;
        }
    }

    public static class Rotation
    extends Transform {
        public Rotation(JsonObject json) {
            super(json);
        }

        @Override
        public Matrix4f getTransformAtSecond(float seconds, float pivotX, float pivotY, float pivotZ) {
            Vector3f rotation = this.interpolate(seconds);
            Matrix4f rot = UtilAngles.pivotPixelsRotX(pivotX, pivotY, pivotZ, -rotation.m_122239_());
            rot.m_27644_(UtilAngles.pivotPixelsRotY(pivotX, pivotY, pivotZ, -rotation.m_122260_()));
            rot.m_27644_(UtilAngles.pivotPixelsRotZ(pivotX, pivotY, pivotZ, rotation.m_122269_()));
            return rot;
        }

        @Override
        public Vector3f getDefaultTransform() {
            return Vector3f.f_176763_;
        }
    }

    public static enum LerpMode {
        LINEAR,
        CATMULLROM;

    }

    public static abstract class Transform {
        public final List<Keyframe> keyframes = new ArrayList<Keyframe>();
        public final boolean isEmpty;

        public Transform(JsonObject json) {
            Set jsons = json.entrySet();
            for (Map.Entry t : jsons) {
                float time = Float.parseFloat((String)t.getKey());
                if (((JsonElement)t.getValue()).isJsonArray()) {
                    this.keyframes.add(new Keyframe(time, ((JsonElement)t.getValue()).getAsJsonArray()));
                    continue;
                }
                if (!((JsonElement)t.getValue()).isJsonObject()) continue;
                this.keyframes.add(new Keyframe(time, ((JsonElement)t.getValue()).getAsJsonObject()));
            }
            this.isEmpty = this.keyframes.isEmpty();
        }

        public Vector3f interpolate(float time) {
            if (this.isEmpty) {
                return this.getDefaultTransform();
            }
            if (time <= this.keyframes.get((int)0).time) {
                return this.keyframes.get((int)0).pre;
            }
            for (int i = 1; i < this.keyframes.size(); ++i) {
                Keyframe keyframe = this.keyframes.get(i);
                float t = keyframe.time;
                if (time == t) {
                    return this.keyframes.get((int)i).post;
                }
                if (time > t) continue;
                Keyframe before = this.keyframes.get(i - 1);
                if (before.lerp_mode == LerpMode.CATMULLROM) {
                    Keyframe beforeBefore = i >= 2 ? this.keyframes.get(i - 2) : before;
                    Keyframe after = i <= this.keyframes.size() - 2 ? this.keyframes.get(i + 1) : keyframe;
                    return keyframe.lerpWithEnd(before, time, beforeBefore, after);
                }
                return keyframe.lerpWithEnd(before, time, new Keyframe[0]);
            }
            return this.keyframes.get((int)(this.keyframes.size() - 1)).post;
        }

        public abstract Matrix4f getTransformAtSecond(float var1, float var2, float var3, float var4);

        public abstract Vector3f getDefaultTransform();
    }
}

