/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj.customanims.keyframe;

import com.google.gson.JsonArray;
import com.mojang.math.Matrix4f;
import com.onewhohears.onewholibs.client.model.obj.customanims.CustomAnimsEntityModel;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KFAnimPlayers;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KeyframeAnimationPlayer;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.Entity;

public class KeyframeAnimsEntityModel<T extends Entity>
extends CustomAnimsEntityModel<T> {
    private List<KeyframeAnimationPlayer<T>> keyframeAnimations;
    private String[] anim_data_ids;

    public KeyframeAnimsEntityModel(String model_id, JsonArray transforms, List<KeyframeAnimationPlayer<T>> keyframeAnimations) {
        super(model_id, transforms);
        this.keyframeAnimations = keyframeAnimations;
    }

    public KeyframeAnimsEntityModel(String model_id, List<KeyframeAnimationPlayer<T>> keyframeAnimations) {
        this(model_id, new JsonArray(), keyframeAnimations);
    }

    public KeyframeAnimsEntityModel(String model_id, JsonArray transforms, String ... anim_data_ids) {
        super(model_id, transforms);
        this.anim_data_ids = anim_data_ids;
    }

    public KeyframeAnimsEntityModel(String model_id, String ... anim_data_ids) {
        super(model_id, new JsonArray());
        this.anim_data_ids = anim_data_ids;
    }

    @Override
    protected void addComponentTransforms(Map<String, Matrix4f> transforms, T entity, float partialTicks) {
        super.addComponentTransforms(transforms, entity, partialTicks);
        for (KeyframeAnimationPlayer<T> anim : this.getKeyframeAnimations()) {
            if (!anim.isAnimationActive(entity)) continue;
            anim.applyAnimation(transforms, entity, partialTicks);
        }
    }

    public List<KeyframeAnimationPlayer<T>> getKeyframeAnimations() {
        if (this.keyframeAnimations == null && this.anim_data_ids != null) {
            this.keyframeAnimations = KFAnimPlayers.getAnimPlayersFromDataIds(this.anim_data_ids);
        }
        return this.keyframeAnimations;
    }
}

