/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.onewholibs.client.model.obj.customanims;

import com.google.gson.JsonObject;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.world.entity.Entity;

public abstract class EntityModelTransform<T extends Entity> {
    public static final Matrix4f INVISIBLE = Matrix4f.m_27632_((float)0.0f, (float)0.0f, (float)0.0f);
    public static final Matrix4f NOTHING = Matrix4f.m_27632_((float)1.0f, (float)1.0f, (float)1.0f);
    private final String model_part_key;

    public EntityModelTransform(JsonObject data) {
        this(data.get("model_part_key").getAsString());
    }

    protected EntityModelTransform(String model_part_key) {
        this.model_part_key = model_part_key;
    }

    public String getKey() {
        return this.model_part_key;
    }

    public abstract Matrix4f getTransform(T var1, float var2);

    public void addTransform(EntityModelTransform<T> transform) {
    }

    public boolean isGroup() {
        return false;
    }

    public static class ContinuousRotation<T extends Entity>
    extends AxisRotation<T> {
        private final float rot_rate;

        public ContinuousRotation(JsonObject data) {
            super(data);
            this.rot_rate = UtilParse.getFloatSafe(data, "rot_rate", 0.0f);
        }

        public float getRotRate() {
            return this.rot_rate;
        }

        @Override
        public float getRotDeg(T entity, float partialTicks) {
            return UtilAngles.lerpAngle(partialTicks, (float)((Entity)entity).f_19797_ * this.getRotRate(), (float)(((Entity)entity).f_19797_ + 1) * this.getRotRate());
        }
    }

    public static abstract class AxisRotation<T extends Entity>
    extends Pivot<T> {
        private final RotationAxis rot_axis;

        public AxisRotation(JsonObject data) {
            super(data);
            this.rot_axis = UtilParse.getEnumSafe(data, "rot_axis", RotationAxis.class);
        }

        public RotationAxis getRotAxis() {
            return this.rot_axis;
        }

        public abstract float getRotDeg(T var1, float var2);

        @Override
        public Matrix4f getTransform(T entity, float partialTicks) {
            float degrees = this.getRotDeg(entity, partialTicks);
            if (degrees == 0.0f) {
                return NOTHING;
            }
            switch (this.rot_axis) {
                case X: {
                    return UtilAngles.pivotRotX(this.getPivot().m_122239_(), this.getPivot().m_122260_(), this.getPivot().m_122269_(), degrees);
                }
                case Y: {
                    return UtilAngles.pivotRotY(this.getPivot().m_122239_(), this.getPivot().m_122260_(), this.getPivot().m_122269_(), degrees);
                }
                case Z: {
                    return UtilAngles.pivotRotZ(this.getPivot().m_122239_(), this.getPivot().m_122260_(), this.getPivot().m_122269_(), degrees);
                }
            }
            return null;
        }
    }

    public static enum RotationAxis {
        X,
        Y,
        Z;

    }

    public static abstract class Pivot<T extends Entity>
    extends EntityModelTransform<T> {
        private final Vector3f pivot;

        public Pivot(JsonObject data) {
            super(data);
            this.pivot = UtilParse.readVec3f(data, "pivot");
        }

        public Vector3f getPivot() {
            return this.pivot;
        }
    }

    public static abstract class Translation<T extends Entity>
    extends EntityModelTransform<T> {
        private final Vector3f bounds;

        public Translation(JsonObject data) {
            super(data);
            this.bounds = UtilParse.readVec3f(data, "bounds");
        }

        public Vector3f getBounds() {
            return this.bounds;
        }

        public abstract float getTranslationProgress(T var1, float var2);

        @Override
        public Matrix4f getTransform(T entity, float partialTicks) {
            float p = this.getTranslationProgress(entity, partialTicks);
            if (p == 0.0f) {
                return NOTHING;
            }
            return Matrix4f.m_27653_((float)(this.bounds.m_122239_() * p), (float)(this.bounds.m_122260_() * p), (float)(this.bounds.m_122269_() * p));
        }
    }

    public static class AlwaysHide<T extends Entity>
    extends EntityModelTransform<T> {
        public AlwaysHide(JsonObject data) {
            super(data);
        }

        @Override
        public Matrix4f getTransform(T entity, float partialTicks) {
            return INVISIBLE;
        }
    }
}

