/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import net.minecraft.core.Direction;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.smileycorp.atlas.api.block.WoodBlock;

public class WoodBlockBuilder {
    protected DeferredRegister<Item> items;
    protected DeferredRegister<Block> blocks;
    protected final String name;
    protected final String modid;
    protected final CreativeModeTab tab;
    protected CreativeModeTab decorations_tab;
    protected Material woodMaterial = Material.f_76320_;
    protected Material leavesMaterial = Material.f_76315_;
    protected MaterialColor plankColour = MaterialColor.f_76411_;
    protected MaterialColor barkColour = MaterialColor.f_76370_;
    protected MaterialColor leavesColour = MaterialColor.f_76399_;
    protected AbstractTreeGrower treeGrower = null;
    protected SoundType woodSound = SoundType.f_56736_;
    protected SoundType leavesSound = SoundType.f_56740_;
    protected float blockHardness = 2.0f;
    protected float explosionResistance = 5.0f;
    protected boolean hasBoat = false;

    private WoodBlockBuilder(String name, String modid, CreativeModeTab tab, DeferredRegister<Item> items, DeferredRegister<Block> blocks) {
        this.items = items;
        this.blocks = blocks;
        this.name = name;
        this.modid = modid;
        this.tab = tab;
        this.decorations_tab = tab;
    }

    public static WoodBlockBuilder of(String name, String modid, CreativeModeTab tab, DeferredRegister<Item> items, DeferredRegister<Block> blocks) {
        return new WoodBlockBuilder(name, modid, tab, items, blocks);
    }

    public WoodBlockBuilder decorationsTab(CreativeModeTab tab) {
        this.decorations_tab = tab;
        return this;
    }

    public WoodBlockBuilder woodMaterial(Material mat) {
        this.woodMaterial = mat;
        return this;
    }

    public WoodBlockBuilder leavesMaterial(Material mat) {
        this.leavesMaterial = mat;
        return this;
    }

    public WoodBlockBuilder plankColour(MaterialColor colour) {
        this.plankColour = colour;
        return this;
    }

    public WoodBlockBuilder barkColour(MaterialColor colour) {
        this.barkColour = colour;
        return this;
    }

    public WoodBlockBuilder leavesColour(MaterialColor colour) {
        this.leavesColour = colour;
        return this;
    }

    public WoodBlockBuilder treeGrower(AbstractTreeGrower tree) {
        this.treeGrower = tree;
        return this;
    }

    public WoodBlockBuilder woodSound(SoundType sound) {
        this.woodSound = sound;
        return this;
    }

    public WoodBlockBuilder leavesSound(SoundType sound) {
        this.leavesSound = sound;
        return this;
    }

    public WoodBlockBuilder blockHardness(float hardness) {
        this.blockHardness = hardness;
        return this;
    }

    public WoodBlockBuilder explosionResistance(float resistance) {
        this.explosionResistance = resistance;
        return this;
    }

    public WoodBlockBuilder enableBoat() {
        this.hasBoat = true;
        return this;
    }

    public WoodBlock build() {
        return new WoodBlock(this, this.items, this.blocks);
    }

    public BlockBehaviour.Properties constructBaseProperties() {
        return this.constructPropertiesFrom(BlockBehaviour.Properties.m_60944_((Material)this.woodMaterial, (MaterialColor)this.plankColour));
    }

    public BlockBehaviour.Properties constructLogProperties() {
        return this.constructPropertiesFrom(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? this.plankColour : this.barkColour));
    }

    public BlockBehaviour.Properties constructPropertiesFrom(BlockBehaviour.Properties base) {
        return base.m_60918_(this.woodSound).m_60913_(this.blockHardness, this.explosionResistance).m_60999_();
    }
}

