/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.smileycorp.atlas.api.BoatRegistry;
import net.smileycorp.atlas.api.block.BlockUtils;
import net.smileycorp.atlas.api.block.FuelHandler;
import net.smileycorp.atlas.api.block.WoodBlockBuilder;
import net.smileycorp.atlas.api.client.entity.AtlasBoatRenderer;
import net.smileycorp.atlas.api.item.AtlasBoatItem;

public class WoodBlock {
    protected final String name;
    protected final AbstractTreeGrower treeGrower;
    protected final WoodType sign_type;
    protected final BoatRegistry.Type boat_type;
    protected final RegistryObject<Block> planks;
    protected final RegistryObject<Block> stairs;
    protected final RegistryObject<Block> slab;
    protected final RegistryObject<Block> log;
    protected final RegistryObject<Block> stripped_log;
    protected final RegistryObject<Block> wood;
    protected final RegistryObject<Block> stripped_wood;
    protected final RegistryObject<Block> leaves;
    protected final RegistryObject<Block> sapling;
    protected final RegistryObject<Block> fence;
    protected final RegistryObject<Block> fence_gate;
    protected final RegistryObject<Block> button;
    protected final RegistryObject<Block> pressure_plate;
    protected final RegistryObject<Block> door;
    protected final RegistryObject<Block> trapdoor;
    protected final RegistryObject<Block> standing_sign;
    protected final RegistryObject<Block> wall_sign;
    protected final RegistryObject<Item> sign;

    protected WoodBlock(WoodBlockBuilder builder, DeferredRegister<Item> items, DeferredRegister<Block> blocks) {
        this.name = builder.name;
        this.treeGrower = builder.treeGrower;
        this.sign_type = WoodType.m_61844_((WoodType)WoodType.create((String)this.name));
        this.planks = this.register(blocks, () -> new Block(builder.constructBaseProperties()), "planks");
        this.registerItem(items, this.planks, builder.tab);
        this.stairs = this.register(blocks, () -> new StairBlock(((Block)this.planks.get()).m_49966_(), builder.constructBaseProperties()), "stairs");
        this.registerItem(items, this.stairs, builder.tab);
        this.slab = this.register(blocks, () -> new SlabBlock(builder.constructBaseProperties()), "slab");
        this.registerItem(items, this.slab, builder.tab);
        this.stripped_log = this.register(blocks, () -> new RotatedPillarBlock(builder.constructBaseProperties()), "stripped", "log");
        this.registerItem(items, this.stripped_log, builder.tab);
        this.stripped_wood = this.register(blocks, () -> new RotatedPillarBlock(builder.constructPropertiesFrom(BlockBehaviour.Properties.m_60944_((Material)builder.woodMaterial, (MaterialColor)builder.barkColour))), "stripped", this.name.contains("wood") ? "" : "wood");
        this.registerItem(items, this.stripped_wood, builder.tab);
        this.log = this.register(blocks, () -> new RotatedPillarBlock(builder.constructLogProperties()){

            public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction tool, boolean simulate) {
                return tool == ToolActions.AXE_STRIP ? (BlockState)((Block)WoodBlock.this.stripped_log.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))) : null;
            }
        }, "log");
        this.registerItem(items, this.log, builder.tab);
        this.wood = this.register(blocks, () -> new RotatedPillarBlock(builder.constructPropertiesFrom(BlockBehaviour.Properties.m_60944_((Material)builder.woodMaterial, (MaterialColor)builder.barkColour))){

            public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction tool, boolean simulate) {
                return tool == ToolActions.AXE_STRIP ? ((Block)WoodBlock.this.stripped_wood.get()).m_49966_() : null;
            }
        }, this.name.contains("wood") ? "" : "wood");
        this.registerItem(items, this.wood, builder.tab);
        this.leaves = this.register(blocks, () -> new LeavesBlock(BlockBehaviour.Properties.m_60944_((Material)builder.leavesMaterial, (MaterialColor)builder.leavesColour).m_60978_(0.2f).m_60977_().m_60918_(builder.leavesSound).m_60955_().m_60922_(BlockUtils::jungleMob).m_60960_(BlockUtils::never).m_60971_(BlockUtils::never)), "leaves");
        this.registerItem(items, this.leaves, builder.decorations_tab);
        RegistryObject<Block> registryObject = this.sapling = builder.treeGrower == null ? null : this.register(blocks, () -> new SaplingBlock(builder.treeGrower, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60955_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)), "sapling");
        if (this.sapling != null) {
            this.registerItem(items, this.sapling, builder.decorations_tab);
        }
        this.fence = this.register(blocks, () -> new FenceBlock(builder.constructBaseProperties()), "fence");
        this.registerItem(items, this.fence, builder.decorations_tab);
        this.fence_gate = this.register(blocks, () -> new FenceGateBlock(builder.constructBaseProperties()), "fence_gate");
        this.registerItem(items, this.fence_gate, builder.decorations_tab);
        this.button = this.register(blocks, () -> new WoodButtonBlock(builder.constructBaseProperties()), "button");
        this.registerItem(items, this.button, builder.decorations_tab);
        this.pressure_plate = this.register(blocks, () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, builder.constructBaseProperties()), "pressure_plate");
        this.registerItem(items, this.pressure_plate, builder.decorations_tab);
        this.door = this.register(blocks, () -> new DoorBlock(builder.constructBaseProperties().m_60955_()), "door");
        this.registerItem(items, this.door, builder.decorations_tab);
        this.trapdoor = this.register(blocks, () -> new TrapDoorBlock(builder.constructBaseProperties().m_60955_()), "trapdoor");
        this.registerItem(items, this.trapdoor, builder.decorations_tab);
        this.standing_sign = this.register(blocks, () -> new StandingSignBlock(builder.constructBaseProperties(), this.sign_type), "sign");
        this.wall_sign = this.register(blocks, () -> new WallSignBlock(builder.constructBaseProperties(), this.sign_type), "wall_sign");
        this.sign = this.register(items, () -> new SignItem(new Item.Properties().m_41487_(16).m_41491_(builder.decorations_tab), (Block)this.standing_sign.get(), (Block)this.wall_sign.get()), "sign");
        this.boat_type = builder.hasBoat ? BoatRegistry.INSTANCE.register(this.name, builder.modid, items, builder.decorations_tab) : null;
    }

    protected void registerItem(DeferredRegister<Item> items, RegistryObject<Block> block, CreativeModeTab tab) {
        items.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
    }

    protected <T> RegistryObject<T> register(DeferredRegister<T> registry, Supplier<T> supplier, String suffix) {
        return this.register(registry, supplier, "", suffix);
    }

    protected <T> RegistryObject<T> register(DeferredRegister<T> registry, Supplier<T> supplier, String prefix, String suffix) {
        StringBuilder builder = new StringBuilder();
        if (!prefix.isBlank()) {
            builder.append(prefix + "_");
        }
        builder.append(this.name.toLowerCase());
        if (!suffix.isBlank()) {
            builder.append("_" + suffix);
        }
        return registry.register(builder.toString(), supplier);
    }

    public String getName() {
        return this.name;
    }

    public AbstractTreeGrower getTreeGrower() {
        return this.treeGrower;
    }

    public WoodType getSignType() {
        return this.sign_type;
    }

    public Block getPlanks() {
        return (Block)this.planks.get();
    }

    public StairBlock getStairs() {
        return (StairBlock)this.stairs.get();
    }

    public SlabBlock getSlab() {
        return (SlabBlock)this.slab.get();
    }

    public RotatedPillarBlock getLog() {
        return (RotatedPillarBlock)this.log.get();
    }

    public RotatedPillarBlock getStrippedLog() {
        return (RotatedPillarBlock)this.stripped_log.get();
    }

    public RotatedPillarBlock getWood() {
        return (RotatedPillarBlock)this.wood.get();
    }

    public RotatedPillarBlock getStrippedWood() {
        return (RotatedPillarBlock)this.stripped_wood.get();
    }

    public LeavesBlock getLeaves() {
        return (LeavesBlock)this.leaves.get();
    }

    public SaplingBlock getSapling() {
        return this.sapling == null ? null : (SaplingBlock)this.sapling.get();
    }

    public FenceBlock getFence() {
        return (FenceBlock)this.fence.get();
    }

    public FenceGateBlock getFenceGate() {
        return (FenceGateBlock)this.fence_gate.get();
    }

    public ButtonBlock getButton() {
        return (ButtonBlock)this.button.get();
    }

    public PressurePlateBlock getPressurePlate() {
        return (PressurePlateBlock)this.pressure_plate.get();
    }

    public DoorBlock getDoor() {
        return (DoorBlock)this.door.get();
    }

    public TrapDoorBlock getTrapdoor() {
        return (TrapDoorBlock)this.trapdoor.get();
    }

    public SignBlock getSignBlock(boolean onWall) {
        return (SignBlock)(onWall ? (Block)this.wall_sign.get() : (Block)this.standing_sign.get());
    }

    public SignItem getSign() {
        return (SignItem)this.sign.get();
    }

    public AtlasBoatItem getBoat() {
        return (AtlasBoatItem)this.boat_type.getItem();
    }

    public void registerClient() {
        Sheets.addWoodType((WoodType)this.sign_type);
        ItemBlockRenderTypes.setRenderLayer((Block)this.getDoor(), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)this.getTrapdoor(), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)this.getSapling(), (RenderType)RenderType.m_110457_());
        if (this.boat_type != null && !AtlasBoatRenderer.isRegistered()) {
            AtlasBoatRenderer.register();
        }
    }

    public void registerStandardFuelValues() {
        FuelHandler.INSTANCE.registerFuel(this.getPlanks(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getStairs(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getSlab(), 150);
        FuelHandler.INSTANCE.registerFuel((Block)this.getLog(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getStrippedLog(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getWood(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getStrippedWood(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getSapling(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getFence(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getFenceGate(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getButton(), 100);
        FuelHandler.INSTANCE.registerFuel((Block)this.getPressurePlate(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getDoor(), 200);
        FuelHandler.INSTANCE.registerFuel((Block)this.getTrapdoor(), 300);
        FuelHandler.INSTANCE.registerFuel((Item)this.getSign(), 200);
    }
}

