/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ShapedBlock {
    protected final String name;
    protected final CreativeModeTab tab;
    protected final RegistryObject<Block> base;
    protected final RegistryObject<Block> stairs;
    protected final RegistryObject<Block> slab;
    protected final RegistryObject<Block> wall;

    public ShapedBlock(String name, CreativeModeTab tab, BlockBehaviour.Properties properties, DeferredRegister<Item> items, DeferredRegister<Block> blocks, boolean hasWall) {
        this.name = name;
        this.tab = tab;
        this.base = this.register(items, blocks, () -> new Block(properties), "");
        this.stairs = this.register(items, blocks, () -> new StairBlock(() -> ((Block)this.base.get()).m_49966_(), properties), "stairs");
        this.slab = this.register(items, blocks, () -> new SlabBlock(properties), "slab");
        this.wall = hasWall ? this.register(items, blocks, () -> new WallBlock(properties), "wall") : null;
    }

    protected RegistryObject<Block> register(DeferredRegister<Item> items, DeferredRegister<Block> blocks, Supplier<Block> supplier, String suffix) {
        RegistryObject<Block> block = this.register(blocks, supplier, suffix);
        this.register(items, () -> new BlockItem((Block)supplier.get(), new Item.Properties().m_41491_(this.tab)), suffix);
        return block;
    }

    protected <T> RegistryObject<T> register(DeferredRegister<T> registry, Supplier<T> object, String suffix) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name.toLowerCase());
        if (!suffix.isBlank()) {
            builder.append("_" + suffix);
        }
        return registry.register(builder.toString(), object);
    }

    public Block getBase() {
        return (Block)this.base.get();
    }

    public StairBlock getStairs() {
        return (StairBlock)this.stairs.get();
    }

    public SlabBlock getSlab() {
        return (SlabBlock)this.slab.get();
    }

    public WallBlock getWall() {
        return this.wall == null ? null : (WallBlock)this.wall.get();
    }
}

