/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.blocks.mines.BaseFullMineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class RedstoneOreMineBlock
extends BaseFullMineBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;

    public RedstoneOreMineBlock(BlockBehaviour.Properties properties, Block disguisedBlock) {
        super(properties, disguisedBlock);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        RedstoneOreMineBlock.activate(state, level, pos);
        super.m_6256_(state, level, pos, player);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        RedstoneOreMineBlock.activate(state, level, pos);
        super.m_141947_(level, pos, state, entity);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            RedstoneOreMineBlock.spawnParticles(level, pos);
        } else {
            RedstoneOreMineBlock.activate(state, level, pos);
        }
        return stack.m_41720_() instanceof BlockItem && new BlockPlaceContext(player, hand, stack, hit).m_7059_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    private static void activate(BlockState state, Level level, BlockPos pos) {
        RedstoneOreMineBlock.spawnParticles(level, pos);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            RedstoneOreMineBlock.spawnParticles(level, pos);
        }
    }

    private static void spawnParticles(Level level, BlockPos pos) {
        RandomSource random = level.f_46441_;
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pos.m_121945_(direction);
            if (level.m_8055_(offsetPos).m_60804_((BlockGetter)level, offsetPos)) continue;
            Direction.Axis axis = direction.m_122434_();
            double d1 = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)random.m_188501_();
            double d2 = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)random.m_188501_();
            double d3 = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)random.m_188501_();
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + d1, (double)pos.m_123342_() + d2, (double)pos.m_123343_() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    @Override
    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return (BlockState)this.getBlockDisguisedAs().m_49966_().m_61124_((Property)LIT, (Comparable)((Boolean)state.m_61143_((Property)LIT)));
    }
}

