/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public interface IPasswordProtected
extends ICodebreakable {
    default public void openPasswordGUI(Level level, BlockPos pos, Player player) {
        if (!level.f_46443_ && this.getPassword() != null) {
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHECK_PASSWORD, pos));
        }
    }

    default public boolean verifyPasswordSet(Level level, BlockPos pos, IOwnable ownable, Player player) {
        if (!level.f_46443_) {
            if (this.getPassword() != null) {
                return true;
            }
            if (ownable.isOwnedBy(player)) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SET_PASSWORD, pos));
            } else {
                PlayerUtils.sendMessageToPlayer(player, Component.m_237113_((String)"SecurityCraft"), Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
            }
        }
        return false;
    }

    @Override
    default public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.getPassword() == null) {
            PlayerUtils.sendMessageToPlayer(player, Component.m_237113_((String)"SecurityCraft"), Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
            return false;
        }
        return true;
    }

    @Override
    default public void useCodebreaker(BlockState state, Player player) {
        this.activate(player);
    }

    public void activate(Player var1);

    public String getPassword();

    public void setPassword(String var1);

    public void startCooldown();

    public boolean isOnCooldown();

    public long getCooldownEnd();

    default public void onIncorrectPasscodeEntered(Player player, String incorrectCode) {
        IPasswordProtected iPasswordProtected = this;
        if (iPasswordProtected instanceof IModuleInventory) {
            IModuleInventory moduleInv = (IModuleInventory)((Object)iPasswordProtected);
            if (moduleInv.isModuleEnabled(ModuleType.SMART)) {
                this.startCooldown();
            }
            if (moduleInv.isModuleEnabled(ModuleType.HARMING) && player.m_6469_(CustomDamageSources.INCORRECT_PASSCODE, (float)((Integer)ConfigHandler.SERVER.incorrectPasscodeDamage.get()).intValue())) {
                player.m_6915_();
            }
        }
    }
}

