/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;

public final class ModTabs {
    public static final CreativeModeTab mainTab = new CreativeModeTab("tombstone"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.TOMBSTONE));
        }

        public Component m_40786_() {
            return Component.m_237113_((String)"Corail Tombstone");
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            items.add((Object)NBTStackHelper.setBoolean(new ItemStack((ItemLike)Items.f_151058_), "enchant", true));
            items.add((Object)EffectHelper.createMagicArrows(1, ModEffects.bait));
            items.add((Object)EffectHelper.createMagicArrows(1, ModEffects.frostbite));
            items.add((Object)EffectHelper.createMagicArrows(1, ModEffects.frostbite, 2));
            items.add((Object)EffectHelper.createMagicArrows(1, ModEffects.frostbite, 4));
            items.add((Object)EffectHelper.createMagicArrows(1, MobEffects.f_216964_));
            items.add((Object)EffectHelper.createMagicArrows(1, ModEffects.restoration));
            items.add((Object)EffectHelper.createCursedArrows(1));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.spectral));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.earthly_garden));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.discretion));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.restoration));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.bait));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.frostbite));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.darkness));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.restoration));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.bait));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.frostbite));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.darkness));
            items.add((Object)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.restoration));
            ModTabs.fillWithEnchantedBook(items);
        }

        public boolean hasSearchBar() {
            return true;
        }
    };
    public static final CreativeModeTab familiarTab = new CreativeModeTab("receptacle"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModItems.receptacle_of_familiar);
        }

        public Component m_40786_() {
            return LangKey.MESSAGE_FAMILIAR.getText(new Object[0]);
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            TamableType.TAMABLE_TYPE.keySet().stream().map(id -> ModItems.receptacle_of_familiar.createReceptacleWithFamiliar(new ResourceLocation(id))).forEach(arg_0 -> items.add(arg_0));
        }

        public boolean hasSearchBar() {
            return true;
        }
    };

    private static void fillWithEnchantedBook(NonNullList<ItemStack> items) {
        ModEnchantments.getEnchantments().values().stream().filter(TombstoneEnchantment::isEnabled).forEach(enchantment -> {
            items.add((Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)enchantment, 1)));
            int maxLevel = Helper.getMaxLevel(enchantment);
            for (int level = 5; level <= maxLevel; level += 5) {
                items.add((Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)enchantment, level)));
            }
            if (maxLevel > 1 && maxLevel % 5 != 0) {
                items.add((Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)enchantment, maxLevel)));
            }
        });
    }
}

