/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.combine.ClientTooltipCombineCraft;
import ovh.corail.tombstone.combine.ClientTooltipCombineUpgrade;
import ovh.corail.tombstone.combine.ClientTooltipSimple;
import ovh.corail.tombstone.combine.TooltipCombineCraft;
import ovh.corail.tombstone.combine.TooltipCombineUpgrade;
import ovh.corail.tombstone.combine.TooltipDyeable;
import ovh.corail.tombstone.combine.TooltipEngravable;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.CompatibilityOculus;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.event.ClientEventHandler;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.item.ItemLostTablet;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.particle.ParticleSmokeCloud;
import ovh.corail.tombstone.particle.ParticleSmokeColumn;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModParticleTypes;
import ovh.corail.tombstone.render.GraveGuardianRenderer;
import ovh.corail.tombstone.render.RenderWritableGrave;
import ovh.corail.tombstone.render.SpectralBiteRenderer;
import ovh.corail.tombstone.render.SpectralWolfRenderer;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ClientModEvents {
    @Nullable
    private static ShaderInstance lowAlphaShader;

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tint) -> tint == 0 ? -9865852 : -1, new ItemLike[]{ModItems.book_of_disenchantment});
        event.register((stack, tint) -> tint == 0 ? -7252579 : -1, new ItemLike[]{ModItems.book_of_recycling});
        event.register((stack, tint) -> tint == 0 ? -11246691 : -1, new ItemLike[]{ModItems.book_of_repairing});
        event.register((stack, tint) -> tint == 0 ? -11806832 : -1, new ItemLike[]{ModItems.book_of_magic_impregnation});
        event.register((stack, tint) -> tint == 0 ? -16711904 : -16733664, new ItemLike[]{ModItems.dust_of_vanishing});
        event.register((stack, tint) -> tint == 0 ? -16760672 : -16756550, new ItemLike[]{ModItems.grave_dust});
        event.register((stack, tint) -> -6238048, new ItemLike[]{ModItems.dust_of_frost});
        event.register(ModItems.lollipop::getColor, new ItemLike[]{ModItems.lollipop});
        event.register(ModItems.easter_egg::getColor, new ItemLike[]{ModItems.easter_egg});
        event.register(ModItems.smoke_ball::getColor, new ItemLike[]{ModItems.smoke_ball});
        event.register(ModItems.magic_scroll::getColor, new ItemLike[]{ModItems.magic_scroll});
        event.register((stack, tint) -> tint == 0 && ModItems.scroll_of_knowledge.isEnchanted(stack) ? -16711936 : -1, new ItemLike[]{ModItems.scroll_of_knowledge});
        event.register((stack, tint) -> tint == 0 ? -15472641 : -1, new ItemLike[]{ModItems.gemstone_of_familiar});
        event.register((stack, tint) -> tint == 0 ? -2423297 : -1, new ItemLike[]{ModItems.gemstone_of_merchant});
        event.register((stack, tint) -> tint == 0 ? -8700161 : -1, new ItemLike[]{ModItems.gemstone_of_prayer});
        event.register((stack, tint) -> tint == 0 ? -15756769 : -1, new ItemLike[]{ModItems.gemstone_of_guardian});
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlocks.tile_decorative_grave, RenderWritableGrave::new);
        event.registerBlockEntityRenderer(ModBlocks.tile_grave, RenderWritableGrave::new);
        event.registerEntityRenderer(ModEntities.grave_guardian, GraveGuardianRenderer::new);
        event.registerEntityRenderer(ModEntities.cloud, NoopRenderer::new);
        event.registerEntityRenderer(ModEntities.spectral_bite, SpectralBiteRenderer::new);
        event.registerEntityRenderer(ModEntities.spectral_wolf, SpectralWolfRenderer::new);
    }

    public static ShaderInstance getLowAlphaShader() {
        return Objects.requireNonNull(Optional.ofNullable(lowAlphaShader).filter(s -> !CompatibilityOculus.instance.isShaderEnabled()).orElse(GameRenderer.m_172829_()));
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("tombstone", "alphal"), DefaultVertexFormat.f_85813_), shaderInstance -> {
            lowAlphaShader = shaderInstance;
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.register(ModParticleTypes.GHOST, (type, level, x, y, z, mX, mY, mZ) -> new ParticleGhost(level, x, y, z, (Helper.RANDOM.nextDouble() - 0.5) * 0.1, (Helper.RANDOM.nextDouble() - 0.5) * 0.1));
        event.register(ModParticleTypes.SMOKE_COLUMN, (type, level, x, y, z, mX, mY, mZ) -> new ParticleSmokeColumn(level, x, y, z));
        event.register(ModParticleTypes.SMOKE_CLOUD, (type, level, x, y, z, mX, mY, mZ) -> new ParticleSmokeCloud(level, x, y, z));
    }

    @SubscribeEvent
    public static void onStitchTextures(TextureStitchEvent.Pre event) {
        if (SupportMods.CURIOS.isLoaded() && event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            event.addSprite(CompatibilityCurio.instance.BUNDLE_SLOT);
            event.addSprite(CompatibilityCurio.instance.MAGIC_BOOK_SLOT);
        }
    }

    @SubscribeEvent
    public static void onRegisterTooltipComponentFactory(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TooltipCombineCraft.class, ClientTooltipCombineCraft::new);
        event.register(TooltipCombineUpgrade.class, ClientTooltipCombineUpgrade::new);
        event.register(TooltipDyeable.class, ClientTooltipSimple::new);
        event.register(TooltipEngravable.class, ClientTooltipSimple::new);
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ClientEventHandler.KEYBIND_KNOWLEDGE);
        event.register(ClientEventHandler.KEYBIND_CONFIG);
        event.register(ClientEventHandler.KEYBIND_COMPENDIUM);
    }

    public static void initModels() {
        for (Block decorativeGrave : ModBlocks.DECORATIVE_GRAVES.values()) {
            ItemProperties.register((Item)decorativeGrave.m_5456_(), (ResourceLocation)new ResourceLocation("model_texture"), (stack, world, entity, aInt) -> (EngravableHelper.isEngraved(stack) ? 0.1f : 0.0f) + (float)ItemBlockGrave.getModelTexture(stack) * 0.01f);
        }
        ItemProperties.register((Item)ModItems.bone_needle, (ResourceLocation)new ResourceLocation("filled"), (stack, world, entity, aInt) -> ModItems.bone_needle.getEntityType(stack).isEmpty() ? 0.0f : 1.0f);
        ItemProperties.register((Item)ModItems.lost_tablet, (ResourceLocation)new ResourceLocation("type"), (stack, world, player, aInt) -> switch (ModItems.lost_tablet.getType(stack)) {
            default -> throw new IncompatibleClassChangeError();
            case ItemLostTablet.Type.UNKNOWN -> 0.0f;
            case ItemLostTablet.Type.EXPLORATION -> 0.1f;
            case ItemLostTablet.Type.VILLAGE -> 0.5f;
            case ItemLostTablet.Type.TREASURE -> 1.0f;
        });
        ResourceLocation rlMagic = new ResourceLocation("magic");
        ItemPropertyFunction isMagic = (stack, worldIn, entityIn, aInt) -> {
            ItemGraveMagic itemGraveMagic = (ItemGraveMagic)stack.m_41720_();
            return itemGraveMagic.isAncient(stack) ? 1.0f : (itemGraveMagic.isEnchanted(stack) ? 0.5f : 0.0f);
        };
        ModItems.scroll_buff.values().forEach(item -> ItemProperties.register((Item)item, (ResourceLocation)rlMagic, (ItemPropertyFunction)isMagic));
        ItemPropertyFunction isAncient = (stack, worldIn, entityIn, aInt) -> ((ItemGraveMagic)stack.m_41720_()).isAncient(stack) ? 1.0f : 0.0f;
        ResourceLocation rlAncient = new ResourceLocation("ancient");
        ItemProperties.register((Item)ModItems.tablet_of_home, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.tablet_of_recall, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.tablet_of_assistance, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.tablet_of_cupidity, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.tablet_of_guard, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.magic_scroll, (ResourceLocation)rlAncient, (ItemPropertyFunction)isAncient);
        ItemProperties.register((Item)ModItems.fishing_rod_of_misadventure, (ResourceLocation)new ResourceLocation("cast"), (stack, world, entity, aInt) -> {
            Player player;
            return (ModItems.fishing_rod_of_misadventure.isAncient(stack) ? 0.01f : 0.0f) + (entity instanceof Player && ((player = (Player)entity).m_21205_() == stack || player.m_21206_() == stack) && player.f_36083_ != null ? 0.1f : 0.0f);
        });
        ItemProperties.register((Item)ModItems.grave_plate, (ResourceLocation)new ResourceLocation("engraved"), (stack, worldIn, entityIn, aInt) -> EngravableHelper.isEngraved(stack) ? 1.0f : 0.0f);
    }
}

