/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

public final class PerkTreasureSeeker
extends Perk {
    public PerkTreasureSeeker() {
        super("treasure_seeker", new ResourceLocation("tombstone", "textures/item/lost_tablet.png"));
    }

    @Override
    public int getLevelMax() {
        return (Integer)SharedConfigTombstone.allowed_perks.levelMaxTreasureSeeker.get();
    }

    @Override
    public boolean isDisabled(@Nullable Player player) {
        return (Boolean)SharedConfigTombstone.allowed_perks.allowTreasureSeeker.get() == false;
    }

    @Override
    public List<Component> getCurrentBonusInfo(int level) {
        ArrayList<Component> bonus = new ArrayList<Component>();
        bonus.add((Component)Component.m_237113_((String)("+" + level * 20 + "% ")).m_7220_((Component)Component.m_237115_((String)(this.getTranslationKey() + ".bonus1"))));
        bonus.add((Component)Component.m_237113_((String)("+" + level * 10 + "% ")).m_7220_((Component)Component.m_237115_((String)(this.getTranslationKey() + ".bonus2"))));
        return bonus;
    }

    @Override
    public int getLevelBonus(Player player) {
        int n = player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ModItems.christmas_hat ? 2 : 0;
        return n + (switch (TimeHelper.getSpecialEvent()) {
            case TimeHelper.SpecialEvent.CHRISTMAS -> 5;
            case TimeHelper.SpecialEvent.HALLOWEEN, TimeHelper.SpecialEvent.EASTER, TimeHelper.SpecialEvent.APRIL_FOOLS -> 3;
            default -> 0;
        });
    }
}

