/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.particle.CustomParticle;

@OnlyIn(value=Dist.CLIENT)
abstract class BoundParticle
extends CustomParticle {
    private boolean initialized = false;
    protected final WeakReference<LivingEntity> entityWeakReference;
    protected final double radius;
    private final List<ParticleData> particleDatas = new ArrayList<ParticleData>();

    public BoundParticle(ClientLevel level, LivingEntity entity, double radius) {
        super(level, entity.m_20182_());
        this.entityWeakReference = new WeakReference<LivingEntity>(entity);
        this.radius = radius;
        this.m_107257_(20);
        this.m_107250_(4.0f, 2.0f);
    }

    protected abstract void addParticleDatas(List<ParticleData> var1);

    protected void onParticleDataUpdate(ParticleData data, double ratio) {
        Vec3 newPos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_).m_82520_(this.radius * Math.cos(6.2831854820251465 * (data.angle + ratio)), data.yHeight, this.radius * Math.sin(6.2831854820251465 * (data.angle + ratio)));
        data.oPos = data.pos == null ? newPos : data.pos;
        data.pos = newPos;
    }

    @Override
    @Deprecated
    public Particle m_6569_(float scale) {
        return this;
    }

    @Override
    public void setRolling(float rollIncrement) {
        this.setRolling(0.0f, rollIncrement);
    }

    @Override
    protected boolean requireRemoval() {
        return this.f_107224_ >= this.f_107225_ + 1;
    }

    @Override
    public void m_5989_() {
        LivingEntity entity = (LivingEntity)this.entityWeakReference.get();
        if (entity == null) {
            this.m_107274_();
            return;
        }
        if (!this.initialized) {
            this.updateLastPos();
            this.addParticleDatas(this.particleDatas);
            this.initialized = true;
        }
        if (this.requireRemoval()) {
            this.m_107274_();
        } else {
            ++this.f_107224_;
            double ratio = (double)(entity.f_19797_ % 100) / 100.0;
            this.updateLastPos();
            this.m_107264_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            this.update();
            this.particleDatas.forEach(data -> this.onParticleDataUpdate((ParticleData)data, ratio));
        }
    }

    @Override
    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.f_107224_ <= 1) {
            return;
        }
        this.beginRender();
        float rot = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
        for (ParticleData data : this.particleDatas) {
            Quaternion rollTransform;
            Vec3 vecFromCamera = new Vec3(Mth.m_14139_((double)partialTicks, (double)data.oPos.f_82479_, (double)data.pos.f_82479_), Mth.m_14139_((double)partialTicks, (double)data.oPos.f_82480_, (double)data.pos.f_82480_), Mth.m_14139_((double)partialTicks, (double)data.oPos.f_82481_, (double)data.pos.f_82481_)).m_82546_(renderInfo.m_90583_());
            int light = this.m_6355_(partialTicks);
            if (this.f_107231_ == 0.0f) {
                rollTransform = renderInfo.m_90591_();
            } else {
                rollTransform = new Quaternion(renderInfo.m_90591_());
                rollTransform.m_80148_(Vector3f.f_122227_.m_122270_(rot + data.startRoll));
            }
            Vector3f[] vecFaceQuad = this.getFaceQuad();
            Arrays.stream(vecFaceQuad).forEach(v -> {
                v.m_122251_(rollTransform);
                v.m_122261_(data.size);
                v.m_122272_((float)vecFromCamera.f_82479_, (float)vecFromCamera.f_82480_, (float)vecFromCamera.f_82481_);
            });
            this.addQuad(buffer, vecFaceQuad, light);
        }
        this.endRender();
    }

    protected class ParticleData {
        protected float size;
        protected float startRoll;
        protected double angle;
        protected double yHeight;
        protected Vec3 oPos;
        protected Vec3 pos;

        protected ParticleData(float size, double angle, double yHeight) {
            this(size, angle, yHeight, 0.0f);
        }

        protected ParticleData(float size, double angle, double yHeight, float startRoll) {
            this.size = size * 0.2f;
            this.angle = angle;
            this.yHeight = yHeight;
            this.startRoll = startRoll;
        }
    }
}

