/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.item.ItemScrollBuff;

public class RandomScrollBuffFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "random_scroll_buff");
    public static final Serializer SERIALIZER = new Serializer();
    private final boolean isAncient;

    protected RandomScrollBuffFunction(LootItemCondition[] conditions, boolean isAncient) {
        super(conditions);
        this.isAncient = isAncient;
    }

    public LootItemFunctionType m_7162_() {
        return ModTombstone.RANDOM_SCROLL_BUFF;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        return ItemScrollBuff.SpellBuff.getRandomEnchantedScroll(true).orElse(stack);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomScrollBuffFunction> {
        public RandomScrollBuffFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new RandomScrollBuffFunction(conditionsIn, GsonHelper.m_13855_((JsonObject)json, (String)"ancient", (boolean)false));
        }

        public void serialize(JsonObject json, RandomScrollBuffFunction fct, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)fct, serializationContext);
            json.addProperty("ancient", Boolean.valueOf(fct.isAncient));
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final boolean isAncient;

        public Builder(boolean isAncient) {
            this.isAncient = isAncient;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new RandomScrollBuffFunction(this.m_80699_(), this.isAncient);
        }
    }
}

