/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemCastableMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModSounds;

public abstract class ItemGraveMagic
extends ItemCastableMagic
implements ISoulConsumer {
    protected static final String ANCIENT_NBT_BOOL = "ancient";
    protected static final String USE_COUNT_NBT_INT = "useCount";
    protected static final String COOLDOWN_TIME_NBT_LONG = "cooldown_time";

    protected ItemGraveMagic(String name, BooleanSupplier supplierBoolean) {
        super(name, ItemGraveMagic.getBuilder(), supplierBoolean);
    }

    protected ItemGraveMagic(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(name, builder, supplierEnabled);
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        return this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name).m_6270_(StyleType.MESSAGE_SPECIAL) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name).m_6270_(StyleType.MESSAGE_SPECIAL) : name);
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        if (this.isEnchanted(stack)) {
            int cd;
            int uses;
            if (this.canConsumeOnUse() && (uses = this.getUseCount(stack)) > 0) {
                this.addInfo(tooltip, LangKey.MESSAGE_USE_LEFT, uses);
            }
            if ((cd = this.getCooldown(level, stack)) > 10) {
                this.addWarn(tooltip, LangKey.MESSAGE_IN_COOLDOWN, TimeHelper.getTimeStringWithUnit(cd));
            }
        }
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        int cd = this.getCooldown(level, heldStack);
        if (cd > 0) {
            if (!level.m_5776_()) {
                EntityHelper.setGlobalItemCooldown(player, this, 20);
                LangKey.MESSAGE_IN_COOLDOWN.sendMessage(player, TimeHelper.getTimeStringWithUnit(cd));
            }
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        return this.isEnchanted(heldStack) ? super.m_7203_(level, player, hand) : InteractionResultHolder.m_19098_((Object)heldStack);
    }

    @Override
    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (this.isEnchanted(stack)) {
            super.onUsingTick(stack, entity, timeLeft);
        }
    }

    @Override
    protected void produceParticleCasting(ItemStack stack, Player player) {
        ModTombstone.PROXY.produceParticleCasting(this.getCastingType(stack), Optional.ofNullable((LivingEntity)TARGET.get(player.m_36316_().getId())).orElse((LivingEntity)player), p -> !player.m_6117_() || player.m_21252_() == 1);
    }

    protected CastingType getCastingType(ItemStack stack) {
        return CastingType.SIMPLE_TELEPORT;
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        if (this.isEnchanted(stack)) {
            int cd;
            ModSounds.playSoundAllAround(ModSounds.magic_use01, SoundSource.PLAYERS, (Level)level, player.m_20183_(), 0.5f, 0.5f);
            if (!stack.m_41619_() && (cd = this.getCastingCooldown()) > 0) {
                this.setCooldown((Level)level, stack, cd);
            }
        }
        return false;
    }

    @Override
    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        int useCount = this.getUseCount(stack);
        if (useCount < 2) {
            stack.m_41774_(1);
            return stack;
        }
        this.setUseCount(stack, --useCount);
        int cd = this.getCastingCooldown();
        if (cd > 0) {
            this.setCooldown(player.m_9236_(), stack, cd);
        }
        return stack;
    }

    protected int getCastingCooldown() {
        return 0;
    }

    public int getCooldown(@Nullable Level level, ItemStack stack) {
        return level != null && stack.m_150930_((Item)this) ? NBTStackHelper.getTimer(TimeHelper.worldTicks(level), stack, COOLDOWN_TIME_NBT_LONG, this.getCastingCooldown()) : 0;
    }

    public void setCooldown(@Nullable Level level, ItemStack stack, int time) {
        if (level != null && stack.m_150930_((Item)this)) {
            NBTStackHelper.setLong(stack, COOLDOWN_TIME_NBT_LONG, TimeHelper.worldTicks(level) + (long)time);
        }
    }

    @Override
    protected boolean canBlockInteractFirst(Level level, BlockPos pos, ItemStack stack) {
        return !this.isEnchanted(stack) || ModBlocks.isDecorativeGrave(level.m_8055_(pos).m_60734_());
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    protected abstract int getUseMax();

    protected int getUseCount(ItemStack stack) {
        if (stack.m_41720_() != this) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return Math.min(NBTStackHelper.getInteger(stack, USE_COUNT_NBT_INT, 0), this.getUseMax());
    }

    protected ItemStack setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, USE_COUNT_NBT_INT, Math.min(useCount, this.getUseMax()));
        }
        return stack;
    }

    public boolean isAncient(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, ANCIENT_NBT_BOOL);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new SoulConsumerProvider(this);
    }
}

