/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public abstract class TombstoneCommand {
    protected final Predicate<CommandSourceStack> singlePlayerOwner = source -> {
        if (source.m_81377_().m_6982_()) return false;
        if (!source.m_81377_().m_129792_()) return false;
        if (Optional.ofNullable(source.m_81373_()).filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).map(Player::m_36316_).map(profil -> source.m_81377_().m_7779_(profil)).orElse(false) == false) return false;
        return true;
    };
    protected final Predicate<CommandSourceStack> defaultPermission = source -> source.m_6761_(2) || this.singlePlayerOwner.test((CommandSourceStack)source);
    static final String PLAYER_PARAM = "player";
    static final String SOURCE_PARAM = "source";
    static final String TARGET_PARAM = "target";
    static final String BIOME_PARAM = "biome";
    static final String STRUCTURE_PARAM = "structure";
    static final String DIM_PARAM = "dim";
    static final String POS_PARAM = "pos";
    static final String AMOUNT_PARAM = "amount";
    static final SuggestionProvider<CommandSourceStack> AMOUNT_SUGGESTION = (ctx, build) -> build.suggest(1, () -> "[0-MAX]").buildFuture();

    public static boolean is(ParseResults<CommandSourceStack> parseResults) {
        List nodes = parseResults.getContext().getNodes();
        if (nodes.size() > 0) {
            String commandName = ((ParsedCommandNode)nodes.get(0)).getNode().getName();
            return Arrays.stream(CommandName.values()).anyMatch(v -> v.toString().equals(commandName));
        }
        return false;
    }

    protected abstract CommandName getCommandName();

    protected Component getUsage() {
        return Component.m_237115_((String)("tombstone.command." + this.getCommandName() + ".usage"));
    }

    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return this.defaultPermission;
    }

    int showUsage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_(this.getUsage(), false);
        return 1;
    }

    abstract LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> var1);

    public void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(this.getBuilder((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.m_82127_((String)this.getCommandName().toString()).requires(this.getInitialRequirement()))));
    }

    static void checkAlive(Entity entity) {
        if (!entity.m_6084_()) {
            throw LangKey.MESSAGE_DEAD_ENTITY.asCommandException(new Object[0]);
        }
    }

    static void checkNotSpectator(Entity entity) {
        if (entity.m_5833_()) {
            throw LangKey.MESSAGE_PLAYER_SPECTATOR.asCommandException(new Object[0]);
        }
    }

    static void checkValidPos(@Nullable Level level, BlockPos pos) {
        if (!Helper.isValidPos(level, pos)) {
            throw LangKey.MESSAGE_INVALID_LOCATION.asCommandException(new Object[0]);
        }
    }

    ServerLevel getOrThrowWorld(MinecraftServer server, ResourceKey<Level> dim) {
        ServerLevel level = server.m_129880_(dim);
        if (level == null) {
            throw LangKey.MESSAGE_NO_DIMENSION.asCommandException(new Object[0]);
        }
        return level;
    }

    protected void sendMessage(CommandSourceStack source, MutableComponent message, boolean allowLogging) {
        source.m_81354_((Component)message.m_6270_(StyleType.TOOLTIP_DESC), allowLogging);
    }

    private static CommandExceptionType createCommandExceptionType(LangKey langKey) {
        return new SimpleCommandExceptionType((Message)langKey.getText(new Object[0]));
    }

    private static CommandExceptionType createDynamicCommandExceptionType(LangKey langKey) {
        return new DynamicCommandExceptionType(xva$0 -> langKey.getText(xva$0));
    }

    static ServerPlayer getPlayerOrCommandSender(CommandContext<CommandSourceStack> ctx, String label) throws CommandSyntaxException {
        try {
            return EntityArgument.m_91474_(ctx, (String)label);
        }
        catch (CommandSyntaxException | IllegalArgumentException throwable) {
            return ((CommandSourceStack)ctx.getSource()).m_81375_();
        }
    }

    static int getInteger(CommandContext<CommandSourceStack> ctx, String label, int fallback) {
        try {
            return IntegerArgumentType.getInteger(ctx, (String)label);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return fallback;
        }
    }

    protected static enum CommandName {
        ACCEPT_TELEPORT("tbacceptteleport"),
        BIND("tbbind"),
        GUI("tbgui"),
        KNOWLEDGE("tbknowledge"),
        RECOVERY("tbrecovery"),
        REQUEST_TELEPORT("tbrequestteleport"),
        RESTORE_INVENTORY("tbrestoreinventory"),
        REVIVE_FAMILIAR("tbrevivefamiliar"),
        SHOW_LAST_GRAVE("tbshowlastgrave"),
        SIEGE("tbsiege"),
        TELEPORT("tbteleport");

        private final String name;

        private CommandName(String name) {
            this.name = name.toLowerCase(Locale.US);
        }

        public String toString() {
            return this.name;
        }
    }
}

