/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mcjty.lostcities.worldgen.lost.regassets.IAsset;
import mcjty.lostcities.worldgen.lost.regassets.data.BiomeMatcher;
import mcjty.lostcities.worldgen.lost.regassets.data.BlockMatcher;
import mcjty.lostcities.worldgen.lost.regassets.data.ResourceLocationMatcher;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class StuffSettingsRE
implements IAsset<StuffSettingsRE> {
    public static final Codec<StuffSettingsRE> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("tags").forGetter(l -> l.tags.isEmpty() ? Optional.empty() : Optional.of(l.tags)), (App)Codec.STRING.fieldOf("column").forGetter(l -> l.column), (App)Codec.INT.optionalFieldOf("minheight").forGetter(l -> Optional.ofNullable(l.minheight)), (App)Codec.INT.optionalFieldOf("maxheight").forGetter(l -> Optional.ofNullable(l.maxheight)), (App)Codec.INT.fieldOf("mincount").forGetter(l -> l.mincount), (App)Codec.INT.fieldOf("maxcount").forGetter(l -> l.maxcount), (App)Codec.INT.fieldOf("attempts").forGetter(l -> l.attempts), (App)Codec.BOOL.optionalFieldOf("inbuilding").forGetter(l -> Optional.ofNullable(l.inbuilding)), (App)Codec.BOOL.optionalFieldOf("seesky").forGetter(l -> Optional.ofNullable(l.seesky)), (App)BiomeMatcher.CODEC.optionalFieldOf("biomes").forGetter(l -> Optional.ofNullable(l.biomeMatcher)), (App)BlockMatcher.CODEC.optionalFieldOf("blocks").forGetter(l -> Optional.ofNullable(l.blockMatcher)), (App)BlockMatcher.CODEC.optionalFieldOf("upperblocks").forGetter(l -> Optional.ofNullable(l.upperBlockMatcher)), (App)ResourceLocationMatcher.CODEC.optionalFieldOf("buildings").forGetter(l -> Optional.ofNullable(l.buildingMatcher))).apply((Applicative)instance, StuffSettingsRE::new));
    private ResourceLocation name;
    private final List<String> tags;
    private final String column;
    private final Integer minheight;
    private final Integer maxheight;
    private final int mincount;
    private final int maxcount;
    private final int attempts;
    private final Boolean inbuilding;
    private final Boolean seesky;
    private final BiomeMatcher biomeMatcher;
    private final BlockMatcher blockMatcher;
    private final BlockMatcher upperBlockMatcher;
    private final ResourceLocationMatcher buildingMatcher;

    public StuffSettingsRE(Optional<List<String>> tags, String column, Optional<Integer> minheight, Optional<Integer> maxheight, int mincount, int maxcount, int attempts, Optional<Boolean> inbuilding, Optional<Boolean> seesky, Optional<BiomeMatcher> biomeMatcher, Optional<BlockMatcher> blockMatcher, Optional<BlockMatcher> upperBlockMatcher, Optional<ResourceLocationMatcher> buildingMatcher) {
        this.tags = tags.orElse(Collections.emptyList());
        this.column = column;
        this.minheight = minheight.orElse(null);
        this.maxheight = maxheight.orElse(null);
        this.mincount = mincount;
        this.maxcount = maxcount;
        this.attempts = attempts;
        this.inbuilding = inbuilding.orElse(null);
        this.seesky = seesky.orElse(null);
        this.biomeMatcher = biomeMatcher.orElse(BiomeMatcher.ANY);
        this.blockMatcher = blockMatcher.orElse(BlockMatcher.ANY);
        this.upperBlockMatcher = upperBlockMatcher.orElse(BlockMatcher.ANY);
        this.buildingMatcher = buildingMatcher.orElse(ResourceLocationMatcher.ANY);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getColumn() {
        return this.column;
    }

    public Integer getMinheight() {
        return this.minheight;
    }

    public Integer getMaxheight() {
        return this.maxheight;
    }

    public int getMincount() {
        return this.mincount;
    }

    public int getMaxcount() {
        return this.maxcount;
    }

    public BiomeMatcher getBiomeMatcher() {
        return this.biomeMatcher;
    }

    public BlockMatcher getBlockMatcher() {
        return this.blockMatcher;
    }

    public BlockMatcher getUpperBlockMatcher() {
        return this.upperBlockMatcher;
    }

    public ResourceLocationMatcher getBuildingMatcher() {
        return this.buildingMatcher;
    }

    public Boolean isInBuilding() {
        return this.inbuilding;
    }

    public Boolean isSeesky() {
        return this.seesky;
    }

    public int getAttempts() {
        return this.attempts;
    }

    @Override
    public StuffSettingsRE setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }
}

