/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.worldgen.lost.regassets.ScatteredRE;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public class Scattered
implements ILostCityAsset {
    private final ResourceLocation name;
    private final List<String> buildings;
    private final String multibuilding;
    private final TerrainHeight terrainheight;
    private final TerrainFix terrainfix;
    private final int heightoffset;

    public Scattered(ScatteredRE object) {
        this.name = object.getRegistryName();
        this.buildings = object.getBuildings();
        this.multibuilding = object.getMultibuilding();
        this.terrainheight = object.getTerrainheight();
        this.terrainfix = object.getTerrainfix();
        this.heightoffset = object.getHeightoffset();
    }

    @Nullable
    public List<String> getBuildings() {
        return this.buildings;
    }

    @Nullable
    public String getMultibuilding() {
        return this.multibuilding;
    }

    public TerrainHeight getTerrainheight() {
        return this.terrainheight;
    }

    public TerrainFix getTerrainfix() {
        return this.terrainfix;
    }

    public int getHeightoffset() {
        return this.heightoffset;
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    public static enum TerrainHeight implements StringRepresentable
    {
        LOWEST("lowest"),
        AVERAGE("average"),
        HIGHEST("highest"),
        OCEAN("ocean");

        private static final Map<String, TerrainHeight> BY_NAME;
        private final String name;

        private TerrainHeight(String name) {
            this.name = name;
        }

        public static final TerrainHeight byName(String name) {
            return BY_NAME.get(name);
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(TerrainHeight.values()).collect(Collectors.toMap(TerrainHeight::m_7912_, v -> v));
        }
    }

    public static enum TerrainFix implements StringRepresentable
    {
        NONE("none"),
        CLEAR("clear"),
        REPEATSLICE("repeatslice");

        private static final Map<String, TerrainFix> BY_NAME;
        private final String name;

        private TerrainFix(String name) {
            this.name = name;
        }

        public static final TerrainFix byName(String name) {
            return BY_NAME.get(name);
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(TerrainFix.values()).collect(Collectors.toMap(TerrainFix::m_7912_, v -> v));
        }
    }
}

