/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.ArrayList;
import java.util.List;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.worldgen.lost.regassets.PredefinedCityRE;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedBuilding;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedStreet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PredefinedCity
implements ILostCityAsset {
    private final ResourceLocation name;
    private final ResourceKey<Level> dimension;
    private final int chunkX;
    private final int chunkZ;
    private final int radius;
    private final String cityStyle;
    private final List<PredefinedBuilding> predefinedBuildings = new ArrayList<PredefinedBuilding>();
    private final List<PredefinedStreet> predefinedStreets = new ArrayList<PredefinedStreet>();

    public PredefinedCity(PredefinedCityRE object) {
        this.name = object.getRegistryName();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(object.getDimension()));
        this.chunkX = object.getChunkX();
        this.chunkZ = object.getChunkZ();
        this.radius = object.getRadius();
        this.cityStyle = object.getCityStyle();
        if (object.getPredefinedBuildings() != null) {
            this.predefinedBuildings.addAll(object.getPredefinedBuildings());
        }
        if (object.getPredefinedStreets() != null) {
            this.predefinedStreets.addAll(object.getPredefinedStreets());
        }
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public int getRadius() {
        return this.radius;
    }

    public String getCityStyle() {
        return this.cityStyle;
    }

    public List<PredefinedBuilding> getPredefinedBuildings() {
        return this.predefinedBuildings;
    }

    public List<PredefinedStreet> getPredefinedStreets() {
        return this.predefinedStreets;
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }
}

