/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mcjty.lostcities.api.ILostCityCityStyle;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.regassets.CityStyleRE;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.ObjectSelector;
import mcjty.lostcities.worldgen.lost.regassets.data.StreetParts;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.CommonLevelAccessor;

public class CityStyle
implements ILostCityCityStyle {
    private final ResourceLocation name;
    private final Set<String> stuffTags = new HashSet<String>();
    private final List<ObjectSelector> buildingSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> bridgeSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> parkSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> fountainSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> stairSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> frontSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> railDungeonSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> multiBuildingSelector = new ArrayList<ObjectSelector>();
    private StreetParts streetParts = StreetParts.DEFAULT;
    private Integer minFloorCount;
    private Integer minCellarCount;
    private Integer maxFloorCount;
    private Integer maxCellarCount;
    private Float buildingChance;
    private Integer streetWidth;
    private Character streetBlock;
    private Character streetBaseBlock;
    private Character streetVariantBlock;
    private Character borderBlock;
    private Character wallBlock;
    private Character parkElevationBlock;
    private Character grassBlock;
    private Character corridorRoofBlock;
    private Character corridorGlassBlock;
    private Character railMainBlock;
    private Character sphereBlock;
    private Character sphereSideBlock;
    private Character sphereGlassBlock;
    private Character ironbarsBlock;
    private Character glowstoneBlock;
    private Character leavesBlock;
    private Character rubbleDirtBlock;
    private Float explosionChance;
    private String style;
    private final String inherit;
    private boolean resolveInherit = false;

    public CityStyle(CityStyleRE object) {
        this.name = object.getRegistryName();
        this.inherit = object.getInherit();
        this.style = object.getStyle();
        this.stuffTags.add("all");
        if (object.getStuffTags() != null) {
            this.stuffTags.addAll(object.getStuffTags());
        }
        this.explosionChance = object.getExplosionChance();
        object.getBuildingSettings().ifPresent(s -> {
            this.buildingChance = s.getBuildingChance();
            this.maxCellarCount = s.getMaxCellarCount();
            this.maxFloorCount = s.getMaxFloorCount();
            this.minCellarCount = s.getMinCellarCount();
            this.minFloorCount = s.getMinFloorCount();
        });
        object.getCorridorSettings().ifPresent(s -> {
            this.corridorGlassBlock = s.getCorridorGlassBlock();
            this.corridorRoofBlock = s.getCorridorRoofBlock();
        });
        object.getRailSettings().ifPresent(s -> {
            this.railMainBlock = s.getRailMainBlock();
        });
        object.getParkSettings().ifPresent(s -> {
            this.grassBlock = s.getGrassBlock();
            this.parkElevationBlock = s.getParkElevationBlock();
        });
        object.getSphereSettings().ifPresent(s -> {
            this.sphereBlock = s.getSphereBlock();
            this.sphereGlassBlock = s.getSphereGlassBlock();
            this.sphereSideBlock = s.getSphereSideBlock();
        });
        object.getStreetSettings().ifPresent(s -> {
            this.borderBlock = s.getBorderBlock();
            this.streetBaseBlock = s.getStreetBaseBlock();
            this.streetBlock = s.getStreetBlock();
            this.streetVariantBlock = s.getStreetVariantBlock();
            this.wallBlock = s.getWallBlock();
            this.streetWidth = s.getStreetWidth();
            this.streetParts = s.getParts();
        });
        object.getGeneralSettings().ifPresent(s -> {
            this.glowstoneBlock = s.getGlowstoneBlock();
            this.ironbarsBlock = s.getIronbarsBlock();
            this.leavesBlock = s.getLeavesBlock();
            this.rubbleDirtBlock = s.getRubbleDirtBlock();
        });
        object.getSelectors().ifPresent(s -> {
            s.getBridgeSelector().ifPresent(this.bridgeSelector::addAll);
            s.getBuildingSelector().ifPresent(this.buildingSelector::addAll);
            s.getFountainSelector().ifPresent(this.fountainSelector::addAll);
            s.getFrontSelector().ifPresent(this.frontSelector::addAll);
            s.getParkSelector().ifPresent(this.parkSelector::addAll);
            s.getMultiBuildingSelector().ifPresent(this.multiBuildingSelector::addAll);
            s.getRailDungeonSelector().ifPresent(this.railDungeonSelector::addAll);
            s.getStairSelector().ifPresent(this.stairSelector::addAll);
        });
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public Float getExplosionChance() {
        return this.explosionChance;
    }

    @Override
    public int getStreetWidth() {
        return this.streetWidth;
    }

    public StreetParts getStreetParts() {
        return this.streetParts;
    }

    @Override
    public Integer getMinFloorCount() {
        return this.minFloorCount;
    }

    @Override
    public Integer getMinCellarCount() {
        return this.minCellarCount;
    }

    @Override
    public Integer getMaxFloorCount() {
        return this.maxFloorCount;
    }

    @Override
    public Integer getMaxCellarCount() {
        return this.maxCellarCount;
    }

    @Override
    public Float getBuildingChance() {
        return this.buildingChance;
    }

    @Override
    public Character getGrassBlock() {
        return this.grassBlock;
    }

    @Override
    public Character getIronbarsBlock() {
        return this.ironbarsBlock;
    }

    @Override
    public Character getGlowstoneBlock() {
        return this.glowstoneBlock;
    }

    @Override
    public Character getLeavesBlock() {
        return this.leavesBlock;
    }

    public Character getRubbleDirtBlock() {
        return this.rubbleDirtBlock;
    }

    @Override
    public Character getStreetBlock() {
        return this.streetBlock;
    }

    @Override
    public Character getStreetBaseBlock() {
        return this.streetBaseBlock;
    }

    @Override
    public Character getStreetVariantBlock() {
        return this.streetVariantBlock;
    }

    @Override
    public Character getRailMainBlock() {
        return this.railMainBlock;
    }

    @Override
    public Character getParkElevationBlock() {
        return this.parkElevationBlock;
    }

    @Override
    public Character getCorridorRoofBlock() {
        return this.corridorRoofBlock;
    }

    @Override
    public Character getCorridorGlassBlock() {
        return this.corridorGlassBlock;
    }

    @Override
    public Character getBorderBlock() {
        return this.borderBlock;
    }

    @Override
    public Character getWallBlock() {
        return this.wallBlock;
    }

    public Character getSphereBlock() {
        return this.sphereBlock;
    }

    public Character getSphereSideBlock() {
        return this.sphereSideBlock;
    }

    public Character getSphereGlassBlock() {
        return this.sphereGlassBlock;
    }

    @Override
    public void init(CommonLevelAccessor level) {
        if (!this.resolveInherit) {
            this.resolveInherit = true;
            if (this.inherit != null) {
                CityStyle inheritFrom = AssetRegistries.CITYSTYLES.getOrThrow(level, this.inherit);
                if (this.style == null) {
                    this.style = inheritFrom.getStyle();
                }
                this.stuffTags.addAll(inheritFrom.stuffTags);
                this.buildingSelector.addAll(inheritFrom.buildingSelector);
                this.bridgeSelector.addAll(inheritFrom.bridgeSelector);
                this.parkSelector.addAll(inheritFrom.parkSelector);
                this.fountainSelector.addAll(inheritFrom.fountainSelector);
                this.stairSelector.addAll(inheritFrom.stairSelector);
                this.frontSelector.addAll(inheritFrom.frontSelector);
                this.railDungeonSelector.addAll(inheritFrom.railDungeonSelector);
                this.multiBuildingSelector.addAll(inheritFrom.multiBuildingSelector);
                if (this.explosionChance == null) {
                    this.explosionChance = inheritFrom.explosionChance;
                }
                if (this.streetWidth == null) {
                    this.streetWidth = inheritFrom.streetWidth;
                }
                if (this.streetParts == StreetParts.DEFAULT) {
                    this.streetParts = inheritFrom.streetParts;
                }
                if (this.minFloorCount == null) {
                    this.minFloorCount = inheritFrom.minFloorCount;
                }
                if (this.minCellarCount == null) {
                    this.minCellarCount = inheritFrom.minCellarCount;
                }
                if (this.maxFloorCount == null) {
                    this.maxFloorCount = inheritFrom.maxFloorCount;
                }
                if (this.maxCellarCount == null) {
                    this.maxCellarCount = inheritFrom.maxCellarCount;
                }
                if (this.buildingChance == null) {
                    this.buildingChance = inheritFrom.buildingChance;
                }
                if (this.streetBlock == null) {
                    this.streetBlock = inheritFrom.streetBlock;
                }
                if (this.streetBaseBlock == null) {
                    this.streetBaseBlock = inheritFrom.streetBaseBlock;
                }
                if (this.streetVariantBlock == null) {
                    this.streetVariantBlock = inheritFrom.streetVariantBlock;
                }
                if (this.parkElevationBlock == null) {
                    this.parkElevationBlock = inheritFrom.parkElevationBlock;
                }
                if (this.corridorRoofBlock == null) {
                    this.corridorRoofBlock = inheritFrom.corridorRoofBlock;
                }
                if (this.corridorGlassBlock == null) {
                    this.corridorGlassBlock = inheritFrom.corridorGlassBlock;
                }
                if (this.railMainBlock == null) {
                    this.railMainBlock = inheritFrom.railMainBlock;
                }
                if (this.borderBlock == null) {
                    this.borderBlock = inheritFrom.borderBlock;
                }
                if (this.wallBlock == null) {
                    this.wallBlock = inheritFrom.wallBlock;
                }
                if (this.sphereBlock == null) {
                    this.sphereBlock = inheritFrom.sphereBlock;
                }
                if (this.sphereSideBlock == null) {
                    this.sphereSideBlock = inheritFrom.sphereSideBlock;
                }
                if (this.sphereGlassBlock == null) {
                    this.sphereGlassBlock = inheritFrom.sphereGlassBlock;
                }
            }
        }
    }

    private static String getRandomFromList(RandomSource random, List<ObjectSelector> list) {
        ObjectSelector fromList = Tools.getRandomFromList(random, list, ObjectSelector::factor);
        if (fromList == null) {
            return null;
        }
        return fromList.value();
    }

    private static String getRandomFromList(Random random, List<ObjectSelector> list) {
        ObjectSelector fromList = Tools.getRandomFromList(random, list, ObjectSelector::factor);
        if (fromList == null) {
            return null;
        }
        return fromList.value();
    }

    public Set<String> getStuffTags() {
        return this.stuffTags;
    }

    public String getRandomStair(Random random) {
        return CityStyle.getRandomFromList(random, this.stairSelector);
    }

    public String getRandomFront(Random random) {
        return CityStyle.getRandomFromList(random, this.frontSelector);
    }

    public String getRandomRailDungeon(Random random) {
        return CityStyle.getRandomFromList(random, this.railDungeonSelector);
    }

    public String getRandomPark(Random random) {
        return CityStyle.getRandomFromList(random, this.parkSelector);
    }

    public String getRandomBridge(Random random) {
        return CityStyle.getRandomFromList(random, this.bridgeSelector);
    }

    public String getRandomFountain(Random random) {
        return CityStyle.getRandomFromList(random, this.fountainSelector);
    }

    public String getRandomBuilding(Random random) {
        return CityStyle.getRandomFromList(random, this.buildingSelector);
    }

    public String getRandomMultiBuilding(Random random) {
        return CityStyle.getRandomFromList(random, this.multiBuildingSelector);
    }

    public boolean hasMultiBuildings() {
        return !this.multiBuildingSelector.isEmpty();
    }

    public List<ObjectSelector> getMultiBuildingSelector() {
        return this.multiBuildingSelector;
    }
}

