/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.varia;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;

public class TodoQueue<T> {
    private final Queue<Todo<T>> queue = new ArrayDeque<Todo<T>>();

    public void add(BlockPos pos, T data) {
        this.queue.add(new Todo<T>(pos, data));
    }

    public T get() {
        Todo<T> todo = this.queue.poll();
        return todo == null ? null : (T)todo.data;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int getSize() {
        return this.queue.size();
    }

    public void forEach(BiConsumer<BlockPos, T> consumer) {
        this.queue.forEach((? super T todo) -> consumer.accept(todo.pos, todo.data));
    }

    public int forEach(int n, BiConsumer<BlockPos, T> consumer) {
        Todo<T> todo;
        int cnt = 0;
        for (int i = 0; i < n && (todo = this.queue.poll()) != null; ++i) {
            consumer.accept(todo.pos, (BlockPos)todo.data);
            ++cnt;
        }
        return cnt;
    }

    private record Todo<D>(BlockPos pos, D data) {
    }
}

