/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class SquadHandler {
    private ISculkSmartEntity sculkSmartEntity;
    public Optional<ISculkSmartEntity> squadLeader = Optional.empty();
    public final ArrayList<ISculkSmartEntity> squadMembers = new ArrayList();
    private final int squadSize = 10;

    public SquadHandler(ISculkSmartEntity entity) {
        this.sculkSmartEntity = entity;
    }

    public Mob getMob() {
        return (Mob)this.sculkSmartEntity;
    }

    public static boolean doesSquadExist(SquadHandler squad) {
        if (squad == null) {
            return false;
        }
        return !squad.isSquadLeaderDead();
    }

    public boolean isSquadLeader() {
        if (this.squadLeader.isEmpty()) {
            return false;
        }
        return ((Mob)this.squadLeader.get()).m_20148_().equals(this.getMob().m_20148_());
    }

    public boolean isSquadJoinable() {
        return this.squadMembers.size() < 10;
    }

    public boolean isSquadLeaderDead() {
        return !this.squadLeader.isPresent() || ((Mob)this.squadLeader.get()).m_21224_();
    }

    public boolean isEntireSquadDead() {
        this.removeDeadMembersFromSquad();
        return this.squadLeader.isEmpty() && this.squadMembers.isEmpty();
    }

    public void removeDeadMembersFromSquad() {
        if (this.squadLeader.isPresent() && ((Mob)this.squadLeader.get()).m_21224_()) {
            this.squadLeader = Optional.empty();
        }
        for (int i = 0; i < this.squadMembers.size(); ++i) {
            Mob member = (Mob)this.squadMembers.get(i);
            if (member.m_6084_()) continue;
            this.squadMembers.remove(i);
            --i;
        }
    }

    public boolean tryToAcceptMemberIntoSquad(ISculkSmartEntity joiningMob) {
        if (this.isSquadJoinable()) {
            this.squadMembers.add(joiningMob);
            joiningMob.getSquad().squadLeader = Optional.ofNullable(this.sculkSmartEntity);
            return true;
        }
        return false;
    }

    public void forceAcceptMemberIntoSquad(ISculkSmartEntity joiningMob) {
        this.squadMembers.add(joiningMob);
        joiningMob.getSquad().squadLeader = Optional.of(this.sculkSmartEntity);
    }

    public void createSquad() {
        this.squadLeader = Optional.ofNullable(this.sculkSmartEntity);
    }

    public void disbandSquad() {
        for (ISculkSmartEntity member : this.squadMembers) {
            member.getSquad().squadLeader = Optional.empty();
        }
        this.squadMembers.clear();
        this.squadLeader = Optional.empty();
    }

    public ISculkSmartEntity getMobMemberWithMostMaxHealth() {
        if (this.isEntireSquadDead()) {
            return null;
        }
        Mob squadLeaderAsMob = (Mob)this.squadLeader.get();
        ISculkSmartEntity result = this.squadLeader.get();
        double squadLeaderMaxHealth = squadLeaderAsMob.m_21233_();
        for (int i = 0; i < this.squadMembers.size(); ++i) {
            Mob compareMob = (Mob)this.squadMembers.get(i);
            if (!((double)compareMob.m_21233_() > squadLeaderMaxHealth)) continue;
            result = this.squadMembers.get(i);
        }
        return result;
    }

    public static void promoteToLeaderOfSquad(ISculkSmartEntity entity, SquadHandler oldSquad) {
        entity.getSquad().createSquad();
        if (oldSquad.squadLeader.isPresent()) {
            entity.getSquad().forceAcceptMemberIntoSquad(oldSquad.squadLeader.get());
        }
        for (ISculkSmartEntity member : oldSquad.squadMembers) {
            member.getSquad().squadLeader = Optional.of(entity);
            entity.getSquad().forceAcceptMemberIntoSquad(member);
        }
    }

    public LivingEntity getSquadTarget() {
        return this.squadLeader.map(iSculkSmartEntity -> ((Mob)iSculkSmartEntity).m_5448_()).orElse(null);
    }
}

