/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.util;

import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Cursor {
    protected ServerLevel level;
    protected BlockPos pos;
    protected final Random random = new Random();
    protected boolean toBeDeleted = false;
    boolean isActive = false;
    protected State state = State.IDLE;
    protected int MAX_TRANSFORMATIONS = 100;
    protected int currentTransformations = 0;
    protected int MAX_RANGE = 20;
    protected long MAX_LIFETIME_MILLIS = TimeUnit.SECONDS.toMillis(300L);
    protected long creationTickTime = System.currentTimeMillis();
    protected long lastTickTime = 0L;
    protected int searchIterationsPerTick = 20;
    protected long tickIntervalMilliseconds = 1000L;
    protected BlockPos origin = BlockPos.f_121853_;
    protected BlockPos target = BlockPos.f_121853_;
    Queue<BlockPos> queue = new LinkedList<BlockPos>();
    public boolean isSuccessful = false;
    protected HashMap<Long, Boolean> visitedPositons = new HashMap();

    public Cursor(Level worldIn) {
        this.creationTickTime = System.currentTimeMillis();
        this.level = (ServerLevel)worldIn;
    }

    public ServerLevel level() {
        return this.level;
    }

    public BlockPos blockPosition() {
        return this.pos;
    }

    public void setPos(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public double getX() {
        return this.pos.m_123341_();
    }

    public double getY() {
        return this.pos.m_123342_();
    }

    public double getZ() {
        return this.pos.m_123343_();
    }

    public Random getRandom() {
        return this.random;
    }

    public double getRandomX(double range) {
        return this.getX() + (this.getRandom().nextDouble() - 0.5) * range;
    }

    public double getRandomY() {
        return this.getY() + this.getRandom().nextDouble() * 1.5;
    }

    public double getRandomZ(double range) {
        return this.getZ() + (this.getRandom().nextDouble() - 0.5) * range;
    }

    public void setToBeDeleted(boolean toBeDeleted) {
        this.toBeDeleted = toBeDeleted;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public int getCurrentTransformations() {
        return this.currentTransformations;
    }

    public void setTarget(BlockPos target) {
        this.target = target;
    }

    public void setMaxTransformations(int MAX_INFECTIONS) {
        this.MAX_TRANSFORMATIONS = MAX_INFECTIONS;
    }

    public void setMaxRange(int MAX_RANGE) {
        this.MAX_RANGE = MAX_RANGE;
    }

    public void setMaxLifeTimeMillis(long MAX_LIFETIME) {
        this.MAX_LIFETIME_MILLIS = MAX_LIFETIME;
    }

    public void setSearchIterationsPerTick(int iterations) {
        this.searchIterationsPerTick = iterations;
    }

    public void setTickIntervalMilliseconds(long milliseconds) {
        this.tickIntervalMilliseconds = milliseconds;
    }

    public void setState(State state2) {
        this.state = state2;
    }

    protected boolean isNotObstructed(BlockState state2, BlockPos pos) {
        if (SculkHorde.savedData.getSculkAccumulatedMass() <= 0) {
            return false;
        }
        if (!state2.m_60804_((BlockGetter)this.level, pos)) {
            return false;
        }
        if (BlockAlgorithms.getBlockDistance(this.origin, pos) > (float)this.MAX_RANGE) {
            return false;
        }
        if (state2.m_60795_()) {
            return false;
        }
        return !this.visitedPositons.containsKey(pos.m_121878_());
    }

    protected boolean isTarget(BlockState state2, BlockPos pos) {
        return state2.equals(Blocks.f_50090_.m_49966_());
    }

    protected void transformBlock(BlockPos pos) {
        this.level.m_46597_(pos, Blocks.f_50090_.m_49966_());
    }

    protected void spawnParticleEffects() {
        this.level.m_7106_((ParticleOptions)ParticleTypes.f_123767_, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.1, 0.0);
    }

    public void start() {
        this.isActive = true;
    }

    protected boolean searchTick() {
        for (int i = 0; i < Math.max(this.searchIterationsPerTick, 1); ++i) {
            if (this.queue.isEmpty()) {
                this.isSuccessful = false;
                this.setTarget(BlockPos.f_121853_);
                return true;
            }
            BlockPos currentBlock = this.queue.poll();
            if (this.isTarget(this.level.m_8055_(currentBlock), currentBlock)) {
                this.isSuccessful = true;
                this.setTarget(currentBlock);
                return true;
            }
            ArrayList<BlockPos> possiblePaths = BlockAlgorithms.getNeighborsCube(currentBlock, false);
            Collections.shuffle(possiblePaths);
            for (BlockPos neighbor : possiblePaths) {
                if (this.visitedPositons.containsKey(neighbor.m_121878_()) || !this.isNotObstructed(this.level.m_8055_(neighbor), neighbor)) continue;
                this.queue.add(neighbor);
                this.visitedPositons.put(neighbor.m_121878_(), true);
            }
        }
        return false;
    }

    public void tick() {
        long currentLifeTimeMilliseconds;
        double tickIntervalMillisecondsAfterMultiplier;
        float timeElapsedMilliSeconds = System.currentTimeMillis() - this.lastTickTime;
        if ((double)timeElapsedMilliSeconds < Math.max(tickIntervalMillisecondsAfterMultiplier = (double)this.tickIntervalMilliseconds - (double)this.tickIntervalMilliseconds * (Double)ModConfig.SERVER.infestation_speed_multiplier.get(), 1.0)) {
            return;
        }
        this.lastTickTime = System.currentTimeMillis();
        if (this.level.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.spawnParticleEffects();
            }
            return;
        }
        if (this.origin == BlockPos.f_121853_) {
            this.origin = this.blockPosition();
        }
        if ((currentLifeTimeMilliseconds = System.currentTimeMillis() - this.creationTickTime) >= this.MAX_LIFETIME_MILLIS) {
            this.setState(State.FINISHED);
        } else if (this.currentTransformations >= this.MAX_TRANSFORMATIONS) {
            this.setState(State.FINISHED);
        }
        if (this.state == State.IDLE) {
            if (!this.isActive) {
                return;
            }
            this.queue.add(this.blockPosition());
            this.setState(State.SEARCHING);
        } else if (this.state == State.SEARCHING) {
            if (!this.searchTick()) {
                return;
            }
            if (this.target.equals((Object)BlockPos.f_121853_)) {
                this.state = State.FINISHED;
                this.setState(this.state);
            } else {
                this.state = State.EXPLORING;
                this.setState(this.state);
                this.visitedPositons.clear();
            }
        } else if (this.state == State.EXPLORING) {
            ArrayList<BlockPos> neighbors = BlockAlgorithms.getNeighborsCube(this.blockPosition(), false);
            ArrayList<BlockPos> unobstructedNeighbors = new ArrayList<BlockPos>();
            for (BlockPos blockPos : neighbors) {
                if (!this.isNotObstructed(this.level.m_8055_(blockPos), blockPos)) continue;
                unobstructedNeighbors.add(blockPos);
            }
            if (neighbors.size() == 0) {
                return;
            }
            BlockPos closest = neighbors.get(0);
            for (BlockPos pos : neighbors) {
                if (!(BlockAlgorithms.getBlockDistance(pos, this.target) < BlockAlgorithms.getBlockDistance(closest, this.target))) continue;
                closest = pos;
            }
            this.setPos(closest.m_123341_(), closest.m_123342_(), closest.m_123343_());
            if (this.blockPosition().equals((Object)this.target)) {
                this.setTarget(BlockPos.f_121853_);
                BlockState blockState = this.level.m_8055_(this.blockPosition());
                boolean isTarget = this.isTarget(blockState, this.blockPosition());
                boolean isNotObstructed = this.isNotObstructed(blockState, this.blockPosition());
                if (isTarget && isNotObstructed) {
                    this.transformBlock(this.blockPosition());
                    ++this.currentTransformations;
                }
                this.setState(State.SEARCHING);
                this.visitedPositons.clear();
                this.queue.clear();
                this.queue.add(this.blockPosition());
            }
            this.visitedPositons.put(closest.m_121878_(), true);
        } else if (this.state == State.FINISHED) {
            this.setToBeDeleted(true);
        }
    }

    protected static enum State {
        IDLE,
        SEARCHING,
        EXPLORING,
        FINISHED;

    }
}

