/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind.entity_factory;

import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.Gravemind;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactoryEntry;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EntityFactory {
    private static ArrayList<EntityFactoryEntry> entries;
    private static Random rng;

    public EntityFactory() {
        entries = new ArrayList();
        rng = new Random();
    }

    public EntityFactoryEntry addEntry(EntityType entity, int cost, StrategicValues value, Gravemind.evolution_states minEvolution) {
        EntityFactoryEntry entry = new EntityFactoryEntry(entity, cost, value, minEvolution);
        entries.add(entry);
        return entry;
    }

    public static Optional<EntityFactoryEntry> getRandomEntry(Predicate<EntityFactoryEntry> predicate) {
        Optional<EntityFactoryEntry> output = Optional.empty();
        ArrayList<EntityFactoryEntry> possibleEntries = new ArrayList<EntityFactoryEntry>();
        for (EntityFactoryEntry entry : entries) {
            if (!predicate.test(entry) || !entry.isEntryAppropriateMinimalCheck()) continue;
            possibleEntries.add(entry);
        }
        if (possibleEntries.size() > 0) {
            output = Optional.of((EntityFactoryEntry)possibleEntries.get(rng.nextInt(possibleEntries.size())));
        }
        return output;
    }

    public static Optional<EntityFactoryEntry> getEntry(EntityType<Mob> entityType) {
        Optional<EntityFactoryEntry> output = Optional.empty();
        for (EntityFactoryEntry entry : entries) {
            if (entry.getEntity() != entityType) continue;
            output = Optional.of(entry);
            break;
        }
        return output;
    }

    public static void spawnReinforcementOfThisEntityType(EntityType entityType, Level level, BlockPos pos) {
        Optional<EntityFactoryEntry> entry = EntityFactory.getEntry((EntityType<Mob>)entityType);
        if (entry.isPresent()) {
            entry.get().getEntity().m_20600_((ServerLevel)level, (CompoundTag)null, (Component)null, (Player)null, pos, MobSpawnType.SPAWNER, false, false);
            SculkHorde.statisticsData.incrementTotalUnitsSpawned();
        }
    }

    public void createReinforcementRequestFromSummoner(Level world, BlockPos spawnPosition, boolean noCost, ReinforcementRequest context) {
        int i;
        boolean DEBUG_THIS = false;
        if (DEBUG_THIS) {
            System.out.println("Reinforcement Request Recieved.");
        }
        if (SculkHorde.savedData == null) {
            return;
        }
        if (SculkHorde.savedData.getSculkAccumulatedMass() <= 0) {
            return;
        }
        SculkHorde.gravemind.processReinforcementRequest(context);
        if (!context.isRequestApproved) {
            return;
        }
        ArrayList<EntityFactoryEntry> possibleReinforcements = new ArrayList<EntityFactoryEntry>();
        for (EntityFactoryEntry entry : entries) {
            if (!entry.isEntryAppropriate(context)) continue;
            possibleReinforcements.add(entry);
        }
        if (possibleReinforcements.isEmpty()) {
            return;
        }
        EntityFactoryEntry[] mobsToSpawn = new EntityFactoryEntry[context.positions.length];
        HashMap<EntityType, Integer> mobCount = new HashMap<EntityType, Integer>();
        for (i = 0; i < context.positions.length; ++i) {
            if (context.positions[i] == null) continue;
            EntityFactoryEntry randomEntry = null;
            for (int attemptsToGetEntry = 0; randomEntry == null && attemptsToGetEntry < 10; ++attemptsToGetEntry) {
                int randomEntryIndex = rng.nextInt(possibleReinforcements.size());
                randomEntry = (EntityFactoryEntry)possibleReinforcements.get(randomEntryIndex);
                if (randomEntry.getLimit() <= 0 || randomEntry.getLimit() <= mobCount.getOrDefault(randomEntry.getEntity(), 0)) continue;
                mobsToSpawn[i] = randomEntry;
                mobCount.put(randomEntry.getEntity(), mobCount.getOrDefault(randomEntry.getEntity(), 0) + 1);
            }
        }
        for (i = 0; i < mobsToSpawn.length; ++i) {
            if (mobsToSpawn[i] == null) continue;
            EntityFactoryEntry mob = mobsToSpawn[i];
            context.spawnedEntities[i] = (LivingEntity)mob.getEntity().m_20600_((ServerLevel)world, (CompoundTag)null, (Component)null, (Player)null, context.positions[i], MobSpawnType.SPAWNER, false, false);
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)context.positions[i].m_123341_() + 0.5, (double)context.positions[i].m_123342_() + 1.15, (double)context.positions[i].m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            ((ServerLevel)world).m_5594_((Player)null, context.positions[i], SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 1.6f);
            if (noCost) continue;
            SculkHorde.savedData.subtractSculkAccumulatedMass(mob.getCost());
        }
    }

    public void requestReinforcementSculkMass(Level world, BlockPos pos, ReinforcementRequest context) {
        if (SculkHorde.savedData == null) {
            return;
        }
        if (SculkHorde.savedData.getSculkAccumulatedMass() <= 0) {
            return;
        }
        if (entries.size() == 0) {
            return;
        }
        if (context.budget == 0) {
            return;
        }
        SculkHorde.gravemind.processReinforcementRequest(context);
        if (!context.isRequestApproved) {
            return;
        }
        ArrayList<EntityFactoryEntry> lottery = new ArrayList<EntityFactoryEntry>();
        for (EntityFactoryEntry entry : entries) {
            if (!entry.isEntryAppropriate(context)) continue;
            lottery.add(entry);
        }
        if (!lottery.isEmpty()) {
            int randomEntryIndex = rng.nextInt(lottery.size());
            EntityFactoryEntry randomEntry = (EntityFactoryEntry)lottery.get(randomEntryIndex);
            context.remaining_balance = context.budget - randomEntry.getCost();
            randomEntry.getEntity().m_20600_((ServerLevel)world, (CompoundTag)null, (Component)null, (Player)null, pos, MobSpawnType.SPAWNER, false, false);
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.15, (double)pos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            ((ServerLevel)world).m_5594_((Player)null, pos, SoundEvents.f_215740_, SoundSource.BLOCKS, 2.0f, 1.6f);
        }
    }

    public static enum StrategicValues {
        Infector,
        Melee,
        Ranged;

    }
}

