/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.core.gravemind;

import com.github.sculkhorde.common.blockentity.SculkNodeBlockEntity;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.core.gravemind.entity_factory.ReinforcementRequest;
import com.github.sculkhorde.util.TickUnits;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class Gravemind {
    private evolution_states evolution_state = evolution_states.Undeveloped;
    public static EntityFactory entityFactory;
    public static final int MINIMUM_DISTANCE_BETWEEN_NODES = 300;
    public int sculk_node_limit = 1;
    public static int TICKS_BETWEEN_NODE_SPAWNS;

    public Gravemind() {
        entityFactory = SculkHorde.entityFactory;
        this.calulateCurrentState();
    }

    public evolution_states getEvolutionState() {
        return this.evolution_state;
    }

    public void calulateCurrentState() {
        int MASS_GOAL_FOR_IMMATURE = (Integer)ModConfig.SERVER.gravemind_mass_goal_for_immature_stage.get();
        int MASS_GOAL_FOR_MATURE = (Integer)ModConfig.SERVER.gravemind_mass_goal_for_mature_stage.get();
        if (SculkHorde.savedData.getSculkAccumulatedMass() >= MASS_GOAL_FOR_MATURE) {
            this.evolution_state = evolution_states.Mature;
            this.sculk_node_limit = 8;
        } else if (SculkHorde.savedData.getSculkAccumulatedMass() >= MASS_GOAL_FOR_IMMATURE) {
            this.evolution_state = evolution_states.Immature;
            this.sculk_node_limit = 4;
            if (SculkHorde.savedData.isHordeUnactivated()) {
                SculkHorde.savedData.setHordeState(ModSavedData.HordeState.ACTIVE);
            }
        }
    }

    public void advanceState() {
        if (this.evolution_state == evolution_states.Undeveloped) {
            SculkHorde.savedData.setSculkAccumulatedMass((Integer)ModConfig.SERVER.gravemind_mass_goal_for_immature_stage.get());
            this.calulateCurrentState();
        } else if (this.evolution_state == evolution_states.Immature) {
            SculkHorde.savedData.setSculkAccumulatedMass((Integer)ModConfig.SERVER.gravemind_mass_goal_for_mature_stage.get());
            this.calulateCurrentState();
        }
    }

    public void deadvanceState() {
        if (this.evolution_state == evolution_states.Immature) {
            SculkHorde.savedData.setSculkAccumulatedMass((Integer)ModConfig.SERVER.gravemind_mass_goal_for_immature_stage.get() / 2);
        } else if (this.evolution_state == evolution_states.Mature) {
            SculkHorde.savedData.setSculkAccumulatedMass((Integer)ModConfig.SERVER.gravemind_mass_goal_for_mature_stage.get() / 2);
        }
        this.calulateCurrentState();
    }

    public void enableAmountOfBeeHives(int amount) {
        if (SculkHorde.savedData == null) {
            return;
        }
        if (SculkHorde.savedData.getBeeNestEntries().size() <= 0) {
            return;
        }
        int lastEnabledIndex = -1;
        for (int i = 0; i < SculkHorde.savedData.getBeeNestEntries().size(); ++i) {
            ModSavedData.BeeNestEntry entry = SculkHorde.savedData.getBeeNestEntries().get(i);
            if (!entry.isEntryValid() || entry.isOccupantsExistingDisabled()) continue;
            entry.disableOccupantsExiting();
            lastEnabledIndex = i;
        }
        int startIndex = lastEnabledIndex + 1;
        if (startIndex >= SculkHorde.savedData.getBeeNestEntries().size()) {
            startIndex = 0;
        }
        for (int i = startIndex; i < startIndex + amount; ++i) {
            int index = i % SculkHorde.savedData.getBeeNestEntries().size();
            if (!SculkHorde.savedData.getBeeNestEntries().get(index).isEntryValid()) continue;
            SculkHorde.savedData.getBeeNestEntries().get(index).enableOccupantsExiting();
        }
    }

    public void processReinforcementRequest(ReinforcementRequest context) {
        BlockPos nodeBlockPos;
        Optional nodeBlockEntity;
        boolean isThereSculkNodesInExistence;
        context.isRequestViewed = true;
        boolean isSenderDeveloper = context.sender == ReinforcementRequest.senderType.Developer;
        boolean isSenderSculkMassBlock = context.sender == ReinforcementRequest.senderType.SculkMass;
        boolean isThereNoMass = SculkHorde.savedData.getSculkAccumulatedMass() <= 0;
        boolean isHordeDefeated = SculkHorde.savedData.isHordeDefeated();
        if (isSenderDeveloper || isSenderSculkMassBlock) {
            context.isRequestApproved = true;
        }
        if (isHordeDefeated || isThereNoMass) {
            return;
        }
        boolean isSenderTypeSummoner = context.sender == ReinforcementRequest.senderType.SculkCocoon;
        boolean isThereAtLeastOneSpawnPoint = context.positions.length > 0;
        boolean bl = isThereSculkNodesInExistence = SculkHorde.savedData.getNodeEntries().size() > 0;
        if (isSenderTypeSummoner && isThereAtLeastOneSpawnPoint && isThereSculkNodesInExistence && (nodeBlockEntity = SculkHorde.savedData.level.m_141902_(nodeBlockPos = SculkHorde.savedData.getClosestNodeEntry(context.dimension, context.positions[0]).getPosition(), (BlockEntityType)ModBlockEntities.SCULK_NODE_BLOCK_ENTITY.get())).isPresent() && ((SculkNodeBlockEntity)((Object)nodeBlockEntity.get())).isPopulationAtMax()) {
            context.isRequestApproved = false;
            return;
        }
        if (this.evolution_state == evolution_states.Undeveloped) {
            context.isRequestApproved = true;
        } else if (this.evolution_state == evolution_states.Immature || this.evolution_state == evolution_states.Mature) {
            if (context.is_aggressor_nearby) {
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Melee);
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Ranged);
                context.isRequestApproved = true;
            } else if (context.is_non_sculk_mob_nearby) {
                context.approvedMobTypes.add(EntityFactory.StrategicValues.Infector);
                context.isRequestApproved = true;
            }
        }
    }

    public boolean isEvolutionStateEqualOrLessThanCurrent(evolution_states stateIn) {
        if (this.evolution_state == evolution_states.Undeveloped) {
            return stateIn == evolution_states.Undeveloped;
        }
        if (this.evolution_state == evolution_states.Immature) {
            return stateIn == evolution_states.Immature || stateIn == evolution_states.Undeveloped;
        }
        if (this.evolution_state == evolution_states.Mature) {
            return stateIn == evolution_states.Undeveloped || stateIn == evolution_states.Immature || stateIn == evolution_states.Mature;
        }
        return false;
    }

    static {
        TICKS_BETWEEN_NODE_SPAWNS = TickUnits.convertHoursToTicks((Integer)ModConfig.SERVER.sculk_node_spawn_cooldown_hours.get());
    }

    public static enum evolution_states {
        Undeveloped,
        Immature,
        Mature;

    }
}

