/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.structures.procedural;

import com.github.sculkhorde.common.structures.procedural.PlannedBlock;
import com.github.sculkhorde.common.structures.procedural.ProceduralStructure;
import com.github.sculkhorde.common.structures.procedural.SculkNodeCaveHallwayProceduralStructure;
import com.github.sculkhorde.core.ModBlocks;
import com.github.sculkhorde.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SculkNodeCaveProceduralStructure
extends ProceduralStructure {
    private int radius;
    SculkNodeCaveHallwayProceduralStructure westCave;
    SculkNodeCaveHallwayProceduralStructure eastCave;
    SculkNodeCaveHallwayProceduralStructure northCave;
    SculkNodeCaveHallwayProceduralStructure southCave;

    public SculkNodeCaveProceduralStructure(ServerLevel worldIn, BlockPos originIn, int radiusIn) {
        super(worldIn, originIn);
        this.radius = radiusIn;
        this.generatePlan();
    }

    @Override
    public void buildTick() {
        if (this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
            PlannedBlock currentPlannedBlock = (PlannedBlock)this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
            while (currentPlannedBlock.canBePlaced() && currentPlannedBlock.isPlaced() && this.currentPlannedBlockQueueIndex < this.plannedBlockQueue.size()) {
                currentPlannedBlock = (PlannedBlock)this.plannedBlockQueue.get(this.currentPlannedBlockQueueIndex);
                ++this.currentPlannedBlockQueueIndex;
            }
            if (currentPlannedBlock.canBePlaced()) {
                currentPlannedBlock.build();
            }
            ++this.currentPlannedBlockQueueIndex;
        }
        this.westCave.buildTick();
        this.eastCave.buildTick();
        this.northCave.buildTick();
        this.southCave.buildTick();
    }

    @Override
    public void generatePlan() {
        this.plannedBlockQueue.clear();
        ArrayList<BlockPos> blockPositionsInCircle = BlockAlgorithms.getBlockPosInCircle(this.origin, this.radius, false);
        for (BlockPos position : blockPositionsInCircle) {
            this.plannedBlockQueue.add(new CaveAirPlannedBlock(this.world, position));
        }
        ProceduralStructure.ConnectionPoint westConnection = new ProceduralStructure.ConnectionPoint(new BlockPos((Vec3i)this.origin.m_7918_(-this.radius, 0, 0)), Direction.WEST);
        ProceduralStructure.ConnectionPoint eastConnection = new ProceduralStructure.ConnectionPoint(new BlockPos((Vec3i)this.origin.m_7918_(this.radius, 0, 0)), Direction.EAST);
        ProceduralStructure.ConnectionPoint northConnection = new ProceduralStructure.ConnectionPoint(new BlockPos((Vec3i)this.origin.m_7918_(0, 0, -this.radius)), Direction.NORTH);
        ProceduralStructure.ConnectionPoint southConnection = new ProceduralStructure.ConnectionPoint(new BlockPos((Vec3i)this.origin.m_7918_(0, 0, this.radius)), Direction.SOUTH);
        this.westCave = new SculkNodeCaveHallwayProceduralStructure(this.world, westConnection.getPosition(), 5, 32, Direction.WEST);
        this.eastCave = new SculkNodeCaveHallwayProceduralStructure(this.world, eastConnection.getPosition(), 5, 32, Direction.EAST);
        this.northCave = new SculkNodeCaveHallwayProceduralStructure(this.world, northConnection.getPosition(), 5, 32, Direction.NORTH);
        this.southCave = new SculkNodeCaveHallwayProceduralStructure(this.world, southConnection.getPosition(), 5, 32, Direction.SOUTH);
    }

    public class CaveAirPlannedBlock
    extends PlannedBlock {
        protected final Predicate<BlockState> CAN_BLOCK_BE_REPLACED;

        public CaveAirPlannedBlock(ServerLevel worldIn, BlockPos targetPosIn) {
            super(worldIn, Blocks.f_50627_.m_49966_(), targetPosIn);
            this.CAN_BLOCK_BE_REPLACED = validBlocksPredicate -> {
                if (validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_NODE_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_DURA_MATTER.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_ARACHNOID.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_LIVING_ROCK_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_LIVING_ROCK_ROOT_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_BEE_NEST_CELL_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_SUMMONER_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.GRASS.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.GRASS_SHORT.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_BEE_NEST_CELL_BLOCK.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.CALCITE_ORE.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SMALL_SHROOM.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.TENDRILS.get()) || validBlocksPredicate.m_60734_().equals(ModBlocks.SCULK_SHROOM_CULTURE.get())) {
                    return false;
                }
                if (this.world.m_45527_(this.targetPos.m_7494_())) {
                    return false;
                }
                return !(validBlocksPredicate.m_60800_((BlockGetter)this.world, this.targetPos) > 3.0f);
            };
        }

        @Override
        public boolean canBePlaced() {
            return this.CAN_BLOCK_BE_REPLACED.test(this.world.m_8055_(this.targetPos));
        }

        @Override
        public void build() {
            if (this.canBePlaced()) {
                this.world.m_46597_(this.targetPos, this.plannedBlock);
            }
        }
    }
}

