/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.infection;

import com.github.sculkhorde.common.entity.infection.CursorProberEntity;
import com.github.sculkhorde.common.entity.infection.CursorSurfaceInfectorEntity;
import com.github.sculkhorde.core.SculkHorde;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class DevInfectionTree {
    private TreeNode root;
    private boolean Active = false;
    private final Direction direction;
    private CursorProberEntity cursorProbe;
    private CursorSurfaceInfectorEntity cursorInfection;
    private final ServerLevel world;
    private state currentState = state.IDLE;
    private BlockPos potentialNodePosition = null;
    private int failedProbeAttempts = 0;
    private final int MAX_FAILED_PROBE_ATTEMPTS = 2;
    private final int MAX_PROBE_RANGE = 10000;
    private final int MIN_PROBE_RANGE = 1000;
    private int currentProbeRange = 10;
    private final int PROBE_RANGE_INCREMENT = 1000;
    private final int MAX_INFECTOR_RANGE = 10000;
    private final int MIN_INFECTOR_RANGE = 1000;
    private int currentInfectRange = 1000;
    private final int MAX_INFECTOR_RANGE_INCREMENT = 1000;
    private BlockPos infectedTargetPosition = null;
    private int failedInfectionAttempts = 0;
    private final int MAX_FAILED_INFECTION_ATTEMPTS = 10;

    public DevInfectionTree(ServerLevel world, Direction direction, BlockPos rootPos) {
        this.root = new TreeNode(rootPos);
        this.direction = direction;
        this.world = world;
        SculkHorde.LOGGER.info("DevInfectionTree (" + direction + ") | Created.");
    }

    public boolean isActive() {
        return this.Active;
    }

    public void activate() {
        SculkHorde.LOGGER.info("DevInfectionTree (" + this.direction + ") | Activated.");
        this.Active = true;
    }

    public void deactivate() {
        this.Active = false;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    public void createProbeCursor(int maxDistance) {
        this.cursorProbe = new CursorProberEntity((Level)this.world);
        this.cursorProbe.setMaxRange(maxDistance);
        this.cursorProbe.setPreferedDirection(this.direction);
        this.cursorProbe.m_6034_(this.root.blockPos.m_123341_(), this.root.blockPos.m_123342_(), this.root.blockPos.m_123343_());
        this.cursorProbe.setMaxTransformations(1);
        this.world.m_7967_((Entity)this.cursorProbe);
    }

    public void createInfectionCursor(int maxInfections) {
        this.cursorInfection = new CursorSurfaceInfectorEntity((Level)this.world);
        this.cursorInfection.m_6034_(this.infectedTargetPosition.m_123341_(), this.infectedTargetPosition.m_123342_(), this.infectedTargetPosition.m_123343_());
        this.cursorInfection.setMaxRange(maxInfections);
        this.cursorInfection.setTickIntervalMilliseconds(2L);
        this.world.m_7967_((Entity)this.cursorInfection);
    }

    public void tick() {
        if (this.root.blockPos == BlockPos.f_121853_) {
            return;
        }
        if (this.failedProbeAttempts >= 2) {
            this.currentState = state.COMPLETE;
            SculkHorde.LOGGER.info("DevInfectionTree (" + this.direction + ")| Probe Failed Too Many Times. Changing State to Complete.");
        }
        if (this.currentProbeRange > 10000) {
            this.currentProbeRange = 1000;
            SculkHorde.LOGGER.info("Probe Range Too Large. Resetting to Minimum.");
        }
        if (this.currentState == state.IDLE) {
            this.currentState = state.PROBING;
            SculkHorde.LOGGER.info("Changing State to Probing.");
        } else if (this.currentState == state.PROBING) {
            if (this.cursorProbe == null) {
                this.createProbeCursor(this.currentProbeRange);
                SculkHorde.LOGGER.info("Creating Probe Cursor.");
                return;
            }
            if (this.cursorProbe.m_6084_()) {
                return;
            }
            if (this.cursorProbe.currentTransformations > 0) {
                this.potentialNodePosition = this.cursorProbe.m_20183_();
                this.failedProbeAttempts = 0;
                this.cursorProbe = null;
                this.currentState = state.INFECTION;
                SculkHorde.LOGGER.info("Probe Successful. Changing State to Infection.");
            } else {
                this.cursorProbe = null;
                ++this.failedProbeAttempts;
                this.potentialNodePosition = BlockPos.f_121853_;
                SculkHorde.LOGGER.info("Probe Failed. Failed Attempts is now " + this.failedProbeAttempts + ".");
            }
        } else if (this.currentState == state.INFECTION) {
            this.infectedTargetPosition = this.potentialNodePosition;
            if (this.cursorInfection == null) {
                this.createInfectionCursor(this.currentInfectRange);
                SculkHorde.LOGGER.info("Creating Infection Cursor.");
                return;
            }
            if (this.cursorInfection.m_6084_()) {
                return;
            }
            if (this.cursorInfection.currentTransformations > 0) {
                this.failedInfectionAttempts = 0;
                this.cursorInfection = null;
                SculkHorde.LOGGER.info("Infection Successful.");
            } else {
                ++this.failedInfectionAttempts;
                this.cursorInfection = null;
                SculkHorde.LOGGER.info("Infection Failed. Failed Infection Attempts is now " + this.failedInfectionAttempts + ".");
            }
            if (this.failedInfectionAttempts >= 10) {
                this.currentInfectRange += 1000;
                this.failedInfectionAttempts = 0;
                SculkHorde.LOGGER.info("Too Many Failed Infection Attempts. Increasing range to " + this.currentInfectRange + ".");
            }
            if (this.currentInfectRange > 10000) {
                this.failedInfectionAttempts = 0;
                this.currentInfectRange = 1000;
                this.currentState = state.PROBING;
                SculkHorde.LOGGER.info("Infection Range Too Large. Resetting to Minimum.");
            }
        } else if (this.currentState == state.COMPLETE) {
            if (this.failedProbeAttempts >= 2) {
                this.currentProbeRange += 1000;
                this.failedProbeAttempts = 0;
                this.currentState = state.IDLE;
                SculkHorde.LOGGER.info("Too Many Failed Probe Attempts. Increasing range to " + this.currentProbeRange + ".");
            }
            if (this.failedInfectionAttempts >= 10) {
                this.currentState = state.IDLE;
                this.failedInfectionAttempts = 0;
                SculkHorde.LOGGER.info("Too Many Failed Infection Attempts. Resetting.");
            }
        }
    }

    private static enum state {
        IDLE,
        PROBING,
        INFECTION,
        COMPLETE;

    }

    public class TreeNode {
        private BlockPos blockPos;
        private TreeNode left;
        private TreeNode right;

        public TreeNode(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public Object getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public TreeNode getLeft() {
            return this.left;
        }

        public void setLeft(TreeNode left) {
            this.left = left;
        }

        public TreeNode getRight() {
            return this.right;
        }

        public void setRight(TreeNode right) {
            this.right = right;
        }
    }
}

