/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.goal;

import com.github.sculkhorde.common.entity.SculkPhantomEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SculkPhantomWanderGoal
extends Goal {
    public static final int DEFAULT_INTERVAL = 120;
    private static final double MAX_RANDOM_DISTANCE = 10.0;
    private final SculkPhantomEntity mob;
    private final double speedModifier;
    private long intervalTicks;
    private long lastTimeExecuted;
    private Vec3 targetPosition;
    private boolean forceTrigger;
    protected int maxHeightOffGround;

    public SculkPhantomWanderGoal(SculkPhantomEntity mob, double speedModifier, long interval, int maxHeightOffGround) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.intervalTicks = interval;
        this.maxHeightOffGround = maxHeightOffGround;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.mob.m_20160_()) {
            return false;
        }
        if (!this.forceTrigger && this.mob.f_19853_.m_46467_() - this.lastTimeExecuted < this.intervalTicks) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (this.mob.isScouter()) {
            return false;
        }
        this.targetPosition = this.getRandomPosition();
        if (this.targetPosition == null) {
            return false;
        }
        this.forceTrigger = false;
        return true;
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_20160_();
    }

    public void m_8056_() {
        this.lastTimeExecuted = this.mob.f_19853_.m_46467_();
        this.navigateToTarget();
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        super.m_8041_();
    }

    public void m_8037_() {
        if (this.targetPosition != null && !this.mob.m_21573_().m_26571_() && !this.mob.m_20160_()) {
            this.navigateToTarget();
        }
    }

    public void trigger() {
        this.forceTrigger = true;
    }

    private void navigateToTarget() {
        Path path = this.mob.m_21573_().m_7864_(new BlockPos(this.targetPosition), 1);
        if (path != null) {
            this.mob.m_21573_().m_26536_(path, this.speedModifier);
        }
    }

    public static Vec3 getGroundPos(Level level, Vec3 origin) {
        ClipContext context = new ClipContext(origin, origin.m_82520_(0.0, (double)(level.m_151558_() * -1), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null);
        BlockHitResult optional = level.m_45547_(context);
        if (optional.m_6662_() == HitResult.Type.MISS) {
            return origin;
        }
        return optional.m_82450_();
    }

    private Vec3 getRandomPosition() {
        RandomSource random = this.mob.m_217043_();
        double angle = random.m_188500_() * 2.0 * Math.PI;
        double distance = random.m_188500_() * 10.0;
        double dx = Math.cos(angle) * distance;
        double dy = random.m_188500_() * 10.0;
        double dz = Math.sin(angle) * distance;
        Vec3 currentPosition = this.mob.m_20182_();
        Vec3 targetPosition = currentPosition.m_82520_(dx, dy, dz);
        Vec3 groundPosition = SculkPhantomWanderGoal.getGroundPos(this.mob.f_19853_, targetPosition);
        if (groundPosition.m_82554_(currentPosition) > (double)this.maxHeightOffGround) {
            return groundPosition.m_82520_(0.0, (double)this.maxHeightOffGround, 0.0);
        }
        return targetPosition;
    }
}

