/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss.sculk_enderman;

import com.github.sculkhorde.common.entity.boss.sculk_enderman.SculkEndermanEntity;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.gravemind.entity_factory.EntityFactory;
import com.github.sculkhorde.util.BlockAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class SummonCreepersAttackUnits
extends MeleeAttackGoal {
    protected int maxAttackDuration = 0;
    protected int elapsedAttackDuration = 0;
    protected final int executionCooldown;
    protected int ticksElapsed = this.executionCooldown = TickUnits.convertSecondsToTicks(50);
    private Predicate<BlockPos> isValidSpawn = pos -> {
        if (this.f_25540_.f_19853_.m_8055_(pos).m_60795_() || this.f_25540_.f_19853_.m_8055_(pos).m_60819_().m_76170_()) {
            return false;
        }
        if (!this.f_25540_.f_19853_.m_8055_(pos.m_7494_()).m_60767_().m_76336_() || this.f_25540_.f_19853_.m_8055_(pos.m_7494_()).m_60819_().m_76170_()) {
            return false;
        }
        return this.f_25540_.f_19853_.m_8055_(pos.m_7494_().m_7494_()).m_60767_().m_76336_() && !this.f_25540_.f_19853_.m_8055_(pos.m_7494_().m_7494_()).m_60819_().m_76170_();
    };

    public SummonCreepersAttackUnits(PathfinderMob mob, int durationInTicks) {
        super(mob, 0.0, true);
        this.maxAttackDuration = durationInTicks;
    }

    private SculkEndermanEntity getSculkEnderman() {
        return (SculkEndermanEntity)this.f_25540_;
    }

    public boolean m_8036_() {
        ++this.ticksElapsed;
        if (this.getSculkEnderman().isSpecialAttackOnCooldown() || this.f_25540_.m_5448_() == null) {
            return false;
        }
        if (this.ticksElapsed < this.executionCooldown) {
            return false;
        }
        if (this.getSculkEnderman().m_21223_() > 0.5f * this.getSculkEnderman().m_21233_()) {
            return false;
        }
        return this.f_25540_.m_5448_().m_20096_();
    }

    public boolean m_8045_() {
        return this.elapsedAttackDuration < this.maxAttackDuration;
    }

    public void m_8056_() {
        super.m_8056_();
        this.f_25540_.m_21573_().m_26573_();
        this.getSculkEnderman().teleportAwayFromEntity((Entity)this.f_25540_.m_5448_());
        ArrayList<BlockPos> possibleSpawns = BlockAlgorithms.getBlocksInAreaWithBlockPosPredicate((ServerLevel)this.f_25540_.f_19853_, this.f_25540_.m_20183_(), this.isValidSpawn, 5);
        Collections.shuffle(possibleSpawns);
        for (int i = 0; i < 5 && i < possibleSpawns.size(); ++i) {
            BlockPos spawnPos = possibleSpawns.get(i);
            EntityFactory.spawnReinforcementOfThisEntityType((EntityType)ModEntities.SCULK_CREEPER.get(), this.f_25540_.f_19853_, spawnPos.m_7494_());
        }
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.elapsedAttackDuration;
    }

    public void m_8041_() {
        super.m_8041_();
        this.getSculkEnderman().resetSpecialAttackCooldown();
        this.elapsedAttackDuration = 0;
        this.ticksElapsed = 0;
        this.getSculkEnderman().canTeleport = true;
    }
}

