/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity.boss;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public abstract class SpecialEffectEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> SOURCE_ENTITY = SynchedEntityData.m_135353_(SpecialEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public SpecialEffectEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_7334_(Entity entityIn) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
    }

    public static SpecialEffectEntity spawn(Level world, LivingEntity owner, BlockPos pos, EntityType<?> type) {
        SpecialEffectEntity entity = (SpecialEffectEntity)type.m_20600_((ServerLevel)world, null, null, null, pos, MobSpawnType.REINFORCEMENT, false, false);
        assert (entity != null);
        entity.setOwner(owner);
        world.m_7967_((Entity)entity);
        return entity;
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.f_19853_.m_6443_(entityClass, this.m_20191_().m_82377_(r, r, r), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f));
    }

    public <T extends Entity> List<T> getEntitiesNearbyCube(Class<T> entityClass, double r) {
        return this.f_19853_.m_6443_(entityClass, this.m_20191_().m_82377_(r, r, r), e -> e != this);
    }

    public boolean raytraceCheckEntity(Entity entity) {
        Vec3 from = this.m_20182_();
        int numChecks = 3;
        for (int i = 0; i < numChecks; ++i) {
            float increment = entity.m_20206_() / (float)(numChecks + 1);
            Vec3 to = entity.m_20182_().m_82520_(0.0, (double)(increment * (float)(i + 1)), 0.0);
            BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (result.m_6662_() == HitResult.Type.BLOCK) continue;
            return true;
        }
        return false;
    }
}

