/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.goal.CustomMeleeAttackGoal;
import com.github.sculkhorde.common.entity.goal.DespawnAfterTime;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.FocusSquadTarget;
import com.github.sculkhorde.common.entity.goal.FollowSquadLeader;
import com.github.sculkhorde.common.entity.goal.ImprovedRandomStrollGoal;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.SquadHandlingGoal;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.util.SquadHandler;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import java.util.concurrent.TimeUnit;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.constant.DefaultAnimations;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class SculkVindicatorEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 10.0f;
    public static final float ARMOR = 10.0f;
    public static final float ATTACK_DAMAGE = 7.0f;
    public static final float ATTACK_KNOCKBACK = 1.0f;
    public static final float FOLLOW_RANGE = 25.0f;
    public static final float MOVEMENT_SPEED = 0.3f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().enableTargetInfected().enableMustReachTarget();
    private SquadHandler squad = new SquadHandler(this);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isParticipatingInRaid = false;
    private static final RawAnimation JAW_IDLE_ANIMATION = RawAnimation.begin().thenLoop("jaw.idle");
    private static final RawAnimation JAW_RUN_ANIMATION = RawAnimation.begin().thenLoop("jaw.run");
    private static final RawAnimation TUMOR_ANIMATION = RawAnimation.begin().thenLoop("tumor");
    private static final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().thenPlay("jaw.attack");
    private final AnimationController ATTACK_ANIMATION_CONTROLLER = new AnimationController((GeoAnimatable)this, "attack_controller", 5, state2 -> PlayState.STOP).triggerableAnim("attack_animation", ATTACK_ANIMATION);

    public SculkVindicatorEntity(EntityType<? extends SculkVindicatorEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public void m_6043_() {
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    @Override
    public SquadHandler getSquad() {
        return this.squad;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new DespawnAfterTime(this, TickUnits.convertMinutesToTicks(15)), new DespawnWhenIdle(this, TimeUnit.MINUTES.toSeconds(2L)), new OpenDoorGoal((Mob)this, true), new FloatGoal((Mob)this), new SquadHandlingGoal(this), new SculkVindicatorAttackGoal(), new FollowSquadLeader(this), new PathFindToRaidLocation<SculkVindicatorEntity>(this), new MoveTowardsTargetGoal((PathfinderMob)this, (double)0.8f, 20.0f), new ImprovedRandomStrollGoal((PathfinderMob)this, 1.0).setToAvoidWater(true)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((Mob)this, new Class[0]), new FocusSquadTarget((Mob)this), new NearestLivingEntityTargetGoal((Mob)this, true, true)};
        return goals;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)this), this.ATTACK_ANIMATION_CONTROLLER, new AnimationController((GeoAnimatable)this, "Legs", 5, this::poseJawCycle), new AnimationController((GeoAnimatable)this, "Tumor", 5, this::poseTumorCycle)});
    }

    protected PlayState poseJawCycle(AnimationState<SculkVindicatorEntity> state2) {
        if (!state2.isMoving()) {
            state2.setAnimation(JAW_IDLE_ANIMATION);
        } else {
            state2.setAnimation(JAW_RUN_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    protected PlayState poseTumorCycle(AnimationState<SculkVindicatorEntity> state2) {
        state2.setAnimation(TUMOR_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12310_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11875_, 0.15f, 1.0f);
    }

    public boolean m_213854_() {
        return true;
    }

    public class SculkVindicatorAttackGoal
    extends CustomMeleeAttackGoal {
        public SculkVindicatorAttackGoal() {
            super((PathfinderMob)SculkVindicatorEntity.this, 1.0, false, 10);
        }

        @Override
        protected double getAttackReachSqr(LivingEntity pAttackTarget) {
            return 3.5;
        }

        @Override
        protected int getAttackInterval() {
            return TickUnits.convertSecondsToTicks(2);
        }

        @Override
        protected void triggerAnimation() {
            ((SculkVindicatorEntity)this.mob).triggerAnim("attack_controller", "attack_animation");
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            SculkVindicatorEntity.this.m_6858_(true);
        }

        @Override
        public void m_8041_() {
            super.m_8056_();
            SculkVindicatorEntity.this.m_6858_(false);
        }
    }
}

