/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.ISculkSmartEntity;
import com.github.sculkhorde.common.entity.attack.AcidAttack;
import com.github.sculkhorde.common.entity.goal.DespawnAfterTime;
import com.github.sculkhorde.common.entity.goal.DespawnWhenIdle;
import com.github.sculkhorde.common.entity.goal.FocusSquadTarget;
import com.github.sculkhorde.common.entity.goal.FollowSquadLeader;
import com.github.sculkhorde.common.entity.goal.ImprovedRandomStrollGoal;
import com.github.sculkhorde.common.entity.goal.InvalidateTargetGoal;
import com.github.sculkhorde.common.entity.goal.MountNearestRavager;
import com.github.sculkhorde.common.entity.goal.NearestLivingEntityTargetGoal;
import com.github.sculkhorde.common.entity.goal.PathFindToRaidLocation;
import com.github.sculkhorde.common.entity.goal.RangedAttackGoal;
import com.github.sculkhorde.common.entity.goal.SquadHandlingGoal;
import com.github.sculkhorde.common.entity.goal.TargetAttacker;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.util.SquadHandler;
import com.github.sculkhorde.util.TargetParameters;
import com.github.sculkhorde.util.TickUnits;
import java.util.concurrent.TimeUnit;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.constant.DefaultAnimations;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class SculkSpitterEntity
extends Monster
implements GeoEntity,
ISculkSmartEntity {
    public static final float MAX_HEALTH = 20.0f;
    public static final float ARMOR = 4.0f;
    public static final float ATTACK_DAMAGE = 5.0f;
    public static final float ATTACK_KNOCKBACK = 2.0f;
    public static final float FOLLOW_RANGE = 40.0f;
    public static final float MOVEMENT_SPEED = 0.3f;
    private TargetParameters TARGET_PARAMETERS = new TargetParameters((Mob)this).enableTargetHostiles().enableTargetInfected();
    private static final EntityDataAccessor<Boolean> IS_STRAFING = SynchedEntityData.m_135353_(SculkSpitterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isParticipatingInRaid = false;
    private SquadHandler squad = new SquadHandler(this);
    private static final RawAnimation STRAFE_ANIMATION = RawAnimation.begin().thenPlay("move.strafe");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("move.walk");
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenPlay("misc.idle");
    private static final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().thenPlay("attack");
    private final AnimationController ATTACK_ANIMATION_CONTROLLER = new AnimationController((GeoAnimatable)this, "attack_controller", state2 -> PlayState.STOP).triggerableAnim("attack_animation", ATTACK_ANIMATION);

    public SculkSpitterEntity(EntityType<? extends SculkSpitterEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    public SculkSpitterEntity(Level worldIn) {
        super((EntityType)ModEntities.SCULK_SPITTER.get(), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public void m_6043_() {
    }

    @Override
    public boolean isIdle() {
        return this.m_5448_() == null;
    }

    @Override
    public SquadHandler getSquad() {
        return this.squad;
    }

    @Override
    public boolean isParticipatingInRaid() {
        return this.isParticipatingInRaid;
    }

    @Override
    public void setParticipatingInRaid(boolean isParticipatingInRaidIn) {
        this.isParticipatingInRaid = isParticipatingInRaidIn;
    }

    @Override
    public TargetParameters getTargetParameters() {
        return this.TARGET_PARAMETERS;
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{new DespawnAfterTime(this, TickUnits.convertMinutesToTicks(15)), new DespawnWhenIdle(this, TimeUnit.MINUTES.toSeconds(2L)), new FloatGoal((Mob)this), new SquadHandlingGoal(this), new MountNearestRavager((Mob)this), new RangedAttackGoal((Mob)this, new AcidAttack(this).setProjectileOriginOffset(0.8, 0.9, 0.8).setDamage(5.0f), 1.0, 40, 30, 15, 15.0f, 1), new FollowSquadLeader(this), new PathFindToRaidLocation<SculkSpitterEntity>(this), new ImprovedRandomStrollGoal((PathfinderMob)this, 1.0).setToAvoidWater(true), new LookAtPlayerGoal((Mob)this, Pig.class, 8.0f), new RandomLookAroundGoal((Mob)this), new OpenDoorGoal((Mob)this, true)};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{new InvalidateTargetGoal(this), new TargetAttacker((Mob)this, new Class[0]), new FocusSquadTarget((Mob)this), new NearestLivingEntityTargetGoal((Mob)this, true, true)};
        return goals;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_STRAFING, (Object)false);
    }

    public boolean isStrafing() {
        return (Boolean)this.f_19804_.m_135370_(IS_STRAFING);
    }

    public void setStrafing(boolean value) {
        this.f_19804_.m_135381_(IS_STRAFING, (Object)value);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walk_cycle", 5, this::poseWalkCycle), DefaultAnimations.genericLivingController((GeoAnimatable)this), this.ATTACK_ANIMATION_CONTROLLER});
    }

    protected PlayState poseWalkCycle(AnimationState<SculkSpitterEntity> state2) {
        if (state2.isMoving()) {
            state2.setAnimation(WALK_ANIMATION);
        } else {
            state2.setAnimation(IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12383_, 0.15f, 1.0f);
    }

    public boolean m_213854_() {
        return true;
    }
}

