/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.entity;

import com.github.sculkhorde.common.entity.infection.CursorSurfacePurifierEntity;
import com.github.sculkhorde.core.ModConfig;
import com.github.sculkhorde.core.ModEntities;
import com.github.sculkhorde.core.ModItems;
import com.github.sculkhorde.util.EntityAlgorithms;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.constant.DefaultAnimations;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class InfestationPurifierEntity
extends PathfinderMob
implements GeoEntity {
    public static final float MAX_HEALTH = 200.0f;
    public static final float ARMOR = 10.0f;
    public static final float ATTACK_DAMAGE = 0.0f;
    public static final float ATTACK_KNOCKBACK = 0.0f;
    public static final float FOLLOW_RANGE = 0.0f;
    public static final float MOVEMENT_SPEED = 0.0f;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private int MAX_TARGET_FIND_FAILS = 32;
    private int targetFindFails = 0;
    CursorSurfacePurifierEntity cursor1;
    CursorSurfacePurifierEntity cursor2;
    CursorSurfacePurifierEntity cursor3;
    CursorSurfacePurifierEntity cursor4;

    public InfestationPurifierEntity(EntityType<? extends InfestationPurifierEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public InfestationPurifierEntity(Level worldIn) {
        super((EntityType)ModEntities.INFESTATION_PURIFIER.get(), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8099_() {
        Goal[] goalSelectorPayload = this.goalSelectorPayload();
        for (int priority = 0; priority < goalSelectorPayload.length; ++priority) {
            this.f_21345_.m_25352_(priority, goalSelectorPayload[priority]);
        }
        Goal[] targetSelectorPayload = this.targetSelectorPayload();
        for (int priority = 0; priority < targetSelectorPayload.length; ++priority) {
            this.f_21346_.m_25352_(priority, targetSelectorPayload[priority]);
        }
    }

    public Goal[] goalSelectorPayload() {
        Goal[] goals = new Goal[]{};
        return goals;
    }

    public Goal[] targetSelectorPayload() {
        Goal[] goals = new Goal[]{};
        return goals;
    }

    public void m_6043_() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericLivingController((GeoAnimatable)this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8107_() {
        Random random;
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.targetFindFails >= this.MAX_TARGET_FIND_FAILS) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.m_19983_(new ItemStack((ItemLike)ModItems.INFESTATION_PURIFIER.get()));
        }
        if ((random = new Random()).nextInt(100) == 0) {
            if (this.cursor1 != null && !this.cursor1.m_6084_() && !this.cursor1.isSuccessful) {
                ++this.targetFindFails;
            } else if (this.cursor1 != null && !this.cursor1.m_6084_() && this.cursor1.isSuccessful) {
                this.targetFindFails = 0;
            }
            if (this.cursor2 != null && !this.cursor2.m_6084_() && !this.cursor2.isSuccessful) {
                ++this.targetFindFails;
            } else if (this.cursor2 != null && !this.cursor2.m_6084_() && this.cursor2.isSuccessful) {
                this.targetFindFails = 0;
            }
            if (this.cursor3 != null && !this.cursor3.m_6084_() && !this.cursor3.isSuccessful) {
                ++this.targetFindFails;
            } else if (this.cursor3 != null && !this.cursor3.m_6084_() && this.cursor3.isSuccessful) {
                this.targetFindFails = 0;
            }
            if (this.cursor4 != null && !this.cursor4.m_6084_() && !this.cursor4.isSuccessful) {
                ++this.targetFindFails;
            } else if (this.cursor4 != null && !this.cursor4.m_6084_() && this.cursor4.isSuccessful) {
                this.targetFindFails = 0;
            }
            if (this.cursor1 == null || !this.cursor1.m_6084_()) {
                this.cursor1 = new CursorSurfacePurifierEntity(this.f_19853_);
                this.cursor1.m_6034_(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - 1, this.m_20183_().m_123343_());
                this.cursor1.setMaxTransformations(100);
                this.cursor1.setMaxRange((Integer)ModConfig.SERVER.infestation_purifier_range.get());
                this.cursor1.setSearchIterationsPerTick(2);
                this.cursor1.setMaxLifeTimeMillis(TimeUnit.MINUTES.toMillis(10L));
                this.cursor1.setTickIntervalMilliseconds(20L);
                this.f_19853_.m_7967_((Entity)this.cursor1);
            }
            if (this.cursor2 == null || !this.cursor2.m_6084_()) {
                this.cursor2 = new CursorSurfacePurifierEntity(this.f_19853_);
                this.cursor2.m_6034_(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - 1, this.m_20183_().m_123343_());
                this.cursor2.setMaxTransformations(100);
                this.cursor2.setMaxRange((Integer)ModConfig.SERVER.infestation_purifier_range.get());
                this.cursor2.setSearchIterationsPerTick(2);
                this.cursor2.setMaxLifeTimeMillis(TimeUnit.MINUTES.toMillis(10L));
                this.cursor2.setTickIntervalMilliseconds(20L);
                this.f_19853_.m_7967_((Entity)this.cursor2);
            }
            if (this.cursor3 == null || !this.cursor3.m_6084_()) {
                this.cursor3 = new CursorSurfacePurifierEntity(this.f_19853_);
                this.cursor3.m_6034_(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - 1, this.m_20183_().m_123343_());
                this.cursor3.setMaxTransformations(100);
                this.cursor3.setMaxRange((Integer)ModConfig.SERVER.infestation_purifier_range.get());
                this.cursor3.setSearchIterationsPerTick(2);
                this.cursor3.setMaxLifeTimeMillis(TimeUnit.MINUTES.toMillis(10L));
                this.cursor3.setTickIntervalMilliseconds(20L);
                this.f_19853_.m_7967_((Entity)this.cursor3);
            }
            if (this.cursor4 == null || !this.cursor4.m_6084_()) {
                this.cursor4 = new CursorSurfacePurifierEntity(this.f_19853_);
                this.cursor4.m_6034_(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - 1, this.m_20183_().m_123343_());
                this.cursor4.setMaxTransformations(100);
                this.cursor4.setMaxRange((Integer)ModConfig.SERVER.infestation_purifier_range.get());
                this.cursor4.setSearchIterationsPerTick(2);
                this.cursor4.setMaxLifeTimeMillis(TimeUnit.MINUTES.toMillis(10L));
                this.cursor4.setTickIntervalMilliseconds(20L);
                this.f_19853_.m_7967_((Entity)this.cursor4);
            }
            ArrayList entities = (ArrayList)EntityAlgorithms.getLivingEntitiesInBoundingBox((ServerLevel)this.f_19853_, this.m_20191_().m_82400_(10.0));
            for (LivingEntity entity : entities) {
                if (!(entity instanceof LivingEntity) || !EntityAlgorithms.isSculkLivingEntity.test(entity)) continue;
                entity.m_20254_(60);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 3));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 3));
            }
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.m_19983_(new ItemStack((ItemLike)ModItems.INFESTATION_PURIFIER.get()));
        }
        return InteractionResult.SUCCESS;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11737_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11823_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11824_;
    }
}

