/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.effect;

import com.github.sculkhorde.core.ModMobEffects;
import com.github.sculkhorde.core.SculkHorde;
import com.github.sculkhorde.util.EntityAlgorithms;
import com.github.sculkhorde.util.TickUnits;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class DiseasedCystsEffect
extends MobEffect {
    public static int liquidColor = 338997;
    public static MobEffectCategory effectType = MobEffectCategory.HARMFUL;
    public long COOLDOWN;
    public long cooldownTicksRemaining;
    private Random random;
    private int randomApplyEffectOffset;

    protected DiseasedCystsEffect(MobEffectCategory effectType, int liquidColor) {
        super(effectType, liquidColor);
        this.cooldownTicksRemaining = this.COOLDOWN = (long)TickUnits.convertSecondsToTicks(5);
        this.random = new Random();
    }

    public DiseasedCystsEffect() {
        this(effectType, liquidColor);
        this.randomApplyEffectOffset = this.random.nextInt(TickUnits.convertSecondsToTicks(2));
    }

    public void m_6742_(LivingEntity sourceEntity, int amp) {
        if (sourceEntity.f_19853_.m_5776_()) {
            return;
        }
        AABB boundingBox = sourceEntity.m_20191_();
        List entities = sourceEntity.f_19853_.m_45976_(LivingEntity.class, boundingBox = boundingBox.m_82377_(10.0, 10.0, 10.0));
        if (!entities.isEmpty()) {
            for (LivingEntity victim : entities) {
                if (EntityAlgorithms.isLivingEntityExplicitDenyTarget(victim)) continue;
                EntityAlgorithms.reducePurityEffectDuration(victim, TickUnits.convertSecondsToTicks(60));
                EntityAlgorithms.applyDebuffEffect(victim, (MobEffect)ModMobEffects.SCULK_INFECTION.get(), TickUnits.convertSecondsToTicks(10), 0);
                if ((double)victim.m_21223_() <= (double)victim.m_21233_() * 0.4) continue;
                victim.f_19864_ = true;
                int damage = (int)(victim.m_21233_() * 0.1f);
                victim.m_6469_(DamageSource.f_19318_, (float)damage);
                SculkHorde.savedData.addSculkAccumulatedMass(damage);
                SculkHorde.statisticsData.addTotalMassFromDiseasedCysts(damage);
            }
        }
    }

    public boolean m_6584_(int ticksLeft, int amplifier) {
        if (this.cooldownTicksRemaining > 0L) {
            --this.cooldownTicksRemaining;
            return false;
        }
        this.cooldownTicksRemaining = this.COOLDOWN + (long)this.randomApplyEffectOffset;
        return true;
    }

    public List<ItemStack> getCurativeItems() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        return ret;
    }
}

