/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.command;

import com.github.sculkhorde.core.ModConfig;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class ConfigCommand
implements Command<CommandSourceStack> {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"config").then(ConfigCommand.gravemindConfig(dispatcher))).then(ConfigCommand.generalConfig(dispatcher))).then(ConfigCommand.triggerAutomaticallyConfig(dispatcher))).then(ConfigCommand.sculkRaidConfig(dispatcher))).then(ConfigCommand.infestationAndPurificationConfig(dispatcher))).then(ConfigCommand.sculkMiteConfig(dispatcher))).then(ConfigCommand.modCompatibilityConfig(dispatcher))).then(ConfigCommand.sculkNodeConfig(dispatcher))).then(ConfigCommand.experimentalFeaturesConfig(dispatcher));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> integerConfigOption(String configKey, int min, int max) {
        if (min > max) {
            return Commands.m_82127_((String)configKey).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ConfigCommand.setConfigValue((CommandContext<CommandSourceStack>)context, "Invalid Argument")));
        }
        return Commands.m_82127_((String)configKey).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ConfigCommand.setConfigValue((CommandContext<CommandSourceStack>)context, configKey)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> doubleConfigOption(String configKey, double min, double max) {
        if (min > max) {
            return Commands.m_82127_((String)configKey).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)-10.0)).executes(context -> ConfigCommand.setConfigValue((CommandContext<CommandSourceStack>)context, "Invalid Argument")));
        }
        return Commands.m_82127_((String)configKey).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)-10.0)).executes(context -> ConfigCommand.setConfigValue((CommandContext<CommandSourceStack>)context, configKey)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> booleanConfigOption(String configKey) {
        return Commands.m_82127_((String)configKey).then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> ConfigCommand.setConfigValue((CommandContext<CommandSourceStack>)context, configKey)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> gravemindConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"gravemind").then(ConfigCommand.integerConfigOption("gravemind_mass_goal_for_mature_stage", 0, Integer.MAX_VALUE))).then(ConfigCommand.integerConfigOption("gravemind_mass_goal_for_immature_stage", 0, Integer.MAX_VALUE));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> generalConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"general").then(ConfigCommand.booleanConfigOption("chunk_loading_enabled"))).then(ConfigCommand.booleanConfigOption("block_infestation_enabled"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> sculkRaidConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sculk_raid").then(ConfigCommand.booleanConfigOption("sculk_raid_enabled"))).then(ConfigCommand.integerConfigOption("sculk_raid_enderman_scouting_duration_minutes", 0, Integer.MAX_VALUE))).then(ConfigCommand.integerConfigOption("sculk_raid_global_cooldown_between_raids_minutes", 0, Integer.MAX_VALUE))).then(ConfigCommand.integerConfigOption("sculk_raid_no_raid_zone_duration_minutes", 0, Integer.MAX_VALUE));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> infestationAndPurificationConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"infestation_and_purification").then(ConfigCommand.doubleConfigOption("infestation_speed_multiplier", -10.0, 10.0))).then(ConfigCommand.doubleConfigOption("purification_speed_multiplier", -10.0, 10.0))).then(ConfigCommand.integerConfigOption("purifier_range", 0, 100));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> sculkMiteConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.m_82127_((String)"sculk_mite").then(ConfigCommand.booleanConfigOption("should_sculk_mites_spawn_in_deep_dark"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> modCompatibilityConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"mod_compatibility").then(ConfigCommand.booleanConfigOption("target_spore_entities"))).then(ConfigCommand.booleanConfigOption("target_faw_entities"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> sculkNodeConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"sculk_node").then(ConfigCommand.integerConfigOption("sculk_node_spawn_cooldown_hours", 1, Integer.MAX_VALUE))).then(ConfigCommand.integerConfigOption("sculk_node_chunkload_radius", 0, 15));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> experimentalFeaturesConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.m_82127_((String)"experimental_features").then(ConfigCommand.booleanConfigOption("experimental_features_enabled"));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> triggerAutomaticallyConfig(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trigger_automatically").then(ConfigCommand.booleanConfigOption("trigger_ancient_node_automatically"))).then(ConfigCommand.integerConfigOption("trigger_ancient_node_wait_days", 0, Integer.MAX_VALUE))).then(ConfigCommand.integerConfigOption("trigger_ancient_node_time_of_day", 0, 24000));
    }

    private static int setConfigValue(CommandContext<CommandSourceStack> context, String configKey) {
        Object rawValue;
        boolean success = false;
        if (context.getArgument("value", Object.class) != null) {
            rawValue = context.getArgument("value", Object.class);
            Class<?> valueType = rawValue.getClass();
            switch (configKey) {
                case "gravemind_mass_goal_for_mature_stage": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.gravemind_mass_goal_for_mature_stage.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "gravemind_mass_goal_for_immature_stage": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.gravemind_mass_goal_for_immature_stage.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "sculk_raid_enabled": {
                    if (!valueType.equals(Boolean.class)) break;
                    ModConfig.SERVER.sculk_raid_enabled.set((Object)((Boolean)rawValue));
                    success = true;
                    break;
                }
                case "sculk_raid_enderman_scouting_duration_minutes": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.sculk_raid_enderman_scouting_duration_minutes.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "sculk_raid_global_cooldown_between_raids_minutes": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.sculk_raid_global_cooldown_between_raids_minutes.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "sculk_raid_no_raid_zone_duration_minutes": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.sculk_raid_no_raid_zone_duration_minutes.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "chunk_loading_enabled": {
                    if (!valueType.equals(Boolean.class)) break;
                    ModConfig.SERVER.chunk_loading_enabled.set((Object)((Boolean)rawValue));
                    success = true;
                    break;
                }
                case "block_infestation_enabled": {
                    if (!valueType.equals(Boolean.class)) break;
                    ModConfig.SERVER.block_infestation_enabled.set((Object)((Boolean)rawValue));
                    success = true;
                    break;
                }
                case "infestation_speed_multiplier": {
                    if (!valueType.equals(Double.class)) break;
                    ModConfig.SERVER.infestation_speed_multiplier.set((Object)((Double)rawValue));
                    success = true;
                    break;
                }
                case "purification_speed_multiplier": {
                    if (!valueType.equals(Double.class)) break;
                    ModConfig.SERVER.purification_speed_multiplier.set((Object)((Double)rawValue));
                    success = true;
                    break;
                }
                case "purifier_range": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.infestation_purifier_range.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "should_sculk_mites_spawn_in_deep_dark": {
                    if (!valueType.equals(Boolean.class)) break;
                    ModConfig.SERVER.should_sculk_mites_spawn_in_deep_dark.set((Object)((Boolean)rawValue));
                    success = true;
                    break;
                }
                case "target_spore_entities": {
                    if (!valueType.equals(Boolean.class)) break;
                    ModConfig.SERVER.target_spore_entities.set((Object)((Boolean)rawValue));
                    success = true;
                    break;
                }
                case "target_faw_entities": {
                    if (!valueType.equals(Boolean.class)) break;
                    ModConfig.SERVER.target_faw_entities.set((Object)((Boolean)rawValue));
                    success = true;
                    break;
                }
                case "sculk_node_spawn_cooldown_hours": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.sculk_node_spawn_cooldown_hours.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "sculk_node_chunkload_radius": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.sculk_node_chunkload_radius.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "experimental_features_enabled": {
                    if (!valueType.equals(Boolean.class)) break;
                    ModConfig.SERVER.experimental_features_enabled.set((Object)((Boolean)rawValue));
                    success = true;
                    break;
                }
                case "trigger_ancient_node_automatically": {
                    if (!valueType.equals(Boolean.class)) break;
                    ModConfig.SERVER.trigger_ancient_node_automatically.set((Object)((Boolean)rawValue));
                    success = true;
                    break;
                }
                case "trigger_ancient_node_wait_days": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.trigger_ancient_node_wait_days.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "trigger_ancient_node_time_of_day": {
                    if (!valueType.equals(Integer.class)) break;
                    ModConfig.SERVER.trigger_ancient_node_time_of_day.set((Object)((Integer)rawValue));
                    success = true;
                    break;
                }
                case "Invalid Argument": {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Invalid Arguments"));
                }
            }
        } else {
            rawValue = null;
        }
        if (success) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Config option updated successfully. " + configKey + " is now: " + rawValue)), false);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to update config option. Check your input."));
        }
        return success ? 1 : 0;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return 0;
    }
}

