/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.blockentity;

import com.github.sculkhorde.common.structures.procedural.SculkLivingRockProceduralStructure;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.util.TickUnits;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SculkLivingRockRootBlockEntity
extends BlockEntity {
    private long tickedAt = 0L;
    private SculkLivingRockProceduralStructure proceduralStructure;
    private final long repairIntervalTicks = TickUnits.convertMinutesToTicks(15);
    private long ticksSinceLastRepair = -1L;

    public SculkLivingRockRootBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SCULK_LIVING_ROCK_ROOT_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SculkLivingRockRootBlockEntity blockEntity) {
        long ticksElapsedSinceLastTick = level.m_46467_() - blockEntity.tickedAt;
        if (ticksElapsedSinceLastTick < (long)TickUnits.convertSecondsToTicks(1)) {
            return;
        }
        blockEntity.tickedAt = level.m_46467_();
        long ticksElapsedSinceLastRepair = level.m_46467_() - blockEntity.ticksSinceLastRepair;
        if (blockEntity.proceduralStructure == null) {
            blockEntity.proceduralStructure = new SculkLivingRockProceduralStructure((ServerLevel)level, blockPos);
            blockEntity.proceduralStructure.generatePlan();
        }
        if (blockEntity.proceduralStructure.isCurrentlyBuilding()) {
            blockEntity.proceduralStructure.buildTick();
            blockEntity.ticksSinceLastRepair = level.m_46467_();
        } else if (ticksElapsedSinceLastRepair >= blockEntity.repairIntervalTicks || blockEntity.ticksSinceLastRepair == -1L) {
            blockEntity.proceduralStructure.startBuildProcedure();
        }
    }
}

