/*
 * Decompiled with CFR 0.152.
 */
package com.github.sculkhorde.common.block;

import com.github.sculkhorde.common.blockentity.SculkAncientNodeBlockEntity;
import com.github.sculkhorde.core.ModBlockEntities;
import com.github.sculkhorde.core.ModItems;
import com.github.sculkhorde.core.ModSavedData;
import com.github.sculkhorde.core.SculkHorde;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public class SculkAncientNodeBlock
extends BaseEntityBlock
implements IForgeBlock {
    public static float HARDNESS = -1.0f;
    public static float BLAST_RESISTANCE = 3600000.0f;
    public static final IntegerProperty STATE = IntegerProperty.m_61631_((String)"state", (int)0, (int)2);
    public static final int STATE_RECIEVE_VIBRATION = 0;
    public static final int STATE_ACTIVE = 1;
    public static final int STATE_DEFEATED = 2;

    public SculkAncientNodeBlock(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STATE, (Comparable)Integer.valueOf(0)));
    }

    public SculkAncientNodeBlock() {
        this(SculkAncientNodeBlock.getProperties());
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        boolean ItemIsPureSouls = playerIn.m_21205_().m_150930_((Item)ModItems.PURE_SOULS.get());
        boolean ItemIsCryingSouls = playerIn.m_21205_().m_150930_((Item)ModItems.CRYING_SOULS.get());
        if (ItemIsPureSouls && !SculkHorde.savedData.isHordeDefeated()) {
            if (!this.areAllNodesDestroyed()) {
                playerIn.m_5661_((Component)Component.m_237113_((String)"The Ancient Sculk Node cannot be destroyed until all remaining Sculk Nodes are!"), true);
                level.m_5594_(playerIn, pos, SoundEvents.f_11738_, SoundSource.MASTER, 1.0f, 1.0f);
                return InteractionResult.FAIL;
            }
            SculkHorde.savedData.setHordeState(ModSavedData.HordeState.DEFEATED);
            level.m_6907_().forEach(player -> player.m_5661_((Component)Component.m_237113_((String)"The Ancient Sculk Node has been Defeated!"), true));
            level.m_6907_().forEach(player -> level.m_5594_(null, player.m_20183_(), SoundEvents.f_11891_, SoundSource.HOSTILE, 1.0f, 1.0f));
            level.m_46511_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0f, Explosion.BlockInteraction.NONE);
            return InteractionResult.CONSUME;
        }
        if (ItemIsCryingSouls && !SculkHorde.savedData.isHordeActive()) {
            SculkHorde.savedData.setHordeState(ModSavedData.HordeState.ACTIVE);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public boolean areAllNodesDestroyed() {
        if (SculkHorde.savedData == null) {
            return true;
        }
        return SculkHorde.savedData.getNodeEntries().isEmpty();
    }

    public boolean m_6724_(BlockState blockState) {
        return false;
    }

    public static BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155949_(MaterialColor.f_76361_).m_60913_(HARDNESS, BLAST_RESISTANCE).m_60918_(SoundType.f_56740_);
        return prop;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)STATE, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{STATE});
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BaseEntityBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.SCULK_ANCIENT_NODE_BLOCK_ENTITY.get()), SculkAncientNodeBlockEntity::tick);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel level, T blockEntityListener) {
        if (blockEntityListener instanceof SculkAncientNodeBlockEntity) {
            SculkAncientNodeBlockEntity blockEntity = (SculkAncientNodeBlockEntity)blockEntityListener;
            return blockEntity.getListener();
        }
        return null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state2) {
        return new SculkAncientNodeBlockEntity(blockPos, state2);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

