/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientPresets;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import com.onewhohears.onewholibs.item.ObjModelItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ItemVehicle
extends Item
implements ObjModelItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final String defaultPreset;

    public ItemVehicle(String defaultPreset) {
        super(new Item.Properties().m_41491_(ModItems.VEHICLES).m_41487_(1));
        this.defaultPreset = defaultPreset;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult hitresult = ItemVehicle.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vec3 = player.m_20252_(1.0f);
        List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec31)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            String presetName = this.getPresetName(itemstack);
            VehicleStats vs = (VehicleStats)VehiclePresets.get().get(presetName);
            if (vs == null) {
                vs = (VehicleStats)VehiclePresets.get().get(this.defaultPreset);
            }
            EntityType<? extends EntityVehicle> entityType = vs.getEntityType();
            ItemStack spawn_data_stack = this.spawnData(itemstack, player, vs.getId());
            EntityVehicle e = (EntityVehicle)entityType.m_20615_(level);
            Vec3 pos = hitresult.m_82450_();
            if (e.isCustomBoundingBox()) {
                e.m_146884_(pos.m_82520_(0.0, (double)e.m_20206_() / 2.0, 0.0));
            } else {
                e.m_146884_(pos);
            }
            if (!level.m_45756_((Entity)e, e.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!level.f_46443_) {
                Entity entity;
                int above = 0;
                if (e.isCustomBoundingBox()) {
                    above = (int)((double)e.m_20206_() / 2.0) + 1;
                }
                if ((entity = entityType.m_20592_((ServerLevel)level, spawn_data_stack, player, new BlockPos(pos).m_6630_(above), MobSpawnType.SPAWN_EGG, false, false)) != null) {
                    level.m_220400_((Entity)player, GameEvent.f_157810_, pos);
                    itemstack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    private ItemStack spawnData(ItemStack itemstack, Player player, String preset) {
        CompoundTag display;
        CompoundTag et;
        ItemStack copy = itemstack.m_41777_();
        CompoundTag tag = copy.m_41784_();
        if (!tag.m_128425_("EntityTag", 10)) {
            et = new CompoundTag();
            et.m_128379_("merged_preset", false);
            et.m_128362_("owner_id", player.m_20148_());
            tag.m_128365_("EntityTag", (Tag)et);
        }
        et = tag.m_128469_("EntityTag");
        et.m_128359_("preset", preset);
        et.m_128350_("yRot", player.m_146908_());
        et.m_128350_("current_throttle", 0.0f);
        et.m_128379_("landing_gear", true);
        if (tag.m_128425_("display", 10) && (display = tag.m_128469_("display")).m_128425_("Name", 8)) {
            et.m_128359_("CustomName", display.m_128461_("Name"));
            et.m_128379_("CustomNameVisible", true);
        }
        return copy;
    }

    public String getPresetName(ItemStack itemstack) {
        CompoundTag eTag;
        CompoundTag tag = itemstack.m_41783_();
        if (tag == null) {
            return this.defaultPreset;
        }
        if (tag.m_128441_("preset")) {
            return tag.m_128461_("preset");
        }
        if (tag.m_128441_("EntityTag") && (eTag = tag.m_128469_("EntityTag")).m_128441_("preset")) {
            return eTag.m_128461_("preset");
        }
        return this.defaultPreset;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tips, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tips, isAdvanced);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("EntityTag")) {
            CompoundTag et = tag.m_128469_("EntityTag");
            if (et.m_128441_("health")) {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.health").m_130946_(": " + (int)et.m_128457_("health")).m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
            }
            if (et.m_128441_("fuel")) {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.fuel").m_130946_(": " + (int)et.m_128457_("fuel")).m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
            }
            if (et.m_128441_("flares")) {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.flares").m_130946_(": " + (int)et.m_128457_("flares")).m_6270_(Style.f_131099_.m_178520_(0xAAAAAA)));
            }
        }
        if (isAdvanced.m_7050_()) {
            tips.add(ItemVehicle.formatTooltip("VehicleId", this.getPreset(stack)));
        }
    }

    public static Component formatTooltip(String key, String value) {
        return Component.m_237113_((String)String.format("%s: \"%s\"", key, value)).m_130940_(ChatFormatting.DARK_GRAY);
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        String owner;
        CompoundTag tag = stack.m_41783_();
        String presetId = this.getPresetName(stack);
        VehicleStats vs = (VehicleStats)VehiclePresets.get().get(presetId);
        if (tag == null || !tag.m_128441_("EntityTag")) {
            if (vs == null) {
                return UtilMCText.translatable((String)this.m_5524_()).m_130946_(" unknown preset!");
            }
            return vs.getDisplayNameComponent().m_6270_(Style.f_131099_.m_178520_(0x55FFFF));
        }
        CompoundTag etag = tag.m_128469_("EntityTag");
        if (etag.m_128425_("CustomName", 8)) {
            String cn = etag.m_128461_("CustomName");
            try {
                return Component.Serializer.m_130701_((String)cn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((owner = etag.m_128461_("owner_name")).isEmpty()) {
            owner = "Someone";
        }
        MutableComponent component = UtilMCText.literal((String)(owner + "'s ")).m_6270_(Style.f_131099_.m_178520_(0xFFAA00).m_131136_(Boolean.valueOf(true)));
        if (vs == null) {
            return component.m_7220_(super.m_7626_(stack));
        }
        return component.m_7220_((Component)vs.getBaseDisplayName());
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("EntityTag");
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        VehicleStats[] presets;
        if (group != ModItems.VEHICLES && group != CreativeModeTab.f_40754_) {
            return;
        }
        for (VehicleStats preset : presets = (VehicleStats[])VehiclePresets.get().getAll()) {
            if (!preset.getItem().m_150930_((Item)this)) continue;
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_().m_128359_("preset", preset.getId());
            items.add((Object)stack);
        }
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ObjEntityModels.ModelOverrides getItemModelOverrides(@NotNull String preset) {
        VehicleStats vs = (VehicleStats)VehiclePresets.get().get(preset);
        if (vs == null) {
            vs = (VehicleStats)VehiclePresets.get().get(this.getDefaultPreset());
        }
        if (vs == null) {
            return ObjEntityModels.NO_OVERRIDES;
        }
        String assetId = vs.getAssetId();
        VehicleClientStats vcs = VehicleClientPresets.get().get(assetId);
        if (vcs == null) {
            return ObjEntityModels.NO_OVERRIDES;
        }
        return vcs.getItemModelOverrides();
    }

    public String getDefaultPreset() {
        return this.defaultPreset;
    }

    @NotNull
    public String getPreset(@NotNull ItemStack stack) {
        return this.getPresetName(stack);
    }

    @NotNull
    public String getObjModelId(@NotNull String preset) {
        VehicleStats vs = (VehicleStats)VehiclePresets.get().get(preset);
        if (vs == null) {
            vs = (VehicleStats)VehiclePresets.get().get(this.getDefaultPreset());
        }
        if (vs == null) {
            return "";
        }
        String assetId = vs.getAssetId();
        VehicleClientStats vcs = VehicleClientPresets.get().get(assetId);
        if (vcs == null) {
            return "";
        }
        return vcs.getModelId();
    }
}

