/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.init;

import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.fluid.CustomFluidType;
import com.onewhohears.dscombat.init.ModBlocks;
import com.onewhohears.dscombat.init.ModItems;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"dscombat");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"dscombat");
    public static final RegistryObject<FluidType> OIL_FLUID_TYPE = ModFluids.registerType("oil", FluidType.Properties.create().lightLevel(1).density(1000).viscosity(1000).fallDistanceModifier(0.1f).canConvertToSource(false).canDrown(true).canExtinguish(false).supportsBoating(true).canHydrate(false).canPushEntity(true).canSwim(false).motionScale(0.001).sound(SoundAction.get((String)"drink"), SoundEvents.f_12551_), new ResourceLocation("block/oil_block"), new ResourceLocation("misc/in_oil_oil"), new ResourceLocation("block/oil_block"), -16777216, 10.0f, 10.0f, 10.0f, 0.2f, 1.2f);
    public static final RegistryObject<FlowingFluid> OIL_FLUID_SOURCE = FLUIDS.register("oil_fluid_source", () -> new ForgeFlowingFluid.Source(OIL_FLUID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> OIL_FLUID_FLOWING = FLUIDS.register("oil_fluid_flowing", () -> new ForgeFlowingFluid.Flowing(OIL_FLUID_PROPERTIES));
    public static final ForgeFlowingFluid.Properties OIL_FLUID_PROPERTIES = new ForgeFlowingFluid.Properties(OIL_FLUID_TYPE, OIL_FLUID_SOURCE, OIL_FLUID_FLOWING).slopeFindDistance(2).levelDecreasePerBlock(2).tickRate(15).block(ModBlocks.OIL_LIQUID_BLOCK).bucket(ModItems.OIL_BUCKET);

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
        FLUID_TYPES.register(eventBus);
    }

    public static RegistryObject<FluidType> registerType(String name, FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation overlayTexture, ResourceLocation flowingTexture, int tintColor, float fogR, float fogG, float fogB, float fogStart, float fogEnd) {
        return FLUID_TYPES.register(name, () -> new CustomFluidType(properties, stillTexture, overlayTexture, flowingTexture, tintColor, new Vector3f(fogR / 255.0f, fogG / 255.0f, fogB / 255.0f), fogStart, fogEnd));
    }
}

