/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.DependencySafety;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.weapon.NonTickingMissileManager;
import com.onewhohears.dscombat.data.weapon.stats.MissileStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.damagesource.WeaponDamageSource;
import com.onewhohears.dscombat.entity.weapon.EntityBullet;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilClientSafeSounds;
import com.onewhohears.dscombat.util.UtilParticles;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class EntityMissile<T extends MissileStats>
extends EntityBullet<T> {
    public static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(EntityMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Vec3> TARGET_POS = SynchedEntityData.m_135353_(EntityMissile.class, DataSerializers.VEC3);
    public Entity target;
    public Vec3 targetPos;
    private boolean discardedButTicking;
    private boolean didSonicBoom;
    private int prevTickCount;
    private int tickCountRepeats;
    private int repeatCoolDown;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpXRot;
    private double lerpYRot;

    public EntityMissile(EntityType<? extends EntityMissile<?>> type, Level level, String defaultWeaponId) {
        super((EntityType<? extends EntityBullet<?>>)type, level, defaultWeaponId);
        if (!level.f_46443_) {
            NonTickingMissileManager.addMissile(this);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(TARGET_POS, (Object)Vec3.f_82478_.m_82520_(0.0, -1000.0, 0.0));
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        DataSerializers.VEC3.m_6856_(buffer, (Object)this.m_20184_());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.m_20256_((Vec3)DataSerializers.VEC3.m_6709_(buffer));
    }

    @Override
    public void init() {
    }

    @Override
    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            this.clientTickParticles();
        }
        if (this.isTestMode()) {
            return;
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        if (!this.m_213877_()) {
            if (!this.m_9236_().m_5776_()) {
                this.tickGuide();
                if (this.targetPos != null) {
                    this.setTargetPos(this.targetPos);
                } else {
                    this.setTargetPos(Vec3.f_82478_.m_82520_(0.0, -1000.0, 0.0));
                }
                if (this.target != null) {
                    this.setTargetId(this.target.m_19879_());
                } else {
                    this.setTargetId(-1);
                }
                if (this.target != null && (double)this.m_20270_(this.target) <= ((MissileStats)((Object)this.getWeaponStats())).getFuseDist()) {
                    this.m_6074_();
                }
                TrackableEntitiesManager.addTrackableEntity((Entity)this);
                DependencySafety.addExtraEntityToRDP(Objects.requireNonNull(this.m_20194_()), (Entity)this, new ServerPlayer[0]);
            } else {
                this.tickClientGuide();
                if (this.f_19803_) {
                    this.engineSound();
                }
                if (this.canSonicBoom()) {
                    this.sonicBoomSound();
                }
            }
        }
        super.m_8119_();
        this.tickLerp();
        if (!this.m_9236_().m_5776_() && this.f_19797_ > 100 && this.m_20184_().m_82553_() < 0.1) {
            this.m_6074_();
            return;
        }
    }

    public void clientTickParticles() {
        if (this.getAge() <= this.getFuelTicks()) {
            UtilParticles.missileAfterBurner(this.f_19853_, this.m_20182_(), this.m_20154_().m_82490_(-1.0));
        }
        UtilParticles.missileTrail(this.f_19853_, this.m_20182_(), this.m_20154_(), this.getRadius(), this.m_20069_());
    }

    public abstract void tickGuide();

    public void tickClientGuide() {
        Entity t;
        int tid;
        Vec3 tpos = this.getTargetPos();
        if (tpos.f_82480_ == -1000.0) {
            tpos = null;
        }
        this.targetPos = (tid = this.getTargetId()) != -1 ? ((t = this.f_19853_.m_6815_(tid)) != null ? t.m_20182_() : tpos) : tpos;
        this.guideToPosition();
    }

    public void guideToTarget() {
        if (this.target == null) {
            this.targetPos = null;
            return;
        }
        if (this.target.m_213877_()) {
            this.target = null;
            this.targetPos = null;
            return;
        }
        if (this.f_19797_ % 10 == 0) {
            if (!this.checkTargetRange(this.target, 10000.0)) {
                this.target = null;
                this.targetPos = null;
                return;
            }
            if (!this.checkCanSee(this.target)) {
                this.target = null;
                this.targetPos = null;
                return;
            }
        }
        Vec3 tVel = this.target.m_20184_();
        if (UtilVehicleEntity.isOnGroundOrWater(this.target)) {
            tVel = tVel.m_82542_(1.0, 0.0, 1.0);
        }
        this.targetPos = UtilGeometry.interceptPos((Vec3)this.m_20182_(), (Vec3)this.m_20184_(), (Vec3)this.target.m_20191_().m_82399_(), (Vec3)tVel);
        this.guideToPosition();
    }

    protected static boolean checkTargetRange(Entity weapon, Entity target, float fov, double range) {
        if (fov == -1.0f) {
            return (double)weapon.m_20270_(target) <= range;
        }
        return UtilGeometry.isPointInsideCone((Vec3)target.m_20182_(), (Vec3)weapon.m_20182_(), (Vec3)weapon.m_20154_(), (double)fov, (double)range);
    }

    protected boolean checkTargetRange(Entity target, double range) {
        return EntityMissile.checkTargetRange((Entity)this, target, ((MissileStats)((Object)this.getWeaponStats())).getFov(), range);
    }

    protected boolean checkCanSee(Entity target) {
        return UtilEntity.canEntitySeeEntity((Entity)this, (Entity)target, (int)((Integer)Config.COMMON.maxBlockCheckDepth.get()), (double)(((MissileStats)((Object)this.getWeaponStats())).getSeeThroWater() + 1), (double)((MissileStats)((Object)this.getWeaponStats())).getSeeThroBlock());
    }

    private void engineSound() {
        UtilClientSafeSounds.dopplerSound((Entity)this, ModSounds.MISSILE_ENGINE_1, 0.8f, 1.0f, DSCPhyCons.VEL_SOUND, false);
    }

    private boolean canSonicBoom() {
        if (this.didSonicBoom) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            return false;
        }
        Entity owner = this.m_37282_();
        return owner == null || !owner.equals((Object)Minecraft.m_91087_().f_91074_);
    }

    private void sonicBoomSound() {
        this.didSonicBoom = UtilClientSafeSounds.missileSonicBoom(this);
    }

    @Override
    public void m_6043_() {
    }

    public void tickOutRange() {
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        if (this.f_19797_ > this.getMaxAge()) {
            this.m_6074_();
            return;
        }
        if (this.dieIfNoTargetOutsideTickRange() && this.targetPos == null) {
            this.m_6074_();
            return;
        }
        if (this.f_19797_ > 100 && this.m_20184_().m_82553_() < 0.1) {
            this.m_6074_();
            return;
        }
        this.tickGuide();
        this.tickSetMove();
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        ++this.f_19797_;
    }

    public boolean dieIfNoTargetOutsideTickRange() {
        return true;
    }

    @Override
    protected void tickSetMove() {
        double ga;
        double gravityAcc;
        Vec3 cm = this.m_20184_();
        double cv = cm.m_82553_();
        double max = this.getSpeed();
        double B = this.getBleed() * UtilEntity.getAirPressure((Entity)this) * 0.4;
        double turnBleed = B * (double)(Math.abs(this.m_146909_() - this.f_19860_) + Math.abs(this.m_146908_() - this.f_19859_));
        double airRes = B * cv * 0.01;
        double vel = cv - turnBleed - airRes;
        if (this.getAge() <= this.getFuelTicks()) {
            vel += this.getAcceleration();
        }
        if ((vel += (gravityAcc = Math.max(0.0, ga = Math.sin((float)Math.PI / 180 * UtilAngles.getPitch((Vec3)cm)) * this.getGravityAcc() * 0.05))) > max) {
            vel = max;
        } else if (vel < 0.1) {
            vel = 0.1;
        }
        Vec3 nm = this.m_20154_().m_82490_(vel);
        this.m_20256_(nm);
    }

    @Override
    protected void tickSetAngle() {
    }

    public void guideToPosition() {
        float rot;
        Vec3 cur_dir;
        if (this.targetPos == null) {
            return;
        }
        Vec3 goal_dir = this.targetPos.m_82546_(this.m_20182_());
        float deg_diff = (float)UtilGeometry.angleBetweenDegrees((Vec3)goal_dir, (Vec3)(cur_dir = this.m_20154_()));
        if (deg_diff <= (rot = this.getTurnDegrees())) {
            this.m_146926_(UtilAngles.getPitch((Vec3)goal_dir));
            this.m_146922_(UtilAngles.getYaw((Vec3)goal_dir));
        } else {
            Vec3 P = cur_dir.m_82537_(goal_dir).m_82541_();
            Vec3 new_dir = UtilAngles.rotateVector((Vec3)cur_dir, (Quaternion)new Quaternion(UtilGeometry.convertVector((Vec3)P), rot, true));
            this.m_146926_(UtilAngles.getPitch((Vec3)new_dir));
            this.m_146922_(UtilAngles.getYaw((Vec3)new_dir));
        }
    }

    public float getTurnDegrees() {
        return (float)this.m_20184_().m_82553_() / this.getTurnRadius() * 57.295776f;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_213877_()) {
            return false;
        }
        if (this.equals(source.m_7640_())) {
            return false;
        }
        if (this.m_7307_(source.m_7639_())) {
            return false;
        }
        this.m_6074_();
        return true;
    }

    @Override
    public boolean m_6128_() {
        return false;
    }

    public double getAcceleration() {
        return ((MissileStats)((Object)this.getWeaponStats())).getAcceleration();
    }

    public double getBleed() {
        return ((MissileStats)((Object)this.getWeaponStats())).getBleed();
    }

    public int getFuelTicks() {
        return ((MissileStats)((Object)this.getWeaponStats())).getFuelTicks();
    }

    public float getTurnRadius() {
        return ((MissileStats)((Object)this.getWeaponStats())).getTurnRadius();
    }

    public int getTargetId() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ID);
    }

    public void setTargetId(int id) {
        this.f_19804_.m_135381_(TARGET_ID, (Object)id);
    }

    public Vec3 getTargetPos() {
        return (Vec3)this.f_19804_.m_135370_(TARGET_POS);
    }

    public void setTargetPos(Vec3 pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)pos);
    }

    public void discardButTick() {
        this.m_146870_();
        this.discardedButTicking = true;
        this.repeatCoolDown = 5;
    }

    @Override
    public void m_6074_() {
        super.m_6074_();
        this.discardedButTicking = false;
    }

    public void revive() {
        super.revive();
        this.discardedButTicking = false;
    }

    @Override
    public boolean isDiscardedButTicking() {
        return this.discardedButTicking;
    }

    public int getTickCountRepeats() {
        if (this.f_19797_ == this.prevTickCount) {
            ++this.tickCountRepeats;
        } else if (this.tickCountRepeats > 0) {
            this.tickCountRepeats = 0;
        }
        this.prevTickCount = this.f_19797_;
        if (this.repeatCoolDown > 0) {
            --this.repeatCoolDown;
            return 10;
        }
        return this.tickCountRepeats;
    }

    @Override
    public ClipContext.Fluid getFluidClipContext() {
        return ClipContext.Fluid.SOURCE_ONLY;
    }

    @Override
    public int minExplodeAge() {
        return 20;
    }

    @Override
    protected WeaponDamageSource getImpactDamageSource() {
        return WeaponDamageSource.WeaponDamageType.MISSILE_CONTACT.getSource(this.m_37282_(), this);
    }

    @Override
    protected WeaponDamageSource getExplosionDamageSource() {
        return WeaponDamageSource.WeaponDamageType.MISSILE.getSource(this.m_37282_(), this);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.m_20185_() && y == this.m_20186_() && z == this.m_20189_()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = 10;
    }

    private void tickLerp() {
        if (!this.f_19853_.f_46443_) {
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.lerpSteps = 0;
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public boolean m_6087_() {
        return true;
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.f_19853_.m_46469_().m_46207_(DSCGameRules.BROADCAST_MISSILE_HIT)) {
            Entity entity = result.m_82443_();
            if (entity == null) {
                return;
            }
            ServerPlayer targetPlayer = null;
            if (entity instanceof ServerPlayer) {
                ServerPlayer tsp;
                targetPlayer = tsp = (ServerPlayer)entity;
            } else {
                Entity entity2 = entity.m_6688_();
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer tsp;
                    targetPlayer = tsp = (ServerPlayer)entity2;
                }
            }
            if (targetPlayer == null) {
                return;
            }
            Entity owner = this.m_37282_();
            if (!(owner instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer ownerPlayer = (ServerPlayer)owner;
            MutableComponent message = UtilMCText.translatable((String)"info.dscombat.missile_impacted_player", (Object[])new Object[]{ownerPlayer.m_5446_(), targetPlayer.m_5446_()});
            boolean teamOnly = this.f_19853_.m_46469_().m_46207_(DSCGameRules.BROADCAST_MISSILE_HIT_TEAM_ONLY);
            List players = this.f_19853_.m_7654_().m_6846_().m_11314_();
            for (ServerPlayer player : players) {
                if (teamOnly && (ownerPlayer.m_5647_() == null || player.m_5647_() == null || !ownerPlayer.m_5647_().m_5758_().equals(player.m_5647_().m_5758_()))) continue;
                player.m_5661_((Component)message, false);
            }
        }
    }

    @Override
    public WeaponStats.WeaponClientImpactType getClientImpactType() {
        return WeaponStats.WeaponClientImpactType.MED_MISSILE_EXPLODE;
    }
}

