/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle.wind_tunnel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilPrint;
import com.onewhohears.dscombat.util.math.UtilEstimate;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WindTunnelJob {
    private int age = -1;
    protected boolean complete = false;

    private static void addToArraySorted(JsonArray a, JsonObject o) {
        float firstKey;
        if (a.isEmpty()) {
            a.add((JsonElement)o);
            return;
        }
        float key = o.get("key").getAsFloat();
        if (key < (firstKey = a.get(0).getAsJsonObject().get("key").getAsFloat())) {
            WindTunnelJob.addToStart(a, (JsonElement)o);
        } else {
            a.add((JsonElement)o);
        }
    }

    public static void addToStart(JsonArray a, JsonElement e) {
        JsonArray temp = a.deepCopy();
        while (!a.isEmpty()) {
            a.remove(0);
        }
        a.add(e);
        a.addAll(temp);
    }

    public static String getJobDataPath(EntityWindTunnel tunnel) {
        File dir = tunnel.m_9236_().m_5776_() ? Minecraft.m_91087_().f_91069_ : tunnel.m_9236_().m_7654_().m_6237_();
        String path = dir.getPath().equals(".") ? dir.getAbsolutePath().substring(0, dir.getAbsolutePath().length() - 2) : dir.getAbsolutePath();
        return path + "/dscombat/wind_tunnel_results/";
    }

    protected abstract void init(EntityWindTunnel var1);

    protected abstract boolean isJobComplete(EntityWindTunnel var1);

    protected abstract void run(EntityWindTunnel var1);

    protected abstract void onJobComplete(EntityWindTunnel var1);

    protected void finishEarly(EntityWindTunnel tunnel) {
        this.complete = true;
        this.onJobComplete(tunnel);
    }

    public final void tick(EntityWindTunnel tunnel) {
        if (this.complete) {
            return;
        }
        ++this.age;
        if (this.age == 0) {
            this.init(tunnel);
        } else if (this.age % this.getUpdateRate() == 0) {
            if (this.isJobComplete(tunnel)) {
                this.onJobComplete(tunnel);
                this.complete = true;
            } else {
                this.run(tunnel);
            }
        }
    }

    public int getAge() {
        return this.age;
    }

    public int getUpdateRate() {
        return 5;
    }

    public static class FindOptimalPitchJob
    extends WindTunnelJob {
        private final float yaw;
        private final float roll;
        private double pitch = 0.0;
        private double prevPitch = -1000.0;
        private double prevAccY = -1000.0;

        public FindOptimalPitchJob(float yaw, float roll) {
            this.yaw = yaw;
            this.roll = roll;
        }

        @Override
        protected void init(EntityWindTunnel tunnel) {
            tunnel.chatToNearbyPlayers("Searching for optimal Pitch...", ChatFormatting.YELLOW);
            this.pitch = 0.0;
            this.updatePitch(tunnel);
            this.prevPitch = -1000.0;
            this.prevAccY = -1000.0;
        }

        @Override
        protected boolean isJobComplete(EntityWindTunnel tunnel) {
            return tunnel.totalAcc.f_82480_ > 0.0 && tunnel.totalAcc.f_82480_ < 1.0E-4;
        }

        @Override
        protected void run(EntityWindTunnel tunnel) {
            double currentAccY = tunnel.totalAcc.f_82480_ * 1000000.0;
            double currentPitch = this.pitch * 1000.0;
            if (this.prevAccY == -1000.0) {
                this.prevPitch = currentPitch;
                this.prevAccY = currentAccY;
                this.pitch -= 1.0;
                this.updatePitch(tunnel);
                return;
            }
            try {
                this.pitch = UtilEstimate.nextGuessSecantMethod(this.prevPitch, currentPitch, this.prevAccY, currentAccY) * 0.001;
            }
            catch (IllegalArgumentException e) {
                this.finishEarly(tunnel);
                return;
            }
            this.updatePitch(tunnel);
            this.prevAccY = currentAccY;
            this.prevPitch = currentPitch;
        }

        @Override
        protected void onJobComplete(EntityWindTunnel tunnel) {
            tunnel.chatToNearbyPlayers("" + this.pitch, ChatFormatting.BLUE);
        }

        private void updatePitch(EntityWindTunnel tunnel) {
            tunnel.setQ(UtilAngles.toQuaternion((double)this.yaw, (double)this.pitch, (double)this.roll));
        }

        public float getPitch() {
            return (float)this.pitch;
        }

        public float getYaw() {
            return this.yaw;
        }
    }

    public static class FindOptimalLiftC
    extends WindTunnelJob {
        private final float yaw;
        private final float roll;
        private final float pitch;
        private final float turn_rate;
        private double prevYawRate;
        private double liftC = 0.4;
        private double prevLiftC;

        public FindOptimalLiftC(float yaw, float roll, float pitch, float turn_rate) {
            this.yaw = yaw;
            this.roll = roll;
            this.pitch = pitch;
            this.turn_rate = turn_rate;
        }

        @Override
        protected void init(EntityWindTunnel tunnel) {
            tunnel.chatToNearbyPlayers("Searching for optimal Lift Coefficient...", ChatFormatting.YELLOW);
            tunnel.setQ(UtilAngles.toQuaternion((double)this.yaw, (double)this.pitch, (double)this.roll));
            this.prevYawRate = -1000.0;
            this.prevLiftC = -1000.0;
            this.updateLiftC(tunnel);
        }

        @Override
        protected boolean isJobComplete(EntityWindTunnel tunnel) {
            return Math.abs((double)this.turn_rate - tunnel.yawRate * 20.0) < 0.001;
        }

        @Override
        protected void run(EntityWindTunnel tunnel) {
            double currentYawRate = ((double)this.turn_rate - tunnel.yawRate * 20.0) * 1000.0;
            double currentLiftC = this.liftC * 1000.0;
            if (this.prevYawRate == -1000.0) {
                this.prevYawRate = currentYawRate;
                this.prevLiftC = currentLiftC;
                this.liftC += 0.1;
                this.updateLiftC(tunnel);
                return;
            }
            try {
                this.liftC = UtilEstimate.nextGuessSecantMethod(this.prevLiftC, currentLiftC, this.prevYawRate, currentYawRate) * 0.001;
            }
            catch (IllegalArgumentException e) {
                this.finishEarly(tunnel);
                return;
            }
            this.updateLiftC(tunnel);
            this.prevYawRate = currentYawRate;
            this.prevLiftC = currentLiftC;
        }

        @Override
        protected void onJobComplete(EntityWindTunnel tunnel) {
            tunnel.chatToNearbyPlayers("" + this.liftC, ChatFormatting.BLUE);
            tunnel.clearOverrideValue("lift_coefficient");
        }

        public float getLiftC() {
            return (float)this.liftC;
        }

        public float getPitch() {
            return this.pitch;
        }

        private void updateLiftC(EntityWindTunnel tunnel) {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("aoa", (double)this.yaw);
            tag.m_128347_("liftC", this.liftC);
            tunnel.setOverrideValue("lift_coefficient", tag);
        }
    }

    public static class FindOptimalDragC
    extends WindTunnelJob {
        private final float yaw;
        private final float roll;
        private final float pitch;
        private final float liftC;
        private double prevWindAcc;
        private double dragC;
        private double prevDragC;
        private double first_guess_delta = 0.01;
        private double first_guess = 0.01;
        int attempts = 0;
        private double bestGuessDragC;
        private double bestGuessWindAcc = 1000000.0;

        public FindOptimalDragC(float yaw, float roll, float pitch, float liftC) {
            this.yaw = yaw;
            this.roll = roll;
            this.pitch = pitch;
            this.liftC = liftC;
        }

        @Override
        protected void init(EntityWindTunnel tunnel) {
            if (this.attempts == 0) {
                tunnel.chatToNearbyPlayers("Searching for optimal Drag Coefficient...", ChatFormatting.YELLOW);
            } else if (this.attempts == 1) {
                tunnel.chatToNearbyPlayers("First attempt failed trying again...", ChatFormatting.YELLOW);
            }
            tunnel.setQ(UtilAngles.toQuaternion((double)this.yaw, (double)this.pitch, (double)this.roll));
            this.prevWindAcc = -1000.0;
            this.prevDragC = -1000.0;
            this.dragC = this.first_guess;
            this.updateDragC(tunnel);
        }

        @Override
        protected boolean isJobComplete(EntityWindTunnel tunnel) {
            return Math.abs(tunnel.windCompAcc) < 1.0E-4;
        }

        @Override
        protected void run(EntityWindTunnel tunnel) {
            double currentWindAcc = tunnel.windCompAcc * 1000.0;
            double currentDragC = this.dragC * 1000.0;
            if (this.prevWindAcc == -1000.0) {
                this.prevWindAcc = currentWindAcc;
                this.prevDragC = currentDragC;
                this.dragC += this.first_guess_delta;
                this.updateDragC(tunnel);
                return;
            }
            try {
                this.dragC = UtilEstimate.nextGuessSecantMethod(this.prevDragC, currentDragC, this.prevWindAcc, currentWindAcc) * 0.001;
            }
            catch (IllegalArgumentException e) {
                if (this.attempts >= 40) {
                    this.finishEarly(tunnel);
                    tunnel.chatToNearbyPlayers("Best Guess: " + this.bestGuessDragC + " | Error: " + this.bestGuessWindAcc, ChatFormatting.RED);
                    return;
                }
                ++this.attempts;
                if (Math.abs(currentWindAcc) < Math.abs(this.bestGuessWindAcc)) {
                    this.bestGuessWindAcc = currentWindAcc;
                    this.bestGuessDragC = currentDragC * 0.001;
                }
                if (this.attempts % 10 == 0 && this.attempts != 0) {
                    this.first_guess_delta = Math.ceil((double)this.attempts / 10.0) * 0.01;
                    this.first_guess += 0.04;
                } else {
                    this.first_guess_delta += Math.ceil((double)this.attempts / 10.0) * 0.01;
                }
                this.init(tunnel);
                return;
            }
            this.updateDragC(tunnel);
            this.prevWindAcc = currentWindAcc;
            this.prevDragC = currentDragC;
        }

        @Override
        protected void onJobComplete(EntityWindTunnel tunnel) {
            tunnel.chatToNearbyPlayers("" + this.dragC, ChatFormatting.BLUE);
            tunnel.clearOverrideValue("lift_coefficient");
            tunnel.clearOverrideValue("drag_coefficient");
        }

        public float getDragC() {
            return (float)this.dragC;
        }

        private void updateDragC(EntityWindTunnel tunnel) {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("aoa", (double)this.yaw);
            tag.m_128347_("liftC", (double)this.liftC);
            tunnel.setOverrideValue("lift_coefficient", tag);
            CompoundTag tag2 = new CompoundTag();
            tag2.m_128347_("aoa", (double)this.yaw);
            tag2.m_128347_("dragC", this.dragC);
            tunnel.setOverrideValue("drag_coefficient", tag2);
        }
    }

    public static class FindLiftDragJob
    extends JobArray {
        private final float aoa;
        private final float turn_rate;
        private double optimal_pitch;
        private double optimal_lift;
        private double optimal_drag;

        public FindLiftDragJob(float aoa, float turn_rate) {
            super((tunnel, previous_job) -> new FindOptimalPitchJob(aoa, 90.0f), (tunnel, previous_job) -> new FindOptimalLiftC(aoa, 90.0f, ((FindOptimalPitchJob)previous_job).getPitch(), turn_rate), (tunnel, previous_job) -> new FindOptimalDragC(aoa, 90.0f, ((FindOptimalLiftC)previous_job).getPitch(), ((FindOptimalLiftC)previous_job).getLiftC()));
            this.aoa = aoa;
            this.turn_rate = turn_rate;
        }

        @Override
        protected void onJobComplete(EntityWindTunnel tunnel) {
            if (this.jobs.size() < 3) {
                tunnel.chatToNearbyPlayers("FindLiftDragJob Error | Job Index " + this.getJobIndex() + " | Yaw " + this.aoa + " | Turn Rate " + this.turn_rate, ChatFormatting.RED);
                return;
            }
            this.optimal_pitch = ((FindOptimalPitchJob)this.jobs.get(0)).getPitch();
            this.optimal_lift = ((FindOptimalLiftC)this.jobs.get(1)).getLiftC();
            this.optimal_drag = ((FindOptimalDragC)this.jobs.get(2)).getDragC();
        }

        public double getOptimalDrag() {
            return this.optimal_drag;
        }

        public double getOptimalLift() {
            return this.optimal_lift;
        }

        public double getOptimalPitch() {
            return this.optimal_pitch;
        }

        public float getAoa() {
            return this.aoa;
        }

        public float getTurnRate() {
            return this.turn_rate;
        }
    }

    public static abstract class JobArray
    extends WindTunnelJob {
        private final JobGen[] job_gens;
        protected final List<WindTunnelJob> jobs = new ArrayList<WindTunnelJob>();
        private final int job_num;
        @Nullable
        private WindTunnelJob current_job;
        private int job_index = 0;

        public JobArray(JobGen ... job_gens) {
            this.job_gens = job_gens;
            this.job_num = this.job_gens.length;
        }

        @Override
        protected void init(EntityWindTunnel tunnel) {
            if (this.job_gens.length == 0) {
                this.finishEarly(tunnel);
                return;
            }
            this.current_job = this.job_gens[0].create(tunnel, null);
            this.jobs.add(this.current_job);
        }

        @Override
        protected boolean isJobComplete(EntityWindTunnel tunnel) {
            return this.current_job == null || this.job_index == this.job_num - 1 && this.current_job.complete;
        }

        @Override
        protected void run(EntityWindTunnel tunnel) {
            if (this.current_job == null) {
                this.finishEarly(tunnel);
                return;
            }
            if (this.current_job.complete) {
                ++this.job_index;
                this.current_job = this.job_gens[this.job_index].create(tunnel, this.current_job);
                this.jobs.add(this.current_job);
            }
            this.current_job.tick(tunnel);
        }

        @Override
        public int getUpdateRate() {
            return 1;
        }

        public int getJobIndex() {
            return this.job_index;
        }
    }

    public static interface JobGen {
        @NotNull
        public WindTunnelJob create(EntityWindTunnel var1, WindTunnelJob var2);
    }

    public static class MultiLiftDragJob
    extends JobArray {
        public MultiLiftDragJob(JsonArray params) {
            super(MultiLiftDragJob.createJobs(params));
        }

        static JobGen[] createJobs(JsonArray params) {
            JobGen[] gens = new JobGen[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                JsonObject param = params.get(i).getAsJsonObject();
                final float speed = param.get("speed").getAsFloat();
                float aoa = param.get("aoa").getAsFloat();
                float turn_rate = param.get("turn_rate").getAsFloat();
                gens[i] = (tunnel, previous_job) -> new FindLiftDragJob(aoa, turn_rate){

                    @Override
                    protected void init(EntityWindTunnel tunnel) {
                        super.init(tunnel);
                        tunnel.setSpeed(new Vec3(0.0, 0.0, (double)speed));
                    }
                };
            }
            return gens;
        }

        @Override
        protected void onJobComplete(EntityWindTunnel tunnel) {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH:mm:ss");
            String time = now.format(formatter);
            String dir = MultiLiftDragJob.getJobDataPath(tunnel);
            new File(dir).mkdirs();
            String path = dir + "liftdragaoa_" + tunnel.getStatsId() + "_" + time + "_";
            String lift_path = path + "lift.json";
            String drag_path = path + "drag.json";
            JsonObject lift_data = new JsonObject();
            JsonObject drag_data = new JsonObject();
            JsonArray lift_map = new JsonArray();
            JsonArray drag_map = new JsonArray();
            for (WindTunnelJob j : this.jobs) {
                FindLiftDragJob job = (FindLiftDragJob)j;
                JsonObject l = new JsonObject();
                l.addProperty("key", (Number)Float.valueOf(job.getAoa()));
                l.addProperty("value", (Number)job.getOptimalLift());
                WindTunnelJob.addToArraySorted(lift_map, l);
                JsonObject d = new JsonObject();
                d.addProperty("key", (Number)Float.valueOf(job.getAoa()));
                d.addProperty("value", (Number)job.getOptimalDrag());
                WindTunnelJob.addToArraySorted(drag_map, d);
            }
            lift_data.add("map", (JsonElement)lift_map);
            drag_data.add("map", (JsonElement)drag_map);
            UtilPrint.printJsonAbsoluteDirectory(lift_path, lift_data);
            UtilPrint.printJsonAbsoluteDirectory(drag_path, drag_data);
            tunnel.chatToNearbyPlayers("Completed Job! Outputting data to " + lift_path + " and " + drag_path, ChatFormatting.LIGHT_PURPLE);
        }
    }
}

