/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.ai.goal;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.BulletStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class TurretShootGoal
extends Goal {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Random RANDOM = new Random();
    public static final ShootFunction CANT_SHOOT = (mob, turret, target, prevTargetPos) -> Vec3.f_82478_;
    public static final ShootFunction RANDOM_SHOOT = (mob, turret, target, prevTargetPos) -> {
        if (prevTargetPos == null || mob.f_19797_ % 30 == 0) {
            prevTargetPos = mob.m_146892_().m_82520_((RANDOM.nextDouble() - 0.5) * 100.0, (RANDOM.nextDouble() - 0.25) * 30.0, (RANDOM.nextDouble() - 0.5) * 100.0);
        }
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        turret.shoot((Entity)mob);
        return prevTargetPos;
    };
    public static final ShootFunction DUMBASS_SHOOT = (mob, turret, target, prevTargetPos) -> {
        prevTargetPos = TurretShootGoal.inaccurateShootPos(mob, turret, target, prevTargetPos, 20, 25.0f, false);
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        if (TurretShootGoal.shouldShootTurret(turret, target, prevTargetPos, 360.0f, false, false)) {
            turret.shoot((Entity)mob);
        }
        return prevTargetPos;
    };
    public static final ShootFunction STUPID_SHOOT = (mob, turret, target, prevTargetPos) -> {
        prevTargetPos = TurretShootGoal.inaccurateShootPos(mob, turret, target, prevTargetPos, 10, 10.0f, false);
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        if (TurretShootGoal.shouldShootTurret(turret, target, prevTargetPos, 20.0f, true, false)) {
            turret.shoot((Entity)mob);
        }
        return prevTargetPos;
    };
    public static final ShootFunction NORMAL_SHOOT = (mob, turret, target, prevTargetPos) -> {
        prevTargetPos = TurretShootGoal.inaccurateShootPos(mob, turret, target, prevTargetPos, 10, 5.0f, true);
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        if (TurretShootGoal.shouldShootTurret(turret, target, prevTargetPos, 10.0f, true, true)) {
            turret.shoot((Entity)mob);
        }
        return prevTargetPos;
    };
    public static final ShootFunction SMART_SHOOT = (mob, turret, target, prevTargetPos) -> {
        prevTargetPos = TurretShootGoal.inaccurateShootPos(mob, turret, target, prevTargetPos, 8, 2.0f, true);
        TurretShootGoal.lookAtPos(mob, prevTargetPos, turret);
        if (TurretShootGoal.shouldShootTurret(turret, target, prevTargetPos, 5.0f, true, true)) {
            turret.shoot((Entity)mob);
        }
        return prevTargetPos;
    };
    private final EntityTurret turret;
    private final Mob mob;
    private final ShootFunction shootFunction;
    private Vec3 prevTargetPos;

    public static boolean debugTurretAI() {
        return (Boolean)Config.COMMON.logTurretAIDebug.get();
    }

    public static void lookAtPos(Mob mob, Vec3 pos, EntityTurret turret) {
        UtilEntity.mobLookAtPos((Mob)mob, (Vec3)pos, (float)mob.m_21529_());
        Vec3 diff = pos.m_82546_(mob.m_146892_());
        float goalRotX = UtilAngles.getPitch((Vec3)diff);
        float goalRotY = UtilAngles.getYaw((Vec3)diff);
        turret.setOverrideLookAngles(goalRotX, goalRotY);
    }

    public static Vec3 inaccurateShootPos(Mob mob, EntityTurret turret, LivingEntity target, Vec3 prevTargetPos, int updateRate, float inaccuracy, boolean accountGravity) {
        if (prevTargetPos == null || mob.f_19797_ % updateRate == 0) {
            Vec3 origin = turret.m_146892_();
            Vec3 targetPos = target.m_146892_();
            WeaponInstance<?> wd = turret.getWeaponData();
            if (accountGravity && wd != null && ((WeaponStats)wd.getStats()).isBullet()) {
                double h;
                Vec3 diff;
                double r;
                double div;
                double g;
                double z;
                double[] roots;
                double speed = ((BulletStats)wd.getStats()).getSpeed();
                if (speed <= 0.0) {
                    speed = 0.01;
                }
                if ((roots = UtilGeometry.rootsNoI((double)(z = 0.5 * (g = -9.81) * (div = (r = (diff = targetPos.m_82546_(origin)).m_165924_()) / speed) * div), (double)r, (double)(z - (h = diff.f_82480_)))) != null) {
                    double root = Math.min(roots[0], roots[1]);
                    targetPos = new Vec3(targetPos.f_82479_, origin.f_82480_ + root * r, targetPos.f_82481_);
                }
            }
            prevTargetPos = UtilGeometry.inaccurateTargetPos((Vec3)origin, (Vec3)targetPos, (float)inaccuracy);
        }
        return prevTargetPos;
    }

    public static boolean shouldShootTurret(EntityTurret turret, LivingEntity target, Vec3 targetPos, float aimError, boolean useIRMis, boolean useTrackMis) {
        boolean trackMissile;
        WeaponInstance<?> wd = turret.getWeaponData();
        if (wd == null) {
            if (TurretShootGoal.debugTurretAI()) {
                LOGGER.info("NO SHOOT weapon data null");
            }
            return false;
        }
        if (!wd.checkRecoil() || wd.getCurrentAmmo() <= 0) {
            return false;
        }
        boolean irMissile = useIRMis && ((WeaponStats)wd.getStats()).isIRMissile();
        boolean bl = trackMissile = useTrackMis && ((WeaponStats)wd.getStats()).requiresRadar();
        if (irMissile || trackMissile) {
            double nextShootTime;
            int shootTimeDiff = turret.f_19797_ - turret.getLastShootTick();
            if ((double)shootTimeDiff < (nextShootTime = Math.min((double)((WeaponStats)wd.getStats()).getMaxAge() * 0.1, 120.0))) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT already shoot recently {} < {}", (Object)shootTimeDiff, (Object)nextShootTime);
                }
                return false;
            }
            EntityWeapon<?> weapon = turret.getFiredWeapon();
            if (weapon != null && (!weapon.m_213877_() || weapon.isDiscardedButTicking())) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT weapon still alive {}", weapon);
                }
                return false;
            }
        }
        if (irMissile) {
            if (UtilVehicleEntity.isOnGroundOrWater((Entity)target)) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT target in on ground or in water");
                }
                return false;
            }
            aimError += 6.0f;
        } else if (trackMissile) {
            EntityVehicle vehicle = turret.getParentVehicle();
            if (vehicle == null) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT parent vehicle null");
                }
                return false;
            }
            if (!vehicle.radarSystem.hasRadar()) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT no radar");
                }
                return false;
            }
            if (!vehicle.radarSystem.hasTarget((Entity)target)) {
                if (TurretShootGoal.debugTurretAI()) {
                    LOGGER.info("NO SHOOT does not have radar target");
                }
                return false;
            }
            vehicle.radarSystem.selectTarget((Entity)target);
            aimError += 3.0f;
        }
        Vec3 turretLook = turret.m_20154_();
        Vec3 diff = targetPos.m_82546_(turret.m_146892_());
        double angle = UtilGeometry.angleBetweenDegrees((Vec3)diff, (Vec3)turretLook);
        if (angle > (double)aimError) {
            if (TurretShootGoal.debugTurretAI()) {
                LOGGER.info("NO SHOOT not looking close enough {} > {}", (Object)angle, (Object)Float.valueOf(aimError));
            }
            return false;
        }
        if (TurretShootGoal.debugTurretAI()) {
            LOGGER.info("SHOULD SHOOT");
        }
        return true;
    }

    public static ShootFunction getShootFunctionByMob(Mob mob) {
        if (mob.m_6095_().m_204039_(ModTags.EntityTypes.TURRET_SHOOT_SMART)) {
            return SMART_SHOOT;
        }
        if (mob.m_6095_().m_204039_(ModTags.EntityTypes.TURRET_SHOOT_NORMAL)) {
            return NORMAL_SHOOT;
        }
        if (mob.m_6095_().m_204039_(ModTags.EntityTypes.TURRET_SHOOT_STUPID)) {
            return STUPID_SHOOT;
        }
        if (mob.m_6095_().m_204039_(ModTags.EntityTypes.TURRET_SHOOT_DUMBASS)) {
            return DUMBASS_SHOOT;
        }
        if (mob.m_6095_().m_204039_(ModTags.EntityTypes.TURRET_SHOOT_RANDOM)) {
            return RANDOM_SHOOT;
        }
        return CANT_SHOOT;
    }

    public TurretShootGoal(Mob mob, EntityTurret turret) {
        this(mob, turret, TurretShootGoal.getShootFunctionByMob(mob));
    }

    public TurretShootGoal(Mob mob, EntityTurret turret, ShootFunction shootFunction) {
        this.mob = mob;
        this.turret = turret;
        this.shootFunction = shootFunction;
    }

    public void m_8037_() {
        super.m_8037_();
        LivingEntity target = this.mob.m_5448_();
        if (TurretShootGoal.debugTurretAI()) {
            LOGGER.info("shoot goal tick {}", (Object)target);
        }
        if (target == null) {
            this.prevTargetPos = null;
            return;
        }
        this.prevTargetPos = this.shootFunction.shoot(this.mob, this.turret, target, this.prevTargetPos);
    }

    public boolean m_8036_() {
        if (!this.mob.f_19853_.m_46469_().m_46207_(DSCGameRules.MOBS_USE_TURRETS)) {
            return false;
        }
        if (this.mob.m_20202_() == null || !this.mob.m_20202_().equals((Object)this.turret)) {
            return false;
        }
        LivingEntity target_entity = this.mob.m_5448_();
        return target_entity != null && target_entity.m_6084_();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.prevTargetPos = null;
    }

    public boolean m_183429_() {
        return true;
    }

    public static interface ShootFunction {
        @Nonnull
        public Vec3 shoot(Mob var1, EntityTurret var2, @Nonnull LivingEntity var3, @Nullable Vec3 var4);
    }
}

