/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.instance;

import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.weapon.WeaponShootParameters;
import com.onewhohears.dscombat.data.weapon.instance.MissileInstance;
import com.onewhohears.dscombat.data.weapon.stats.TrackMissileStats;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.entity.weapon.TrackEntityMissile;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import net.minecraft.world.entity.Entity;

public class TrackMissileInstance<T extends TrackMissileStats>
extends MissileInstance<T> {
    public TrackMissileInstance(T stats) {
        super(stats);
    }

    @Override
    public boolean couldRadarWeaponTargetEntity(Entity entity, Entity radar) {
        if (!super.couldRadarWeaponTargetEntity(entity, radar)) {
            return false;
        }
        boolean groundWater = UtilVehicleEntity.isOnGroundOrWater(entity);
        TrackMissileStats.TargetType targetType = ((TrackMissileStats)this.getStats()).getTargetType();
        if (targetType == TrackMissileStats.TargetType.AIR && groundWater) {
            return false;
        }
        if (targetType == TrackMissileStats.TargetType.GROUND && !groundWater) {
            return false;
        }
        return targetType != TrackMissileStats.TargetType.WATER || entity.m_20069_();
    }

    @Override
    public EntityWeapon<?> getShootEntity(WeaponShootParameters params) {
        TrackEntityMissile missile = (TrackEntityMissile)super.getShootEntity(params);
        if (missile == null) {
            return null;
        }
        if (params.vehicle == null) {
            return missile;
        }
        RadarSystem radar = params.vehicle.radarSystem;
        if (!radar.hasRadar()) {
            this.setLaunchFail("error.dscombat.no_radar");
            return null;
        }
        RadarStats.RadarPing ping = radar.getServerSelectedPing();
        if (ping == null) {
            this.setLaunchFail("error.dscombat.no_target_selected");
            return null;
        }
        if (ping.entityType.isMissile()) {
            this.setLaunchFail("error.dscombat.cannot_target_missiles");
            return null;
        }
        Entity target = radar.getSelectedTarget();
        if (target == null) {
            this.setLaunchFail("error.dscombat.no_target_selected");
            return null;
        }
        boolean groundWater = UtilVehicleEntity.isOnGroundOrWater(target);
        TrackMissileStats.TargetType targetType = ((TrackMissileStats)this.getStats()).getTargetType();
        if (targetType == TrackMissileStats.TargetType.AIR && groundWater) {
            this.setLaunchFail("error.dscombat.air_target_only");
            return null;
        }
        if (targetType == TrackMissileStats.TargetType.GROUND && !groundWater) {
            this.setLaunchFail("error.dscombat.ground_target_only");
            return null;
        }
        if (targetType == TrackMissileStats.TargetType.WATER && !target.m_20069_()) {
            this.setLaunchFail("error.dscombat.water_target_only");
            return null;
        }
        missile.target = target;
        return missile;
    }
}

