/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.radar;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.weapon.NonTickingMissileManager;
import com.onewhohears.dscombat.data.weapon.RadarTargetTypes;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RadarInstance<T extends RadarStats>
extends JsonPresetInstance<T> {
    private String slotId = "";
    private Vec3 pos = Vec3.f_82478_;
    private boolean freshTargets;
    private int scanTicks;
    private final List<RadarStats.RadarPing> pings = new ArrayList<RadarStats.RadarPing>();
    private int maxCheckDist = 150;

    public RadarInstance(T stats) {
        super(stats);
    }

    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        this.setSlot(tag.m_128461_("slotId"));
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128359_("slotId", this.slotId);
        return tag;
    }

    public void resetPings(List<RadarStats.RadarPing> vehiclePings) {
        for (RadarStats.RadarPing ping : this.pings) {
            vehiclePings.remove(ping);
        }
        this.pings.clear();
    }

    public void tickUpdateTargets(EntityVehicle radar, List<RadarStats.RadarPing> vehiclePings) {
        if (radar.m_9236_().m_5776_()) {
            return;
        }
        if (this.scanTicks <= ((RadarStats)this.getStats()).getScanRate()) {
            ++this.scanTicks;
            this.freshTargets = false;
            return;
        }
        this.scanTicks = 0;
        this.maxCheckDist = (Integer)Config.COMMON.maxBlockCheckDepth.get();
        this.resetPings(vehiclePings);
        this.freshTargets = true;
        Entity controller = radar.getControllingPlayerOrBot();
        RadarStats.RadarMode mode = radar.getRadarMode();
        if (mode.isOff()) {
            return;
        }
        AABB radarArea = this.getRadarBoundingBox((Entity)radar);
        double rangeSqr = ((RadarStats)this.getStats()).getRange() * ((RadarStats)this.getStats()).getRange();
        if (((RadarStats)this.getStats()).isScanPlayers() && (mode.isPlayersOrBots() || mode.canScan(RadarStats.RadarMode.VEHICLES))) {
            this.scanPlayersVehicles(radar, controller, vehiclePings, rangeSqr, mode.isPlayersOnly(), mode.isVehiclesOnly());
        }
        if (((RadarStats)this.getStats()).isScanMobs() && mode.canScan(RadarStats.RadarMode.MOBS)) {
            this.scanMobs(radar, controller, vehiclePings, radarArea);
        }
        if (((RadarStats)this.getStats()).isScanMissiles() && mode.isOn()) {
            this.scanMissiles(radar, controller, vehiclePings, rangeSqr);
        }
    }

    private void scanPlayersVehicles(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, double rangeSqr, boolean playersOnly, boolean vehiclesOnly) {
        MinecraftServer server = radar.m_9236_().m_7654_();
        if (server == null) {
            return;
        }
        List players = server.m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            this.handleScanPlayerVehicle(radar, controller, vehiclePings, rangeSqr, playersOnly, vehiclesOnly, (Entity)player, true);
        }
        Collection<Entity> entities = TrackableEntitiesManager.getTrackableEntities();
        for (Entity entity : entities) {
            this.handleScanPlayerVehicle(radar, controller, vehiclePings, rangeSqr, playersOnly, vehiclesOnly, entity, false);
        }
    }

    private void handleScanPlayerVehicle(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, double rangeSqr, boolean playersOnly, boolean vehiclesOnly, Entity entity, boolean player) {
        EntityVehicle pingEntity;
        if (entity.m_5833_()) {
            return;
        }
        if (playersOnly && !player) {
            return;
        }
        if (entity.m_20280_((Entity)radar) > rangeSqr) {
            return;
        }
        if (!entity.m_9236_().m_46472_().equals((Object)radar.m_9236_().m_46472_())) {
            return;
        }
        EntityVehicle vehicle = null;
        if (!player && entity instanceof EntityVehicle) {
            EntityVehicle ev;
            vehicle = ev = (EntityVehicle)entity;
        } else {
            Entity entity2 = entity.m_20201_();
            if (entity2 instanceof EntityVehicle) {
                EntityVehicle ev;
                vehicle = ev = (EntityVehicle)entity2;
            }
        }
        if (vehiclesOnly && vehicle == null) {
            return;
        }
        EntityVehicle entityVehicle = pingEntity = vehicle != null ? vehicle : entity;
        if (!player) {
            if (this.alreadyScanned(vehiclePings, (Entity)pingEntity)) {
                return;
            }
            if (vehicle == null) {
                if (entity.m_20201_().m_6095_().m_204039_(ModTags.EntityTypes.VEHICLE)) {
                    pingEntity = entity.m_20201_();
                } else {
                    return;
                }
            }
        }
        double stealth = 1.0;
        if (vehicle != null) {
            stealth = vehicle.getStealth();
        }
        if (this.isFailBasicCheck(radar, (Entity)pingEntity, stealth)) {
            return;
        }
        RadarStats.PingEntityType pingEntityType = player ? (vehicle != null || pingEntity.m_19879_() != entity.m_19879_() ? RadarStats.PingEntityType.VEHICLE_PLAYER : RadarStats.PingEntityType.PLAYER) : (vehicle != null || pingEntity.m_19879_() != entity.m_19879_() ? RadarStats.PingEntityType.VEHICLE_BOT : RadarStats.PingEntityType.HOSTILE_MOB);
        RadarStats.RadarPing p = new RadarStats.RadarPing((Entity)pingEntity, this.checkFriendly(controller, (Entity)pingEntity), pingEntityType);
        vehiclePings.add(p);
        this.pings.add(p);
        if (vehicle != null && !radar.m_7307_((Entity)vehicle)) {
            vehicle.lockedOnto((Entity)radar);
        }
    }

    private boolean alreadyScanned(List<RadarStats.RadarPing> vehiclePings, Entity entity) {
        for (RadarStats.RadarPing ping : vehiclePings) {
            if (ping.id != entity.m_19879_()) continue;
            return true;
        }
        return false;
    }

    private void scanMobs(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, AABB radarArea) {
        for (int j = 0; j < RadarTargetTypes.get().getRadarMobClasses().size(); ++j) {
            Class<? extends Entity> clazz = RadarTargetTypes.get().getRadarMobClasses().get(j);
            List list = radar.f_19853_.m_45976_(clazz, radarArea);
            for (Entity entity : list) {
                if (entity.m_20159_() || this.isFailBasicCheck(radar, entity, 1.0)) continue;
                RadarStats.RadarPing p = new RadarStats.RadarPing(entity, this.checkFriendly(controller, entity), RadarStats.PingEntityType.FRIENDLY_MOB);
                vehiclePings.add(p);
                this.pings.add(p);
            }
        }
    }

    private void scanMissiles(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, double rangeSqr) {
        Collection<Entity> list = TrackableEntitiesManager.getTrackableEntities();
        for (Entity entity : list) {
            if (!entity.m_6095_().m_204039_(ModTags.EntityTypes.MISSILE)) continue;
            this.handleMissile(radar, controller, vehiclePings, rangeSqr, entity);
        }
        for (EntityMissile entityMissile : NonTickingMissileManager.getMissiles()) {
            this.handleMissile(radar, controller, vehiclePings, rangeSqr, (Entity)entityMissile);
        }
    }

    private void handleMissile(EntityVehicle radar, Entity controller, List<RadarStats.RadarPing> vehiclePings, double rangeSqr, Entity target) {
        if (target.m_20280_((Entity)radar) > rangeSqr) {
            return;
        }
        if (!target.m_9236_().m_46472_().equals((Object)radar.m_9236_().m_46472_())) {
            return;
        }
        if (this.isFailBasicCheck(radar, target, -1.0)) {
            return;
        }
        RadarStats.RadarPing p = new RadarStats.RadarPing(target, this.checkFriendly(controller, target), RadarStats.PingEntityType.MISSILE);
        vehiclePings.add(p);
        this.pings.add(p);
    }

    private boolean checkFriendly(Entity controller, Entity target) {
        if (target == null) {
            return false;
        }
        if (controller == null) {
            return false;
        }
        return UtilEntity.areEntitiesAllied((Entity)target, (Entity)controller);
    }

    private boolean isFailBasicCheck(EntityVehicle radar, Entity ping, double stealth) {
        if (radar.equals(ping)) {
            return true;
        }
        if (!this.groundCheck(ping)) {
            return true;
        }
        if (radar.isVehicleOf(ping)) {
            return true;
        }
        if (!this.checkTargetRange((Entity)radar, ping, stealth)) {
            return true;
        }
        return !this.checkCanSee((Entity)radar, ping);
    }

    private boolean groundCheck(Entity ping) {
        if (((RadarStats)this.getStats()).getThroWaterRange() > 0.0 && ping.m_20069_()) {
            return true;
        }
        boolean groundWater = UtilVehicleEntity.isOnGroundOrWater(ping);
        if (((RadarStats)this.getStats()).isScanGround() && groundWater) {
            return true;
        }
        return ((RadarStats)this.getStats()).isScanAir() && !groundWater && UtilVehicleEntity.getDistFromGround(ping, 6, false) >= 6;
    }

    private boolean checkTargetRange(Entity radar, Entity target, double stealth) {
        double areaMin;
        float dist = radar.m_20270_(target);
        if (((RadarStats)this.getStats()).getFov() == -1.0 ? (double)dist > ((RadarStats)this.getStats()).getRange() : !UtilGeometry.isPointInsideCone((Vec3)target.m_20182_(), (Vec3)radar.m_20182_().m_82549_(this.pos), (Vec3)radar.m_20154_(), (double)((RadarStats)this.getStats()).getFov(), (double)((RadarStats)this.getStats()).getRange())) {
            return false;
        }
        if (stealth == -1.0) {
            return true;
        }
        double area = UtilVehicleEntity.getRadarCrossSectionalArea(target, radar.m_20182_()) * stealth;
        return area >= (areaMin = (1.0 - Math.pow(((RadarStats)this.getStats()).getRange(), -2.0) * Math.pow((double)dist - ((RadarStats)this.getStats()).getRange(), 2.0)) * ((RadarStats)this.getStats()).getSensitivity());
    }

    private boolean checkCanSee(Entity radar, Entity target) {
        return UtilEntity.canPosSeeEntity((Vec3)radar.m_20182_().m_82549_(this.pos), (Entity)target, (int)this.maxCheckDist, (double)(((RadarStats)this.getStats()).getThroWaterRange() + 1.0), (double)((RadarStats)this.getStats()).getThroGroundRange());
    }

    private AABB getRadarBoundingBox(Entity radar) {
        double x = radar.m_20185_() + this.pos.f_82479_;
        double y = radar.m_20186_() + this.pos.f_82480_;
        double z = radar.m_20189_() + this.pos.f_82481_;
        double w = ((RadarStats)this.getStats()).getRange();
        return new AABB(x + w, y + w, z + w, x - w, y - w, z - w);
    }

    public boolean isFreshTargets() {
        return this.freshTargets;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public boolean isInternal() {
        return Objects.equals(this.slotId, "");
    }

    public void setSlot(String slotId) {
        this.slotId = slotId;
    }

    public void setInternal() {
        this.slotId = "";
    }

    public void setPos(Vec3 pos) {
        this.pos = pos;
    }

    public boolean idMatch(String id, String slotId) {
        if (slotId == null) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.getStatsId().equals(id) && slotId.equals(this.slotId);
    }
}

