/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.instance;

import com.onewhohears.dscombat.data.parts.SlotType;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.data.crafting.IngredientStack;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class PartInstance<T extends PartStats>
extends JsonPresetInstance<T> {
    public static final int PARSE_VERSION = 3;
    protected boolean isSetup = false;
    private String slotId = "";
    private Vec3 relPos = Vec3.f_82478_;
    private EntityVehicle parent;
    private boolean damaged;
    private boolean dirty;

    public PartInstance(T stats) {
        super(stats);
    }

    public void setFilled(String param) {
    }

    public void setParamNotFilled(String param) {
    }

    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        this.damaged = tag.m_128471_("damaged");
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128379_("readnbt", true);
        tag.m_128405_("parse_version", 3);
        tag.m_128359_("part", this.getStatsId());
        tag.m_128379_("damaged", this.damaged);
        return tag;
    }

    public void readBuffer(FriendlyByteBuf buffer) {
        this.damaged = buffer.readBoolean();
    }

    public void writeBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(((PartStats)this.getStats()).getId());
        buffer.writeBoolean(this.damaged);
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void onReceiveClientSync() {
        this.dirty = false;
    }

    public void onSendClientSync() {
        this.dirty = false;
    }

    public int getFlares() {
        return 0;
    }

    public float getWeight() {
        return ((PartStats)this.getStats()).getWeight();
    }

    public EntityVehicle getParent() {
        return this.parent;
    }

    public Vec3 getRelPos() {
        return this.relPos;
    }

    protected void setParent(EntityVehicle parent) {
        this.parent = parent;
    }

    protected void setRelPos(Vec3 pos) {
        this.relPos = pos;
    }

    public String getSlotId() {
        return this.slotId;
    }

    protected void setSlotId(String id) {
        this.slotId = id;
    }

    protected void serverSetup(EntityVehicle craft, String slotId, Vec3 pos) {
        if (this.hasExternalEntity() && !this.isDamaged()) {
            this.addEntity(craft, slotId, pos);
        }
    }

    protected void clientSetup(EntityVehicle craft, String slotId, Vec3 pos) {
    }

    public boolean canSetup() {
        return !this.isDamagedPreventsSetup() || !this.isDamaged();
    }

    public boolean isDamagedPreventsSetup() {
        return true;
    }

    public void setup(EntityVehicle craft, String slotId, Vec3 pos) {
        this.setSlotId(slotId);
        this.setParent(craft);
        this.setRelPos(pos);
        if (craft.f_19853_.f_46443_) {
            this.clientSetup(craft, slotId, pos);
        } else {
            this.serverSetup(craft, slotId, pos);
        }
        this.isSetup = true;
    }

    protected void serverRemove(String slotId) {
        if (this.hasExternalEntity()) {
            this.removeEntity(slotId);
        }
    }

    protected void clientRemove(String slotId) {
    }

    public void remove(EntityVehicle parent, String slotId) {
        if (parent.f_19853_.f_46443_) {
            this.clientRemove(slotId);
        } else {
            this.serverRemove(slotId);
        }
        this.isSetup = false;
    }

    public void tick(String slotId) {
    }

    public void clientTick(String slotId) {
    }

    public ItemStack getNewItemStack() {
        ItemStack s = ((PartStats)this.getStats()).getItem().m_7968_();
        s.m_41751_(this.writeNBT());
        return s;
    }

    public boolean isEntitySetup(String slotId, EntityVehicle craft) {
        for (EntityPart part : craft.getPartEntities()) {
            if (!part.getPartType().is(((PartStats)this.getStats()).getType()) || !part.getSlotId().equals(slotId)) continue;
            return true;
        }
        return false;
    }

    public void removeEntity(String slotId) {
        if (this.getParent() == null) {
            return;
        }
        for (EntityPart part : this.getParent().getPartEntities()) {
            if (!part.getSlotId().equals(slotId)) continue;
            part.m_146870_();
        }
    }

    public void addEntity(EntityVehicle craft, String slotId, Vec3 pos) {
        if (this.isEntitySetup(slotId, craft)) {
            return;
        }
        EntityPart part = this.createEntity(craft, slotId);
        if (part == null) {
            return;
        }
        this.setUpPartEntity(part, craft, slotId, pos, ((PartStats)this.getStats()).getExternalEntityDefaultHealth());
        craft.f_19853_.m_7967_((Entity)part);
    }

    @Nullable
    protected EntityPart createEntity(EntityVehicle vehicle, String slotId) {
        return (EntityPart)((PartStats)this.getStats()).getExernalEntityType().m_20615_(vehicle.f_19853_);
    }

    public void setUpPartEntity(EntityPart part, EntityVehicle craft, String slotId, Vec3 pos, float health) {
        part.setPreset(this.getStatsId());
        part.setSlotId(slotId);
        part.setRelativePos(pos);
        part.m_146884_(craft.m_20182_());
        part.setHealth(health);
        part.m_20329_((Entity)craft);
    }

    public boolean isCompatible(SlotType type) {
        return ((PartStats)this.getStats()).isCompatible(type);
    }

    public boolean isDamaged() {
        return this.damaged;
    }

    protected void setDamaged(boolean damaged) {
        this.damaged = damaged;
        this.setDirty();
    }

    public void onDamaged(EntityVehicle parent, String slotId) {
        this.setDamaged(true);
        this.remove(parent, slotId);
    }

    public void onRepaired(EntityVehicle parent, String slotId, Vec3 pos) {
        this.setDamaged(false);
        if (this.canSetup()) {
            this.setup(parent, slotId, pos);
        }
    }

    public void addToolTips(List<Component> tips, TooltipFlag isAdvanced) {
        if (this.isDamaged()) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.damaged").m_6270_(Style.f_131099_.m_178520_(0xCC0000)));
            if (!((PartStats)this.getStats()).getRepairCost().isEmpty()) {
                Style repairStyle = Style.f_131099_.m_178520_(0xE88888);
                MutableComponent repairCost = UtilMCText.translatable((String)"info.dscombat.repair_cost").m_130946_(": ").m_6270_(repairStyle);
                for (Ingredient cost : ((PartStats)this.getStats()).getRepairCost()) {
                    int num = 1;
                    if (cost instanceof IngredientStack) {
                        IngredientStack is = (IngredientStack)cost;
                        num = is.cost;
                    }
                    repairCost.m_7220_(cost.m_43908_()[0].m_41611_()).m_130946_("(" + num + ")");
                }
                tips.add((Component)repairCost);
            }
        }
        ((PartStats)this.getStats()).addToolTips(tips, isAdvanced);
    }

    public MutableComponent getItemName() {
        return ((PartStats)this.getStats()).getDisplayNameComponent().m_6270_(Style.f_131099_.m_178520_(0x55FF55));
    }

    public boolean hasExternalEntity() {
        return ((PartStats)this.getStats()).hasExternalEntity();
    }

    public float getPushThrust(VehicleStats vehicleStats) {
        return 0.0f;
    }

    public float getSpinThrust(VehicleStats vehicleStats) {
        return 0.0f;
    }

    public float getEngineHeat(VehicleStats vehicleStats) {
        return 0.0f;
    }

    public float getFuelPerTick(VehicleStats vehicleStats) {
        return 0.0f;
    }

    public float getCurrentFuel() {
        return 0.0f;
    }

    public float getMaxFuel() {
        return 0.0f;
    }

    public boolean canJetesin() {
        return this.hasExternalEntity() && !((PartStats)this.getStats()).isSeat();
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    public Vec3 getRotInertia() {
        if (this.parent == null || UtilGeometry.isZero((Vec3)this.relPos)) {
            return Vec3.f_82478_;
        }
        return new Vec3((double)this.getWeight() * (this.relPos.f_82480_ * this.relPos.f_82480_ + this.relPos.f_82481_ * this.relPos.f_82481_), (double)this.getWeight() * (this.relPos.f_82479_ * this.relPos.f_82479_ + this.relPos.f_82481_ * this.relPos.f_82481_), (double)this.getWeight() * (this.relPos.f_82479_ * this.relPos.f_82479_ + this.relPos.f_82480_ * this.relPos.f_82480_)).m_82490_(0.5);
    }

    public float getAfterburnerMaxPushThrust(@NotNull VehicleStats stats) {
        return 0.0f;
    }
}

