/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.client;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.client.model.obj.HardCodedModelAnims;
import com.onewhohears.dscombat.client.model.obj.ObjPartModel;
import com.onewhohears.dscombat.data.parts.client.PartClientType;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.onewholibs.data.jsonpreset.CustomAnimStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PartClientStats<E extends EntityPart>
extends CustomAnimStats<ObjPartModel<E>, E> {
    public PartClientStats(ResourceLocation key, JsonObject json) {
        super(key, json);
    }

    protected ObjPartModel<E> createModel() {
        JsonObject model_data;
        if (this.getJsonData().has("model_data") && (model_data = this.getJsonData().get("model_data").getAsJsonObject()).has("hard_coded_model_anims")) {
            return HardCodedModelAnims.getPartModel(model_data.get("hard_coded_model_anims").getAsString());
        }
        return this.createNotHardCodedModel();
    }

    protected ObjPartModel<E> createNotHardCodedModel() {
        return new ObjPartModel(this.getModelId(), this.getCustomAnims(), this.getKeyframeAnimIds());
    }

    public JsonPresetType getType() {
        return PartClientType.STANDARD;
    }

    @Nullable
    public JsonPresetInstance<?> createPresetInstance() {
        return null;
    }

    public static class Builder
    extends CustomAnimStats.CustomAnimStatsBuilder<Builder> {
        public Builder setHardCodedModel(String id) {
            this.getModelData().addProperty("hard_coded_model_anims", id);
            return this;
        }

        public Builder setWeaponRackStats(int maxAmmoNum, float dX, float dY) {
            this.setFloat("dX", dX);
            this.setFloat("dY", dY);
            return (Builder)this.setInt("maxAmmoNum", maxAmmoNum);
        }

        public static Builder createStandard(String name) {
            return new Builder(name, PartClientType.STANDARD);
        }

        public static Builder createTurret(String name) {
            return new Builder(name, PartClientType.TURRET);
        }

        public static Builder createRadar(String name) {
            return new Builder(name, PartClientType.RADAR);
        }

        public static Builder createWeaponRack(String name) {
            return new Builder(name, PartClientType.WEAPON_RACK);
        }

        protected Builder(String name, JsonPresetType type) {
            super("dscombat", name, type);
        }
    }
}

